/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "fsrv_locl.h"

RCSID("$Id: fileserver.c,v 1.4 1999/07/12 08:56:13 map Exp $");

static struct rx_service *fsservice;
static struct rx_service *volservice;

/*
 *
 */

static void
sigusr1 (int foo)
{
    printf ("sigusr1\n");
    chdir ("/vicepa");
    exit (3); /* XXX profiler */
}

/*
 * Main
 */

#define MILKO_SERVICE_KEYFILE "/usr/arla/etc/srvtab"

int 
main(int argc, char **argv)
{
    int ret;

    printf ("fileserver booting\n");

    ports_init();
    cell_init(0);

    network_kerberos_init (MILKO_SERVICE_KEYFILE);

    ret = network_init(htons(afsport), "fs", FS_SERVICE_ID, 
		       RXAFS_ExecuteRequest, &fsservice, NULL);
    if (ret)
	errx (1, "network_init failed with %d", ret);

    ret = network_init(htons(afsvolport), "volser", VOLSER_SERVICE_ID, 
		       VOLSER_ExecuteRequest, &volservice, NULL);
    if (ret)
	errx (1, "network_init failed with %d", ret);

    signal (SIGUSR1, sigusr1);
    umask (S_IRWXG|S_IRWXO); /* 077 */

    vld_boot();
    vld_init();

    rx_SetMaxProcs(fsservice,5) ;
    rx_SetMaxProcs(volservice,5) ;

    printf ("fileserver started, serving data\n");

    rx_StartServer(1) ;

    abort() ;
    return 0;
}


