dnl
dnl $Id: linux-func-full-name-hash-8bit.m4,v 1.1 1999/05/15 22:45:32 assar Exp $
dnl

dnl
dnl try to figure out if full_name_hash works with 8bit characters
dnl


AC_DEFUN(AC_LINUX_FUNC_FULL_NAME_HASH_8BIT, [
AC_CACHE_CHECK(if full_name_hash works with 8bit characters,
ac_cv_func_full_name_hash_work_8bit,
AC_TRY_RUN(
#define __KERNEL__
#include <linux/list.h>
#include <linux/dcache.h>
unsigned my_full_name_hash(const unsigned char *name, unsigned len)
{
  unsigned long hash = init_name_hash();
  while(len--)
    hash = partial_name_hash(*name++, hash);
  return end_name_hash(hash);
}

int main()
{
  return full_name_hash ("", 1) != my_full_name_hash ("", 1);
},
ac_cv_func_full_name_hash_work_8bit=yes,
ac_cv_func_full_name_hash_work_8bit=no,
ac_cv_func_full_name_hash_work_8bit=no))

if test "$ac_cv_func_full_name_hash_work_8bit" = "yes"; then
  AC_DEFINE(HAVE_FULL_NAME_HASH_8BIT, 1,
	[define if full_name_hash handles 8bit characters correctly])
fi
])
