dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl $Id: acinclude.m4,v 1.1 1999/05/15 22:48:04 assar Exp $
dnl
dnl Only put things that for some reason can't live in the `cf'
dnl directory in this file.
dnl

dnl $xId: misc.m4,v 1.1 1997/12/14 15:59:04 joda Exp $
dnl
define(upcase,`echo $1 | tr abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ`)dnl

dnl 
dnl See if there is any X11 present
dnl
dnl $Id: check-x.m4,v 1.1 1999/07/13 21:20:51 joda Exp $

AC_DEFUN(KRB_CHECK_X,[
AC_PATH_XTRA

# try to figure out if we need any additional ld flags, like -R
# and yes, the autoconf X test is utterly broken
if test "$no_x" != yes; then
	AC_CACHE_CHECK(for special X linker flags,krb_cv_sys_x_libs_rpath,[
	ac_save_libs="$LIBS"
	ac_save_cflags="$CFLAGS"
	CFLAGS="$CFLAGS $X_CFLAGS"
	krb_cv_sys_x_libs_rpath=""
	krb_cv_sys_x_libs=""
	for rflag in "" "-R" "-R " "-rpath "; do
		if test "$rflag" = ""; then
			foo="$X_LIBS"
		else
			foo=""
			for flag in $X_LIBS; do
			case $flag in
			-L*)
				foo="$foo $flag `echo $flag | sed \"s/-L/$rflag/\"`"
				;;
			*)
				foo="$foo $flag"
				;;
			esac
			done
		fi
		LIBS="$ac_save_libs $foo -lX11"
		AC_TRY_RUN([
		#include <X11/Xlib.h>
		foo()
		{
		XOpenDisplay(NULL);
		}
		main()
		{
		return 0;
		}
		], krb_cv_sys_x_libs_rpath="$rflag"; krb_cv_sys_x_libs="$foo"; break,:)
	done
	LIBS="$ac_save_libs"
	CFLAGS="$ac_save_cflags"
	])
	X_LIBS="$krb_cv_sys_x_libs"
fi
])

dnl
dnl $Id: func-ntohl.m4,v 1.1 1999/05/15 22:45:26 assar Exp $
dnl
dnl test for how to do ntohl
dnl

AC_DEFUN(AC_FUNC_NTOHL, [
AC_REQUIRE([AC_CANONICAL_TARGET])
AC_MSG_CHECKING(for efficient ntohl)
AC_CACHE_VAL(ac_cv_func_ntohl, [
case "$target_cpu" in
changequote(, )dnl
i[3-9]86) AC_TRY_RUN(
changequote([, ])dnl
[
#if defined(__GNUC__) && defined(i386)
unsigned long foo(unsigned long x)
{
  asm("bswap %0" : "=r" (x) : "0" (x));
  return x;
}
#endif

int main(void)
{
  return foo(0x12345678) != 0x78563412;
}
],
ac_cv_func_ntohl="bswap",
ac_cv_func_ntohl="ntohl",
ac_cv_func_ntohl="ntohl") ;;
alpha) ac_cv_func_ntohl="bswap32" ;;
*) ac_cv_func_ntohl="ntohl" ;;
esac
])
AC_MSG_RESULT($ac_cv_func_ntohl)
AC_DEFINE_UNQUOTED(EFF_NTOHL, $ac_cv_func_ntohl, [how should ntohl be done?])
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

dnl
dnl Test for kerberos lib files
dnl
dnl $Id: krb-lib-where.m4,v 1.1 1999/05/15 22:45:29 assar Exp $
dnl

AC_DEFUN(AC_KRB_LIB_WHERE1, [
saved_LIBS=$LIBS
LIBS="$saved_LIBS -L$1 -lkrb -ldes"
AC_TRY_LINK(,
[dest_tkt();],
[ac_cv_found_krb_lib=yes
 ac_cv_is_krb5=no],
ac_cv_found_krb_lib=no)
if test "$ac_cv_found_krb_lib" = "no"; then
  LIBS="$saved_LIBS -L$1 -lkrb4 -ldes425 -lkrb5 -lcrypto -lcom_err"
  AC_TRY_LINK(, 
  [dest_tkt();],
  [ac_cv_found_krb_lib=yes
   ac_cv_is_krb5=yes],
  ac_cv_found_krb_lib=no)
fi
LIBS=$saved_LIBS
])

AC_DEFUN(AC_KRB_LIB_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos libraries in $i)
      AC_KRB_LIB_WHERE1($i)
      if test "$ac_cv_found_krb_lib" = "yes" ; then
        ac_cv_krb_where_lib=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(no found)
      fi
    done
])


dnl
dnl Test for kerberos include files
dnl
dnl $Id: krb-inc-where.m4,v 1.1 1999/05/15 22:45:29 assar Exp $
dnl

AC_DEFUN(AC_KRB_INC_WHERE1, [
saved_CPPFLAGS=$CPPFLAGS
CPPFLAGS="$saved_CPPFLAGS -I$1"
AC_TRY_COMPILE([#include <krb.h>],
[struct ktext foo;],
ac_cv_found_krb_inc=yes,
ac_cv_found_krb_inc=no)
if test "$ac_cv_found_krb_inc" = "no"; then
  CPPFLAGS="$saved_CPPFLAGS -I$1 -I$1/kerberosIV"
  AC_TRY_COMPILE([#include <krb.h>],
  [struct ktext foo;],
  [ac_cv_found_krb_inc=yes
   ac_cv_is_krb5=yes],
  ac_cv_found_krb_inc=no)
fi
CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_KRB_INC_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos headers in $i)
      AC_KRB_INC_WHERE1($i)
      if test "$ac_cv_found_krb_inc" = "yes"; then
        ac_cv_krb_where_inc=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(no found)
      fi
    done
])

dnl
dnl $Id: type-msghdr.m4,v 1.1 1999/05/15 22:45:35 assar Exp $
dnl

dnl
dnl Check for struct msghdr
dnl

AC_DEFUN(AC_TYPE_MSGHDR, [

AC_CACHE_CHECK(for struct msghdr, ac_cv_struct_msghdr, [
AC_EGREP_HEADER([struct msghdr], sys/socket.h,
ac_cv_struct_msghdr=yes,
ac_cv_struct_msghdr=no)
])
if test "$ac_cv_struct_msghdr" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_MSGHDR, 1, [define if you have struct msghdr])
fi
])

dnl
dnl $Id: type-iovec.m4,v 1.2 1999/06/24 01:44:58 assar Exp $
dnl

dnl
dnl Check for struct iovec
dnl

AC_DEFUN(AC_TYPE_IOVEC, [

AC_CACHE_CHECK(for struct iovec, ac_cv_struct_iovec, [
AC_EGREP_HEADER(
changequote(, )dnl
struct[ 	]*iovec,
changequote([,])dnl
sys/uio.h,
ac_cv_struct_iovec=yes,
ac_cv_struct_iovec=no)
])
if test "$ac_cv_struct_iovec" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_IOVEC, 1, [define if you have struct iovec])
fi
])

dnl
dnl $Id: type-krb-principal.m4,v 1.1 1999/05/15 22:45:35 assar Exp $
dnl

dnl
dnl Check for struct krb_principal
dnl

AC_DEFUN(AC_TYPE_KRB_PRINCIPAL, [

AC_CACHE_CHECK(for krb_principal, ac_cv_struct_krb_principal, [
if test "$ac_cv_found_krb" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
CPPFLAGS="-I${KRB_INC_DIR} $CPPFLAGS"
AC_EGREP_HEADER(krb_principal, krb.h,ac_cv_struct_krb_principal=yes)
CPPFLAGS="${save_CPPFLAGS}"
eval "ac_cv_struct_krb_principal=${ac_cv_struct_krb_principal-no}"
else
dnl Gross hack to avoid struct krb_principal get defined when we don't have krb
eval "ac_cv_struct_krb_principal=no"
fi
])
if test "$ac_cv_struct_krb_principal" = "yes"; then
  AC_DEFINE(HAVE_KRB_PRINCIPAL, 1, [define if you have a struct krb_principal])
fi
])

dnl
dnl $Id: func-krb-get-err-text.m4,v 1.1 1999/05/15 22:45:26 assar Exp $
dnl

dnl
dnl Check for krb_get_err_text
dnl

AC_DEFUN(AC_FUNC_KRB_GET_ERR_TEXT, [

AC_CACHE_CHECK(for krb_get_err_text, ac_cv_func_krb_get_err_text, [
if test "$ac_cv_found_krb" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
save_LIBS="${LIBS}"
CPPFLAGS="${KRB_INC_FLAGS} ${CPPFLAGS}"
LIBS="${KRB_LIB_FLAGS} ${LIBS}"
AC_TRY_LINK([#include <krb.h>],
[krb_get_err_text(0);],
ac_cv_func_krb_get_err_text=yes,
ac_cv_func_krb_get_err_text=no)
CPPFLAGS="${save_CPPFLAGS}"
LIBS="${save_LIBS}"
fi
])
if test "$ac_cv_func_krb_get_err_text" = "yes"; then
  AC_DEFINE(HAVE_KRB_GET_ERR_TEXT, 1, [define if you have krb_get_err_text])
fi
])

dnl
dnl $Id: func-krb-kdctimeofday.m4,v 1.1 1999/07/14 20:37:59 assar Exp $
dnl

dnl
dnl Check for krb_kdctimeofday
dnl

AC_DEFUN(AC_FUNC_KRB_KDCTIMEOFDAY, [

AC_CACHE_CHECK(for krb_kdctimeofday, ac_cv_func_krb_kdctimeofday, [
if test "$ac_cv_found_krb" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
save_LIBS="${LIBS}"
CPPFLAGS="${KRB_INC_FLAGS} ${CPPFLAGS}"
LIBS="${KRB_LIB_FLAGS} ${LIBS}"
AC_TRY_LINK([#include <krb.h>],
[krb_kdctimeofday(0);],
ac_cv_func_krb_kdctimeofday=yes,
ac_cv_func_krb_kdctimeofday=no)
CPPFLAGS="${save_CPPFLAGS}"
LIBS="${save_LIBS}"
fi
])
if test "$ac_cv_func_krb_kdctimeofday" = "yes"; then
  AC_DEFINE(HAVE_KRB_KDCTIMEOFDAY, 1, [define if you have krb_kdctimeofday])
fi
])

dnl $Id: find-func-no-libs.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl
dnl Look for function in any of the specified libraries
dnl

dnl AC_FIND_FUNC_NO_LIBS(func, libraries, includes, arguments)
AC_DEFUN(AC_FIND_FUNC_NO_LIBS, [
AC_FIND_FUNC_NO_LIBS2([$1], ["" $2], [$3], [$4])])

dnl $Id: find-func-no-libs2.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl
dnl Look for function in any of the specified libraries
dnl

dnl AC_FIND_FUNC_NO_LIBS2(func, libraries, includes, arguments)
AC_DEFUN(AC_FIND_FUNC_NO_LIBS2, [

AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_funclib_$1,
[
if eval "test \"\$ac_cv_func_$1\" != yes" ; then
	ac_save_LIBS="$LIBS"
	for ac_lib in $2; do
		if test -n "$ac_lib"; then 
			ac_lib="-l$ac_lib"
		else
			ac_lib=""
		fi
		LIBS="$ac_lib $ac_save_LIBS"
		AC_TRY_LINK([$3],[$1($4)],eval "if test -n \"$ac_lib\";then ac_cv_funclib_$1=$ac_lib; else ac_cv_funclib_$1=yes; fi";break)
	done
	eval "ac_cv_funclib_$1=\${ac_cv_funclib_$1-no}"
	LIBS="$ac_save_LIBS"
fi
])

eval "ac_res=\$ac_cv_funclib_$1"

dnl autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
@@@libs="$libs $2"@@@
END

# $1
eval "ac_tr_func=HAVE_[]upcase($1)"
eval "ac_tr_lib=HAVE_LIB[]upcase($ac_res | sed -e 's/-l//')"
eval "LIB_$1=$ac_res"

case "$ac_res" in
	yes)
	eval "ac_cv_func_$1=yes"
	eval "LIB_$1="
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_MSG_RESULT([yes])
	;;
	no)
	eval "ac_cv_func_$1=no"
	eval "LIB_$1="
	AC_MSG_RESULT([no])
	;;
	*)
	eval "ac_cv_func_$1=yes"
	eval "ac_cv_lib_`echo "$ac_res" | sed 's/-l//'`=yes"
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_DEFINE_UNQUOTED($ac_tr_lib)
	AC_MSG_RESULT([yes, in $ac_res])
	;;
esac
AC_SUBST(LIB_$1)
])

dnl
dnl $Id
dnl

AC_DEFUN(AC_HAVE_GETCONF, [
AC_CHECK_PROG(ac_cv_prog_getconf,[getconf],yes)
])

AC_DEFUN(AC_GETCONF_FLAGS,[
if test "$ac_cv_prog_getconf" = "yes";then
AC_MSG_CHECKING([if we have $1])
FOO="`getconf $1 2>/dev/null >/dev/null`"
if test $? = 0 ;then
$2="[$]$2 $FOO"
AC_MSG_RESULT([yes $FOO])
else
AC_MSG_RESULT(no)
fi
fi

])

AC_DEFUN(AC_CHECK_LFS, [
if test "${ac_cv_prog_getconf-set}" = set ;then
AC_HAVE_GETCONF
fi
AC_GETCONF_FLAGS(LFS_CFLAGS, CFLAGS)
AC_GETCONF_FLAGS(LFS_LDFLAGS, LDFLAGS)
])



dnl
dnl $Id
dnl
dnl
dnl test for GNU libc
dnl

AC_DEFUN(AC_CHECK_GLIBC,[
AC_CACHE_CHECK([for glibc],ac_cv_libc_glibc,[
AC_EGREP_CPP(yes,
[#include <features.h>
#ifdef __GLIBC__
yes
#endif
],
eval "ac_cv_libc_glibc=yes",
eval "ac_cv_libc_glibc=no")])
if test "$ac_cv_libc_glibc" = "yes";then
	AC_DEFINE(HAVE_GLIBC, 1,
	[define if you have a glibc-based system])
fi
])

dnl
dnl $Id: c-function.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

dnl
dnl Test for __FUNCTION__
dnl

AC_DEFUN(AC_C___FUNCTION__, [
AC_MSG_CHECKING(for __FUNCTION__)
AC_CACHE_VAL(ac_cv___function__, [
AC_TRY_RUN([
#include <string.h>

static char *foo()
{
  return __FUNCTION__;
}

int main()
{
  return strcmp(foo(), "foo") != 0;
}
],
ac_cv___function__=yes,
ac_cv___function__=no,
ac_cv___function__=no)])
if test "$ac_cv___function__" = "yes"; then
  AC_DEFINE(HAVE___FUNCTION__, 1, [define if your compiler has __FUNCTION__])
fi
AC_MSG_RESULT($ac_cv___function__)
])


dnl
dnl $Id: c-attribute.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

dnl
dnl Test for __attribute__
dnl

AC_DEFUN(AC_C___ATTRIBUTE__, [
AC_MSG_CHECKING(for __attribute__)
AC_CACHE_VAL(ac_cv___attribute__, [
AC_TRY_COMPILE([
#include <stdlib.h>
],
[
static void foo(void) __attribute__ ((noreturn));

static void
foo(void)
{
  exit(1);
}
],
ac_cv___attribute__=yes,
ac_cv___attribute__=no)])
if test "$ac_cv___attribute__" = "yes"; then
  AC_DEFINE(HAVE___ATTRIBUTE__, 1, [define if your compiler has __attribute__])
fi
AC_MSG_RESULT($ac_cv___attribute__)
])


dnl $Id: krb-find-db.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl
dnl find a suitable database library
dnl
dnl AC_FIND_DB(libraries)
AC_DEFUN(KRB_FIND_DB, [

lib_dbm=no
lib_db=no

for i in $1; do

	if test "$i"; then
		m="lib$i"
		l="-l$i"
	else
		m="libc"
		l=""
	fi	

	AC_MSG_CHECKING(for dbm_open in $m)
	AC_CACHE_VAL(ac_cv_krb_dbm_open_$m, [

	save_LIBS="$LIBS"
	LIBS="$l $LIBS"
	AC_TRY_RUN([
#include <unistd.h>
#include <fcntl.h>
#include <ndbm.h>
int main()
{
  DBM *d;

  d = dbm_open("conftest", O_RDWR | O_CREAT, 0666);
  if(d == NULL)
    return 1;
  dbm_close(d);
  return 0;
}], [
	if test -f conftest.db; then
		ac_res=db
	else
		ac_res=dbm
	fi], ac_res=no, ac_res=no)

	LIBS="$save_LIBS"

	eval ac_cv_krb_dbm_open_$m=$ac_res])
	eval ac_res=\$ac_cv_krb_dbm_open_$m
	AC_MSG_RESULT($ac_res)

	if test "$lib_dbm" = no -a $ac_res = dbm; then
		lib_dbm="$l"
	elif test "$lib_db" = no -a $ac_res = db; then
		lib_db="$l"
		break
	fi
done

AC_MSG_CHECKING(for NDBM library)
ac_ndbm=no
if test "$lib_db" != no; then
	LIB_DBM="$lib_db"
	ac_ndbm=yes
	AC_DEFINE(HAVE_NEW_DB, 1, [Define if NDBM really is DB (creates files ending in .db).])
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
elif test "$lib_dbm" != no; then
	LIB_DBM="$lib_dbm"
	ac_ndbm=yes
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
else
	LIB_DBM=""
	ac_res=no
fi
test "$ac_ndbm" = yes && AC_DEFINE(NDBM, 1, [Define if you have NDBM (and not DBM)])dnl
AC_SUBST(LIB_DBM)
DBLIB="$LIB_DBM"
AC_SUBST(DBLIB)
AC_MSG_RESULT($ac_res)

])

dnl $Id: krb-sys-nextstep.m4,v 1.2 1999/05/16 13:44:46 assar Exp $
dnl
dnl
dnl NEXTSTEP is not posix compliant by default,
dnl you need a switch -posix to the compiler
dnl

AC_DEFUN(AC_KRB_SYS_NEXTSTEP, [
AC_MSG_CHECKING(for NEXTSTEP)
AC_CACHE_VAL(krb_cv_sys_nextstep,
AC_EGREP_CPP(yes, 
[#if defined(NeXT) && !defined(__APPLE__)
	yes
#endif 
], krb_cv_sys_nextstep=yes, krb_cv_sys_nextstep=no) )
if test "$krb_cv_sys_nextstep" = "yes"; then
  CFLAGS="$CFLAGS -posix"
  CPPFLAGS="$CPPFLAGS -posix"
  LIBS="$LIBS -posix"
fi
AC_MSG_RESULT($krb_cv_sys_nextstep)
])

dnl $Id: krb-sys-aix.m4,v 1.1 1999/05/15 22:45:31 assar Exp $
dnl
dnl
dnl AIX have a very different syscall convention
dnl
AC_DEFUN(AC_KRB_SYS_AIX, [
AC_MSG_CHECKING(for AIX)
AC_CACHE_VAL(krb_cv_sys_aix,
AC_EGREP_CPP(yes, 
[#ifdef _AIX
	yes
#endif 
], krb_cv_sys_aix=yes, krb_cv_sys_aix=no) )
AC_MSG_RESULT($krb_cv_sys_aix)
])

dnl $Id: krb-struct-winsize.m4,v 1.1 1999/05/15 22:45:31 assar Exp $
dnl
dnl
dnl Search for struct winsize
dnl

AC_DEFUN(AC_KRB_STRUCT_WINSIZE, [
AC_MSG_CHECKING(for struct winsize)
AC_CACHE_VAL(ac_cv_struct_winsize, [
ac_cv_struct_winsize=no
for i in sys/termios.h sys/ioctl.h; do
AC_EGREP_HEADER(
changequote(, )dnl
struct[ 	]*winsize,dnl
changequote([,])dnl
$i, ac_cv_struct_winsize=yes; break)dnl
done
])
if test "$ac_cv_struct_winsize" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_WINSIZE, 1, [define if struct winsize is declared in sys/termios.h])
fi
AC_MSG_RESULT($ac_cv_struct_winsize)
AC_EGREP_HEADER(ws_xpixel, termios.h, 
	AC_DEFINE(HAVE_WS_XPIXEL, 1, [define if struct winsize has ws_xpixel]))
AC_EGREP_HEADER(ws_ypixel, termios.h, 
	AC_DEFINE(HAVE_WS_YPIXEL, 1, [define if struct winsize has ws_ypixel]))
])

dnl $Id: find-func.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl
dnl AC_FIND_FUNC(func, libraries, includes, arguments)
AC_DEFUN(AC_FIND_FUNC, [
AC_FIND_FUNC_NO_LIBS([$1], [$2], [$3], [$4])
if test -n "$LIB_$1"; then
	LIBS="$LIB_$1 $LIBS"
fi
])

dnl $Id: broken-snprintf.m4,v 1.1 1999/05/15 22:45:18 assar Exp $
dnl
AC_DEFUN(AC_BROKEN_SNPRINTF, [
AC_CACHE_CHECK(for working snprintf,ac_cv_func_snprintf_working,
ac_cv_func_snprintf_working=yes
AC_TRY_RUN([
#include <stdio.h>
#include <string.h>
int main()
{
changequote(`,')dnl
	char foo[3];
changequote([,])dnl
	snprintf(foo, 2, "12");
	return strcmp(foo, "1");
}],:,ac_cv_func_snprintf_working=no,:))

if test "$ac_cv_func_snprintf_working" = yes; then
	AC_DEFINE(HAVE_SNPRINTF, 1, [define if you have a working snprintf])
fi
if test "$ac_cv_func_snprintf_working" = yes; then
	AC_NEED_PROTO([#include <stdio.h>],snprintf)
fi
])

AC_DEFUN(AC_BROKEN_VSNPRINTF,[
AC_CACHE_CHECK(for working vsnprintf,ac_cv_func_vsnprintf_working,
ac_cv_func_vsnprintf_working=yes
AC_TRY_RUN([
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

int foo(int num, ...)
{
changequote(`,')dnl
	char bar[3];
changequote([,])dnl
	va_list arg;
	va_start(arg, num);
	vsnprintf(bar, 2, "%s", arg);
	va_end(arg);
	return strcmp(bar, "1");
}


int main()
{
	return foo(0, "12");
}],:,ac_cv_func_vsnprintf_working=no,:))

if test "$ac_cv_func_vsnprintf_working" = yes; then
	AC_DEFINE(HAVE_VSNPRINTF, 1, [define if you have a working vsnprintf])
fi
if test "$ac_cv_func_vsnprintf_working" = yes; then
	AC_NEED_PROTO([#include <stdio.h>],vsnprintf)
fi
])

dnl $Id: need-proto.m4,v 1.1 1999/05/15 22:45:33 assar Exp $
dnl
dnl
dnl Check if we need the prototype for a function
dnl

dnl AC_NEED_PROTO(includes, function)

AC_DEFUN(AC_NEED_PROTO, [
if test "$ac_cv_func_$2+set" != set -o "$ac_cv_func_$2" = yes; then
AC_CACHE_CHECK([if $2 needs a prototype], ac_cv_func_$2_noproto,
AC_TRY_COMPILE([$1],
[struct foo { int foo; } xx;
extern int $2 (struct foo*);
$2(&xx);
],
eval "ac_cv_func_$2_noproto=yes",
eval "ac_cv_func_$2_noproto=no"))
define([foo], [NEED_]translit($2, [a-z], [A-Z])[_PROTO])
if test "$ac_cv_func_$2_noproto" = yes; then
	AC_DEFINE(foo, 1, [define if the system is missing a prototype for $2()])
fi
undefine([foo])
fi
])

dnl
dnl $Id: have-types.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl

AC_DEFUN(AC_HAVE_TYPES, [
for i in $1; do
        AC_HAVE_TYPE($i)
done
: << END
changequote(`,')dnl
@@@funcs="$funcs $1"@@@
changequote([,])dnl
END
])

dnl $Id: have-type.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl
dnl check for existance of a type

dnl AC_HAVE_TYPE(TYPE)
AC_DEFUN(AC_HAVE_TYPE, [
cv=`echo "$1" | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING(for $1)
AC_CACHE_VAL([ac_cv_type_$cv],
AC_TRY_COMPILE([#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif],
[$1 foo;],
eval "ac_cv_type_$cv=yes",
eval "ac_cv_type_$cv=no"))dnl
AC_MSG_RESULT(`eval echo \\$ac_cv_type_$cv`)
if test `eval echo \\$ac_cv_type_$cv` = yes; then
  ac_tr_hdr=HAVE_`echo $1 | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  AC_DEFINE_UNQUOTED($ac_tr_hdr, 1)
fi
])
dnl dnl autoheader tricks *sigh*
dnl : << END
dnl @@@syms="$syms $ac_tr_hdr"@@@
dnl END

dnl $Id: check-var.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl AC_CHECK_VAR(includes, variable)
AC_DEFUN(AC_CHECK_VAR, [
AC_MSG_CHECKING(for $2)
AC_CACHE_VAL(ac_cv_var_$2, [
AC_TRY_LINK([extern int $2;
int foo() { return $2; }],
	    [foo()],
	    ac_cv_var_$2=yes, ac_cv_var_$2=no)
])
define([foo], [HAVE_]translit($2, [a-z], [A-Z]))

AC_MSG_RESULT(`eval echo \\$ac_cv_var_$2`)
if test `eval echo \\$ac_cv_var_$2` = yes; then
	AC_DEFINE_UNQUOTED(foo, 1, [define if you have $2])
	AC_CHECK_DECLARATION([$1],[$2])
fi
undefine([foo])
])

dnl $Id: check-declaration.m4,v 1.1 1999/05/15 22:45:21 assar Exp $
dnl
dnl
dnl Check if we need the declaration of a variable
dnl

dnl AC_HAVE_DECLARATION(includes, variable)
AC_DEFUN(AC_CHECK_DECLARATION, [
AC_MSG_CHECKING([if $2 is properly declared])
AC_CACHE_VAL(ac_cv_var_$2_declaration, [
AC_TRY_COMPILE([$1
extern struct { int foo; } $2;],
[$2.foo = 1;],
eval "ac_cv_var_$2_declaration=no",
eval "ac_cv_var_$2_declaration=yes")
])

define(foo, [HAVE_]translit($2, [a-z], [A-Z])[_DECLARATION])

AC_MSG_RESULT($ac_cv_var_$2_declaration)
if eval "test \"\$ac_cv_var_$2_declaration\" = yes"; then
	AC_DEFINE(foo, 1, [define if your system declares $2])
fi
undefine([foo])
])

dnl $Id: find-if-not-broken.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl
dnl
dnl Mix between AC_FIND_FUNC and AC_BROKEN
dnl

AC_DEFUN(AC_FIND_IF_NOT_BROKEN,
[AC_FIND_FUNC([$1], [$2], [$3], [$4])
if eval "test \"$ac_cv_func_$1\" != yes"; then
LIBOBJS[]="$LIBOBJS $1.o"
fi
AC_SUBST(LIBOBJS)dnl
])

dnl
dnl $Id: func-hstrerror-const.m4,v 1.2 1999/05/28 13:18:04 assar Exp $
dnl
dnl Test if hstrerror wants const or not
dnl

dnl AC_FUNC_HSTRERROR_CONST(includes, function)

AC_DEFUN(AC_FUNC_HSTRERROR_CONST, [
AC_CACHE_CHECK([if hstrerror needs const], ac_cv_func_hstrerror_const,
AC_TRY_COMPILE([netdb.h],
[const char *hstrerror(int);],
ac_cv_func_hstrerror_const=no,
ac_cv_func_hstrerror_const=yes))
if test "$ac_cv_func_hstrerror_const" = "yes"; then
	AC_DEFINE(NEED_HSTRERROR_CONST, 1, [define if hstrerror is const])
fi
])

dnl $Id: broken.m4,v 1.1 1999/05/15 22:45:18 assar Exp $
dnl
dnl
dnl Same as AC _REPLACE_FUNCS, just define HAVE_func if found in normal
dnl libraries 

AC_DEFUN(AC_BROKEN,
[for ac_func in $1
do
AC_CHECK_FUNC($ac_func, [
ac_tr_func=HAVE_[]upcase($ac_func)
AC_DEFINE_UNQUOTED($ac_tr_func)],[LIBOBJS[]="$LIBOBJS ${ac_func}.o"])
dnl autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
END
done
AC_SUBST(LIBOBJS)dnl
])

dnl
dnl $Id: func-getvfsbyname.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl

AC_DEFUN(AC_FUNC_GETVFSBYNAME, [
AC_CHECK_FUNCS(getvfsbyname)
if test "$ac_cv_func_getvfsbyname" = "yes"; then
AC_CACHE_CHECK(for two argument getvfsbyname,
ac_cv_func_getvfsbyname_two_arguments,
AC_TRY_COMPILE(
[#include <sys/types.h>
#include <sys/param.h>
#include <sys/mount.h>],
[struct vfsconf vfc;
int foo = getvfsbyname("arla", &vfc);
],
ac_cv_func_getvfsbyname_two_arguments=yes,
ac_cv_func_getvfsbyname_two_arguments=no))
if test "$ac_cv_func_getvfsbyname_two_arguments" = "yes"; then
  AC_DEFINE(HAVE_GETVFSBYNAME_TWO_ARGS, 1,
	[define if getvfsbyname takes two arguments])
fi
fi
])

dnl $Id: have-struct-field.m4,v 1.1 1999/05/15 22:45:27 assar Exp $
dnl
dnl check for fields in a structure
dnl
dnl AC_HAVE_STRUCT_FIELD(struct, field, headers)

AC_DEFUN(AC_HAVE_STRUCT_FIELD, [
define(cache_val, translit(ac_cv_type_$1_$2, [A-Z ], [a-z_]))
AC_CACHE_CHECK([for $2 in $1], cache_val,[
AC_TRY_COMPILE([$3],[$1 x; x.$2;],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_$1_$2, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if $1 has field $2.])
	undefine(foo)
fi
undefine(cache_val)
])

dnl
dnl $Id: elf-object-format.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl test for ELF

AC_DEFUN(AC_ELF_OBJECT_FORMAT,[
AC_CACHE_CHECK([for ELF object format], ac_cv_sys_elf_object_format,[
ac_cv_sys_elf_object_format=no
echo 'int foo;' > conftest.$ac_ext
if AC_TRY_EVAL(ac_compile); then
	case `file conftest.o 2> /dev/null` in
	*ELF*)	ac_cv_sys_elf_object_format=yes ;;
	esac
fi
rm -f conftest*])])

dnl
dnl $Id: kernel.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl

dnl 
dnl Check for where the kernel is stored
dnl

AC_DEFUN(AC_KERNEL,
[
dnl XXX XXX XXX *** this test sucks *** XXX XXX XXX
if test "$ac_kernel_ld" = ""; then
if test "$ac_cv_sys_elf_object_format" = yes; then
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -R $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
else
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -A $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
fi
fi
])

dnl
dnl $Id: check-kernel-funcs.m4,v 1.1 1999/05/15 22:45:22 assar Exp $
dnl

dnl AC_CHECK_KERNEL_FUNCS(functions...)
AC_DEFUN(AC_CHECK_KERNEL_FUNCS,
[for ac_func in $1
do
AC_CHECK_KERNEL_FUNC($ac_func)
done
]
: << END
@@@funcs="$funcs [patsubst([$1], [\w+], [kernel_\&])]"@@@
END
)

dnl
dnl $Id: check-kernel-func.m4,v 1.1 1999/05/15 22:45:21 assar Exp $
dnl

dnl AC_CHECK_KERNEL_FUNC(func, param, [includes])
AC_DEFUN(AC_CHECK_KERNEL_FUNC,
AC_CHECK_KERNEL($1, ac_cv_kernel_func_$1, [$1]([$2]), $4))

dnl
dnl $Id: check-kernel.m4,v 1.1 1999/05/15 22:45:23 assar Exp $
dnl

dnl AC_CHECK_KERNEL(name, cv, magic, [includes])
AC_DEFUN(AC_CHECK_KERNEL,
[AC_MSG_CHECKING([for $1 in kernel])
AC_CACHE_VAL($2,
[cat > conftest.$ac_ext <<EOF
dnl This sometimes fails to find confdefs.h, for some reason.
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
#include "confdefs.h"
[$4]
int _foo() {
return foo();
}
int foo() {
[$3];
return 0; }
EOF
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS"
if AC_TRY_EVAL(ac_compile) && AC_TRY_EVAL(ac_kernel_ld) && test -s conftest; then
  eval "$2=yes"
else
  eval "$2=no"
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
fi
CFLAGS="$save_CFLAGS"
rm -f conftest*])
changequote(, )dnl
eval "ac_tr_var=HAVE_KERNEL_`echo $1 | tr '[a-z]' '[A-Z]'`"
changequote([, ])dnl

AC_MSG_RESULT(`eval echo \\${$2}`)
if test `eval echo \\${$2}` = yes; then
  AC_DEFINE_UNQUOTED($ac_tr_var, 1)
fi
])

dnl define([foo], [[HAVE_KERNEL_]translit($1, [a-z], [A-Z])])
dnl : << END
dnl @@@syms="$syms foo"@@@
dnl END
dnl undefine([foo])

dnl
dnl $Id: check-kernel-var.m4,v 1.1 1999/05/15 22:45:22 assar Exp $
dnl

dnl AC_CHECK_KERNEL_VAR(var, type, [includes])
AC_DEFUN(AC_CHECK_KERNEL_VAR,
AC_CHECK_KERNEL($1, ac_cv_kernel_var_$1, [extern $2 $1; $2 foo = $1], $4)
: << END
@@@funcs="$funcs kernel_$1"@@@
END
)

dnl
dnl $Id
dnl

dnl
dnl check for vfssw in sys/vnode.h and sys/mount.h with -D_KERNEL -D_LKM

AC_DEFUN(AC_CHECK_KERNEL_VFSSW, [

AC_CACHE_CHECK(for vfssw, ac_cv_var_vfssw,
saved_CPPFLAGS=$CPPFLAGS
CPPFLAGS="$CPPFLAGS -D_KERNEL -D_LKM"
AC_EGREP_HEADER(vfssw, sys/vnode.h, ac_cv_var_vfssw=yes, ac_cv_var_vfssw=no)
if test "$ac_cv_var_vfssw" = "no"; then
   AC_EGREP_HEADER(vfssw, sys/mount.h, ac_cv_var_vfssw=yes, ac_cv_var_vfssw=no)
fi
CPPFLAGS=$saved_CPPFLAGS
)
if test "$ac_cv_var_vfssw" = "yes"; then
  AC_DEFINE(HAVE_VFSSW, 1, [define if you have a vfssw])
fi
])

dnl
dnl $Id: check-kernel-vop-t.m4,v 1.1 1999/05/15 22:45:22 assar Exp $
dnl

dnl
dnl try to find out if we have a vop_t
dnl

AC_DEFUN(AC_CHECK_KERNEL_VOP_T, [

AC_CACHE_CHECK(for vop_t, ac_cv_type_vop_t,
AC_EGREP_HEADER(vop_t, sys/vnode.h, ac_cv_type_vop_t=yes, ac_cv_type_vop_t=no))

if test "$ac_cv_type_vop_t" = "yes"; then
	AC_DEFINE(HAVE_VOP_T, 1, [define if you have a vop_t])
fi
])

dnl
dnl $Id: bsd-vfs-object-create.m4,v 1.1 1999/05/15 22:45:19 assar Exp $
dnl

dnl
dnl check for number of arguments to vfs_object_create
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_OBJECT_CREATE, [
AC_CHECK_KERNEL_FUNCS(vfs_object_create)
if test "$ac_cv_kernel_func_vfs_object_create" = "yes"; then
AC_CACHE_CHECK(if vfs_object_create takes four arguments,
ac_cv_func_vfs_object_create_four_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#include <sys/vnode.h>
],
[vfs_object_create(0, 0, 0, 0);],
ac_cv_func_vfs_object_create_four_args=yes,
ac_cv_func_vfs_object_create_four_args=no))
if test "$ac_cv_func_vfs_object_create_four_args" = "yes"; then
	ac_foo=
	AC_DEFINE(HAVE_FOUR_ARGUMENT_VFS_OBJECT_CREATE, 1,
	[if vfs_object_create takes four arguments])
fi
fi
])

dnl
dnl $Id: try-compile-kernel.m4,v 1.1 1999/05/15 22:45:34 assar Exp $
dnl

AC_DEFUN(AC_TRY_COMPILE_KERNEL,[
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS"
AC_TRY_COMPILE([$1], [$2], [$3], [$4])
CFLAGS="$save_CFLAGS"
])

dnl
dnl $Id: bsd-vop-lock.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

dnl
dnl Find out if VOP_LOCK takes one, two, or three arguments
dnl

AC_DEFUN(AC_BSD_FUNC_VOP_LOCK, [
save_CFLAGS="${CFLAGS}"
CFLAGS="${CFLAGS} -I."

AC_CACHE_CHECK(if VOP_LOCK takes one argument, ac_cv_func_vop_lock_one_arg,
AC_TRY_COMPILE_KERNEL([#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0)],
ac_cv_func_vop_lock_one_arg=yes,
ac_cv_func_vop_lock_one_arg=no))
if test "$ac_cv_func_vop_lock_one_arg" = yes; then
	AC_DEFINE_UNQUOTED(HAVE_ONE_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes one argument])
fi

AC_CACHE_CHECK(if VOP_LOCK takes two arguments, ac_cv_func_vop_lock_two_args,
AC_TRY_COMPILE_KERNEL([#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0, 0)],
ac_cv_func_vop_lock_two_args=yes,
ac_cv_func_vop_lock_two_args=no))
if test "$ac_cv_func_vop_lock_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes two arguments])
fi

AC_CACHE_CHECK(if VOP_LOCK takes three arguments, ac_cv_func_vop_lock_three_args,
AC_TRY_COMPILE_KERNEL([#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0, 0, 0)],
ac_cv_func_vop_lock_three_args=yes,
ac_cv_func_vop_lock_three_args=no))
if test "$ac_cv_func_vop_lock_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes three arguments])
fi
CFLAGS="${save_CFLAGS}"
])

dnl
dnl $Id: bsd-vfs-busy.m4,v 1.1 1999/05/15 22:45:19 assar Exp $
dnl

dnl
dnl try to find out if vfs_busy takes three/four arguments
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_BUSY,[
save_CFLAGS="${CFLAGS}"
CFLAGS="${CFLAGS} -I."

AC_CACHE_CHECK(if vfs_busy takes three arguments, ac_cv_func_vfs_busy_three_args,
AC_TRY_COMPILE_KERNEL([#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/ucred.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>],[vfs_busy(0, 0, 0)],
ac_cv_func_vfs_busy_three_args=yes,
ac_cv_func_vfs_busy_three_args=no))
if test "$ac_cv_func_vfs_busy_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VFS_BUSY, 1,
	[define if vfs_busy takes three arguments])
fi

AC_CACHE_CHECK(if vfs_busy takes four arguments, ac_cv_func_vfs_busy_four_args,
AC_TRY_COMPILE_KERNEL([#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/ucred.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>],[vfs_busy(0, 0, 0, 0)],
ac_cv_func_vfs_busy_four_args=yes,
ac_cv_func_vfs_busy_four_args=no))
if test "$ac_cv_func_vfs_busy_four_args" = yes; then
	AC_DEFINE(HAVE_FOUR_ARGUMENT_VFS_BUSY, 1,
	[define if vfs_busy takes four arguments])
fi
CFLAGS="${save_CFLAGS}"
])

dnl
dnl $Id: bsd-vget.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_VGET, [
save_CFLAGS="${CFLAGS}"
CFLAGS="${CFLAGS} -I."
AC_CACHE_CHECK(if vget takes two arguments, ac_cv_func_vget_two_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[vget(0, 0)],
ac_cv_func_vget_two_args=yes,
ac_cv_func_vget_two_args=no))
if test "$ac_cv_func_vget_two_args" = yes; then
	AC_DEFINE_UNQUOTED(HAVE_TWO_ARGUMENT_VGET, 1,
	[define if vget takes two arguments])
fi

AC_CACHE_CHECK(if vget takes three arguments, ac_cv_func_vget_three_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[vget(0, 0, 0)],
ac_cv_func_vget_three_args=yes,
ac_cv_func_vget_three_args=no))
if test "$ac_cv_func_vget_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VGET, 1,
	[define if vget takes three arguments])
fi
CFLAGS="${save_CFLAGS}"
])

dnl
dnl $Id: bsd-func-suser.m4,v 1.1 1999/05/15 22:45:19 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_SUSER, [
AC_CACHE_CHECK(if suser takes two arguments,
ac_cv_func_suser_two_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
], [suser(NULL, NULL)],
ac_cv_func_suser_two_args=yes,
ac_cv_func_suser_two_args=no))
if test "$ac_cv_func_suser_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_SUSER, 1,
	[define if suser takes two arguments])
fi
])

dnl
dnl $Id: bsd-func-vfs-getnewfsid.m4,v 1.1 1999/05/15 22:45:19 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_GETNEWFSID, [
AC_CHECK_KERNEL_FUNCS(vfs_getnewfsid)
if test "$ac_cv_kernel_func_vfs_getnewfsid" = "yes"; then
AC_CACHE_CHECK(if vfs_getnewfsid takes two arguments,
ac_cv_func_vfs_getnewfsid_two_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>
],
[vfs_getnewfsid(NULL, 0);],
ac_cv_func_vfs_getnewfsid_two_args=yes,
ac_cv_func_vfs_getnewfsid_two_args=no))
if test "$ac_cv_func_vfs_getnewfsid_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_VFS_GETNEWFSID, 1,
	[define if vfs_getnewfsid takes two arguments])
fi
fi
])

dnl
dnl $Id: check-dirsiz.m4,v 1.1 1999/05/15 22:45:21 assar Exp $
dnl

dnl
dnl Check where DIRSIZ lives
dnl

AC_DEFUN(AC_CHECK_DIRSIZ, [

AC_CACHE_CHECK([if DIRSIZ lives in dirent.h], ac_cv_dirsiz_in_dirent,
AC_EGREP_CPP(yes,[#include <dirent.h>
#ifdef DIRSIZE
yes
#endif],
eval "ac_cv_dirsiz_in_dirent=yes",
eval "ac_cv_dirsiz_in_dirent=no"))
if test "$ac_cv_dirsiz_in_dirent" = "yes"; then
  AC_DEFINE(DIRSIZ_IN_DIRENT_H, 1, [define if DIRSIZ is defined in dirent.h])
fi

AC_CACHE_CHECK([if DIRSIZ lives in sys/dir.h], ac_cv_dirsiz_in_sys_dir,
AC_EGREP_CPP(yes,[#include <sys/dir.h>
#ifdef DIRSIZ
yes
#endif],
eval "ac_cv_dirsiz_in_sys_dir=yes",
eval "ac_cv_dirsiz_in_sys_dir=no"))
if test "$ac_cv_dirsiz_in_sys_dir" = "yes"; then
  AC_DEFINE(DIRSIZ_IN_SYS_DIR_H, 1, [define if DIRSIZ is defined in sys/dir.h])
fi

AC_CACHE_CHECK([if _GENERIC_DIRSIZ lives in sys/dirent.h],
ac_cv_generic_dirsiz_in_sys_dirent,
AC_EGREP_CPP(yes,[#include <sys/dirent.h>
#ifdef _GENERIC_DIRSIZ
yes
#endif],
eval "ac_cv_generic_dirsiz_in_sys_dirent=yes",
eval "ac_cv_generic_dirsiz_in_sys_dirent=no"))
if test "$ac_cv_generic_dirsiz_in_sys_dirent" = "yes"; then
  AC_DEFINE(GENERIC_DIRSIZ_IN_SYS_DIRENT_H, 1,
	[define if DIRSIZ is defined in sys/dirent.h])
fi
])

dnl
dnl $Id: have-kernel-struct-field.m4,v 1.1 1999/05/15 22:45:26 assar Exp $
dnl

dnl AC_HAVE_KERNEL_STRUCT_FIELD(includes, struct, type, field)
AC_DEFUN(AC_HAVE_KERNEL_STRUCT_FIELD, [
define(cache_val, translit(ac_cv_struct_$2_$4, [A-Z ], [a-z_]))
AC_CACHE_CHECK([if $2 has a field $4], cache_val, [
AC_TRY_COMPILE_KERNEL([$1],
[struct $2 foo; $3 bar = foo.$4; ],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_STRUCT_$2_$4, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if $2 has field $4])
	undefine(foo)
fi
undefine(cache_val)
])

dnl
dnl $Id: kernel-have-def.m4,v 1.1.2.1 1999/08/09 17:25:43 assar Exp $
dnl

dnl AC_HAVE_KERNEL_DEF(includes, [struct|typedef])
AC_DEFUN(AC_HAVE_KERNEL_DEF, [
define(cache_val, translit(ac_cv_have_def_$2, [A-Z ], [a-z_]))
AC_CACHE_CHECK([if $2 exists], cache_val, [
AC_TRY_COMPILE_KERNEL([$1],
[$2 foo],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_DEF_$2, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if you have $2])
	undefine(foo)
fi
undefine([cache_val])
])

dnl
dnl $Id: linux-getcwd.m4,v 1.1 1999/05/15 22:45:32 assar Exp $
dnl

dnl
dnl Check for getcwd syscall (linux)
dnl

AC_DEFUN(AC_LINUX_GETCWD, [
AC_CACHE_CHECK([for getcwd system call],
ac_cv_sys_getcwd,[
AC_EGREP_CPP(yes,
[#include <linux/unistd.h>
#ifdef __NR_getcwd
yes
#endif
],
ac_cv_sys_getcwd=yes,
ac_cv_sys_getcwd=no)])
if test "$ac_cv_sys_getcwd" = "yes";then
  XFS_SHARED_LIBS="$XFS_SHARED_LIBS libgetcwd.so"
fi
AC_SUBST(XFS_SHARED_LIBS)
])

dnl
dnl $Id: linux-func-read-super-four-args.m4,v 1.2 1999/06/15 11:58:55 map Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_READ_SUPER_FOUR_ARGS, [

AC_CACHE_CHECK(if read_super takes the dir_d argument,
ac_cv_func_read_super_four_args,
AC_TRY_COMPILE_KERNEL([#include <asm/current.h>
#include <linux/fs.h>
],[struct file_system_type xfs_fs_type;
xfs_fs_type.read_super(0,0,0,0);
],
ac_cv_func_read_super_four_args=yes,
ac_cv_func_read_super_four_args=no))
if test "$ac_cv_func_read_super_four_args" = "yes"; then
  AC_DEFINE(HAVE_READ_SUPER_FOUR_ARGS, 1,
	[define if read_super takes four arguments])
fi
])

dnl
dnl $Id: linux-func-follow-link-three-args.m4,v 1.2 1999/06/15 11:58:55 map Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_FOLLOW_LINK_THREE_ARGS, [
AC_CACHE_CHECK(if follow_link takes the follow argument,
ac_cv_func_follow_link_three_args,
AC_TRY_COMPILE_KERNEL([#include <asm/current.h>
#include <linux/fs.h>],
[struct inode_operations xfs_operations;
xfs_operations.follow_link(NULL, NULL, 0);
],
ac_cv_func_follow_link_three_args=yes,
ac_cv_func_follow_link_three_args=no))

if test "$ac_cv_func_follow_link_three_args" = "yes"; then
  AC_DEFINE(HAVE_FOLLOW_LINK_THREE_ARGS, 1,
	[define if follow_link takes three arguments])
fi
])

dnl
dnl $Id: linux-struct-new-stat.m4,v 1.1 1999/05/15 22:45:32 assar Exp $
dnl

AC_DEFUN(AC_LINUX_STRUCT_NEW_STAT, [

AC_CACHE_CHECK([for struct new_stat],
ac_cv_struct_new_stat,[
AC_EGREP_HEADER([struct *new_stat],
[asm/stat.h],
ac_cv_struct_new_stat=yes,
ac_cv_struct_new_stat=no)])
if test "$ac_cv_struct_new_stat" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_NEW_STAT, 1,
	[define if you have a struct new_stat])
fi
])

dnl
dnl $Id: linux-func-full-name-hash-8bit.m4,v 1.1 1999/05/15 22:45:32 assar Exp $
dnl

dnl
dnl try to figure out if full_name_hash works with 8bit characters
dnl


AC_DEFUN(AC_LINUX_FUNC_FULL_NAME_HASH_8BIT, [
AC_CACHE_CHECK(if full_name_hash works with 8bit characters,
ac_cv_func_full_name_hash_work_8bit,
AC_TRY_RUN(
#define __KERNEL__
#include <linux/list.h>
#include <linux/dcache.h>
unsigned my_full_name_hash(const unsigned char *name, unsigned len)
{
  unsigned long hash = init_name_hash();
  while(len--)
    hash = partial_name_hash(*name++, hash);
  return end_name_hash(hash);
}

int main()
{
  return full_name_hash ("", 1) != my_full_name_hash ("", 1);
},
ac_cv_func_full_name_hash_work_8bit=yes,
ac_cv_func_full_name_hash_work_8bit=no,
ac_cv_func_full_name_hash_work_8bit=no))

if test "$ac_cv_func_full_name_hash_work_8bit" = "yes"; then
  AC_DEFINE(HAVE_FULL_NAME_HASH_8BIT, 1,
	[define if full_name_hash handles 8bit characters correctly])
fi
])

dnl
dnl $Id: linux-func-d_alloc_root-two_args.m4,v 1.2 1999/07/22 04:59:34 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_D_ALLOC_ROOT_TWO_ARGS, [
AC_CACHE_CHECK(if d_alloc_root takes two arguments,
ac_cv_func_d_alloc_root_two_args,
AC_TRY_COMPILE_KERNEL([#include <asm/current.h>
#include <linux/fs.h>
#include <linux/dcache.h>],
[
d_alloc_root(NULL, NULL)
],
ac_cv_func_d_alloc_root_two_args=yes,
ac_cv_func_d_alloc_root_two_args=no))

if test "$ac_cv_func_d_alloc_root_two_args" = "yes"; then
  AC_DEFINE(HAVE_D_ALLOC_ROOT_TWO_ARGS, 1,
	[define if d_alloc_root takes two arguments])
fi
])

dnl
dnl $Id: have-linux-kernel-types.m4,v 1.1 1999/05/15 22:45:27 assar Exp $
dnl
dnl Check for types in the Linux kernel
dnl

AC_DEFUN(AC_HAVE_LINUX_KERNEL_TYPES, [
for i in $1; do
        AC_HAVE_LINUX_KERNEL_TYPE($i)
done
: << END
@@@funcs="$funcs patsubst([$1], [\w+], [linux_kernel_\&])"@@@
END
])

dnl
dnl $Id: have-linux-kernel-type.m4,v 1.1 1999/05/15 22:45:27 assar Exp $
dnl
dnl Check for types in the Linux kernel
dnl

dnl AC_HAVE_LINUX_KERNEL_TYPE(type)
AC_DEFUN(AC_HAVE_LINUX_KERNEL_TYPE, [
cv=`echo "$1" | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
AC_MSG_CHECKING(for $i in the linux kernel)
AC_CACHE_VAL(ac_cv_linux_kernel_type_$cv,
AC_TRY_COMPILE([
#define __KERNEL__
#include <linux/types.h>
],
$1 x;
,
eval "ac_cv_linux_kernel_type_$cv=yes",
eval "ac_cv_linux_kernel_type_$cv=no"))dnl
AC_MSG_RESULT(`eval echo \\$ac_cv_linux_kernel_type_$cv`)
if test `eval echo \\$ac_cv_linux_kernel_type_$cv` = yes; then
  ac_tr_hdr=HAVE_LINUX_KERNEL_`echo $1 | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  AC_DEFINE_UNQUOTED($ac_tr_hdr, 1)
fi
])

dnl
dnl $Id: linux-type-wait-queue-head.m4,v 1.2 1999/05/16 16:38:36 assar Exp $
dnl

AC_DEFUN(AC_LINUX_TYPE_WAIT_QUEUE_HEAD_T, [
AC_CACHE_CHECK([for wait_queue_head_t],
ac_cv_type_wait_queue_head_t,[
AC_TRY_COMPILE_KERNEL([#include <linux/wait.h>],
[wait_queue_head_t foo;],
ac_cv_type_wait_queue_head_t=yes,
ac_cv_type_wait_queue_head_t=no)])
if test "$ac_cv_type_wait_queue_head_t" = "yes"; then
  AC_DEFINE(HAVE_WAIT_QUEUE_HEAD_T, 1,
	[define if you have a wait_queue_head_t])
fi
])

dnl
dnl $Id: linux-func-init-wait-queue-head.m4,v 1.1 1999/05/16 23:21:54 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_INIT_WAITQUEUE_HEAD, [
AC_CACHE_CHECK([for init_waitqueue_head],
ac_cv_func_init_waitqueue_head,[
AC_TRY_COMPILE_KERNEL([#include <linux/wait.h>],
[wait_queue_head_t foo;
init_waitqueue_head(&foo)],
ac_cv_func_init_waitqueue_head=yes,
ac_cv_func_init_waitqueue_head=no)])
if test "$ac_cv_func_init_waitqueue_head" = "yes"; then
  AC_DEFINE(HAVE_INIT_WAITQUEUE_HEAD, 1,
	[define if you have a init_waitqueue_head])
fi
])

dnl
dnl $Id: linux-func-init-mutex.m4,v 1.2 1999/06/24 01:47:31 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_INIT_MUTEX, [
AC_CACHE_CHECK([for init_MUTEX],
ac_cv_func_init_mutex, [
AC_EGREP_CPP([init_MUTEX],
[#define __KERNEL__
#include <asm/semaphore.h>],
ac_cv_func_init_mutex=yes,
ac_cv_func_init_mutex=no)])
if test "$ac_cv_func_init_mutex" = "yes"; then
  AC_DEFINE(HAVE_INIT_MUTEX, 1,
	[define if you have a function init_MUTEX])
fi
])

dnl $Id: krb-version.m4,v 1.1 1999/05/15 22:45:31 assar Exp $
dnl
dnl
dnl output a C header-file with some version strings
dnl
AC_DEFUN(AC_KRB_VERSION,[
dnl AC_OUTPUT_COMMANDS([
cat > include/newversion.h.in <<FOOBAR
char *${PACKAGE}_long_version = "@(#)\$Version: $PACKAGE-$VERSION by @USER@ on @HOST@ ($host) @DATE@ \$";
char *${PACKAGE}_version = "$PACKAGE-$VERSION";
FOOBAR

if test -f include/version.h && cmp -s include/newversion.h.in include/version.h.in; then
	echo "include/version.h is unchanged"
	rm -f include/newversion.h.in
else
 	echo "creating include/version.h"
 	User=${USER-${LOGNAME}}
 	Host=`(hostname || uname -n) 2>/dev/null | sed 1q`
 	Date=`date`
	mv -f include/newversion.h.in include/version.h.in
	sed -e "s/@USER@/$User/" -e "s/@HOST@/$Host/" -e "s/@DATE@/$Date/" include/version.h.in > include/version.h
fi
dnl ],host=$host PACKAGE=$PACKAGE VERSION=$VERSION)
])

