#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  pwdx - show the current working directory for given process ids
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <errno.h>

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/* the following was copied from fs/proc/array.c */
#define MAPS_LINE_LENGTH        4096

/*
 *  Get the real process id for the process identified by argument
 */
unsigned int verify_pid(char *arg)
{
	unsigned int pid;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}
	while (fgets(buff, BUFFSIZE, f))
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
	fclose(f);
	return pid;
}

/*
 *  Retrieve the pathname of the current working directory
 */
char *get_cwd_path(char *arg)
{
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char *link_text;

	sprintf(filename, "/proc/%s/cwd", arg);
	if ((readlink(filename, buff, BUFFSIZE)) == -1) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return NULL;
	}

	link_text = malloc(strlen(buff));
	strcpy(link_text, buff);
	return link_text;
}

/*
 *  Nothing to it.
 */
void
do_next_arg(char *arg)
{
	unsigned int pid;
	char *cwd;

	if ((pid = verify_pid(arg)) == 0)
		return;
	if ((cwd = get_cwd_path(arg)) == NULL)
		return;

	printf("%d:\t%s\n", pid, cwd);

	free(cwd);

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpwdx pid ...\n");
		fprintf(stderr, "  (report process working directory)\n");
		exit(0);
	}

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	argv++;
	while (--argc)
	{
		do_next_arg((argv++)[0]);
	}

	exit(0);
}
