#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  pstack - print a symbol-resolved stack backtrace for the given process ids.
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/ptrace.h>

#include "../proc/ps.h"

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/* the following was copied from fs/proc/array.c */
#define MAPS_LINE_LENGTH        4096

unsigned char rflag, xflag;

/* kick me */
void __register_frame_info(void) {}
void __deregister_frame_info(void) {}

/*
 *  Get the real process id for the process identified by argument
 */
unsigned int verify_pid(char *arg)
{
	unsigned int pid;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}
	while (fgets(buff, BUFFSIZE, f))
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
	fclose(f);
	return pid;
}

/*
 *  Retrieve the pathname of the executable
 */
char *get_exec_path(char *arg)
{
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char *link_text;

	sprintf(filename, "/proc/%s/exe", arg);
	if ((readlink(filename, buff, BUFFSIZE)) == -1) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return NULL;
	}

	link_text = malloc(strlen(buff));
	strcpy(link_text, buff);
	return link_text;
}

/*
 *  Find the start of the stack
 */
unsigned long
get_stack(char *arg)
{
	unsigned long stack;
	FILE *f;
	char filename[PROCFILENAMELEN];

	sprintf(filename, "/proc/%s/stat", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}

	fscanf(f, "%*d %*s %*c %*d %*d %*d %*d %*d %*u %*u %*u %*u %*u %*d %*d %*d %*d %*d %*d %*u %*u %*d %*u %*u %*u %*u %*u %*u %lu", &stack);
	fclose(f);
	return stack;
}

#define ARGS 6
#define ARGBYTES (ARGS * sizeof(unsigned long))

/* print my own stack. this is mostly for testing */
void read_self(char *arg)
{
	unsigned i, pid, offset = 0;
	unsigned long stack;
	char *executable;

	if ((pid = verify_pid("self")) == 0)
                return;
        if ((executable = get_exec_path("self")) == NULL)
                return;
        if ((stack = get_stack("self")) == 0)
                return;

        printf("%d:\t%s\n", pid, executable);
        free(executable);

	while (stack) {
 		unsigned long *funcarg;

		(unsigned long) funcarg = stack;

		printf(" 0x%08x %-8s (", (unsigned int)funcarg[5], "unknown");

		for (i = 0; i < ARGS - 2; i++)
			printf("0x%08x%s", (unsigned int) funcarg[i],
					(i == (ARGS - 3) ? ")" : ", "));
		if (offset)
			printf(" + %d", offset);
		printf("\n");
		if (stack != funcarg[4])
			stack = funcarg[4];
		else
			stack = 0;
	}

	return;
}

void read_other(char *arg)
{
	unsigned pid, offset = 0;
	unsigned long stack;
	char *executable;
	int i, result, save;
	char filename[PROCFILENAMELEN];

	if ((pid = verify_pid(arg)) == 0)
                return;
        if ((executable = get_exec_path(arg)) == NULL)
                return;
        if ((stack = get_stack(arg)) == 0)
                return;

        printf("%d:\t%s\n", pid, executable);
        free(executable);

	result = ptrace(PTRACE_ATTACH, pid, 0, 0);
	if (result == -1) {
		sprintf(filename, "attach: /proc/%s", arg);
		perror(filename);
		return;
	}

	while (stack) {
		unsigned funcarg[ARGS-1];

		for (i = 0; i < ARGS; i++) {
			result = ptrace(PTRACE_PEEKDATA, pid, stack, 0);
			if (result == -1) {
				sprintf(filename, "peek: /proc/%s", arg);
				perror(filename);
				ptrace(PTRACE_DETACH, pid, 0, 0);
				return;
			}
			funcarg[i] = result;
			stack += sizeof(long);
		}
		printf(" 0x%08x %-8s (", funcarg[5], "unknown");

		for (i = 0; i < ARGS - 2; i++)
			printf("0x%08x%s", funcarg[i],
					(i == (ARGS - 3) ? ")" : ", "));
		if (offset)
			printf(" + %d", offset);
		printf("\n");
		if (stack != funcarg[4])
			stack = funcarg[4];
		else
			stack = 0;
	}
	ptrace(PTRACE_DETACH, pid, 0, 0);

	return;
}

void
do_next_arg(char *arg)
{
	unsigned pid;

	if (!strncmp("self", arg, 4))
		read_self(arg);

	pid = (unsigned) strtol(arg, (char **)NULL, 10);
	if (errno)
		return;

	if (pid == getpid())
		read_self(arg);
	else
		read_other(arg);

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpstack pid ...\n");
		fprintf(stderr, "  (show process call stack)\n");
		exit(1);
	}

	open_psdb();

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	while (--argc)
	{
		argv++;
		do_next_arg(argv[0]);
	}

	exit(0);
}
