#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  psig - show the signal status of the given process ids.
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#define __USE_GNU
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>

#include <signal.h>

#include <errno.h>

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/* the following was copied from fs/proc/array.c */
#define MAPS_LINE_LENGTH        4096

/*
 *  Get the real process id for the process identified by argument
 */
unsigned int verify_pid(char *arg)
{
	unsigned int pid;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}
	while (fgets(buff, BUFFSIZE, f))
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
	fclose(f);
	return pid;
}

/*
 *  Retrieve the pathname of the executable
 */
char *get_exec_path(char *arg)
{
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char *link_text;

	sprintf(filename, "/proc/%s/exe", arg);
	if ((readlink(filename, buff, BUFFSIZE)) == -1) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return NULL;
	}

	link_text = malloc(strlen(buff));
	strcpy(link_text, buff);
	return link_text;
}

/*
 *  Get signal status from /proc/<pid>/status, and convert to
 *  human readable form.  According to fs/proc/array.c, stat
 *  is obsolete, and status has RT signal info.
 */
void
do_next_arg(char *arg)
{
	unsigned int pid, signal;
	unsigned long pending, blocked, ignored, caught, mask;
	char *executable;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	if ((pid = verify_pid(arg)) == 0)
		return;
	if ((executable = get_exec_path(arg)) == NULL)
		return;

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		free(executable);
		return;
	}

	printf("%d:\t%s\n", pid, executable);
	free(executable);

	while (fgets(buff, BUFFSIZE, f)) {
		/* XXX these only grab LS 32 bits */
		if (!strncmp(buff, "SigPnd:", 7))
			sscanf(buff, "%*s %lx", &pending);
		if (!strncmp(buff, "SigBlk:", 7))
			sscanf(buff, "%*s %lx", &blocked);
		if (!strncmp(buff, "SigIgn:", 7))
			sscanf(buff, "%*s %lx", &ignored);
		if (!strncmp(buff, "SigCgt:", 7))
			sscanf(buff, "%*s %lx", &caught);
	}
	fclose(f);

	/* nb: Solaris also has a /proc/<pid>/sigact that exports
	       the sigaction struct for each signal.  sigh.  */
	/* XXX what to do about RT signal status? */
	for (signal=SIGHUP; signal < _NSIG; signal++) {
		printf("%-26s", strsignal(signal));
		mask = 1 << signal;
		if (pending & mask)
			printf("pending ");
		if (blocked & mask)
			printf("blocked ");
		if (ignored & mask)
			printf("ignored ");
		if (caught & mask)
			printf("caught ");
		if (!(pending & mask) && !(blocked & mask) &&
		    !(ignored & mask) && !(caught & mask))
			printf("default ");
		printf("\n");
	}

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpsig pid ...\n");
		fprintf(stderr, "  (report process signal actions)\n");
		exit(0);
	}

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	argv++;
	while (--argc)
	{
		do_next_arg((argv++)[0]);
	}

	exit(0);
}
