#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  pldd - show the libraries that have been dynamically linked by
**		the given process ids.
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <errno.h>

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/* the following was copied from fs/proc/array.c */
#define MAPS_LINE_LENGTH        4096

/*
 *  Get the real process id for the process identified by argument
 */
unsigned int verify_pid(char *arg)
{
	unsigned int pid;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}
	while (fgets(buff, BUFFSIZE, f))
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
	fclose(f);
	return pid;
}

/*
 *  Retrieve the pathname of the executable
 */
char *get_exec_path(char *arg)
{
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char *link_text;

	sprintf(filename, "/proc/%s/exe", arg);
	if ((readlink(filename, buff, BUFFSIZE)) == -1) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return NULL;
	}

	link_text = malloc(strlen(buff));
	strcpy(link_text, buff);
	return link_text;
}

/*
 *  Walk through the process's maps file, and print the executable
 *  maps other than the program binary.
 */
void
do_next_arg(char *arg)
{
	unsigned int pid;
	char *executable, *name, *a;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[MAPS_LINE_LENGTH];

	if ((pid = verify_pid(arg)) == 0)
		return;
	if ((executable = get_exec_path(arg)) == NULL)
		return;

	sprintf(filename, "/proc/%s/maps", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		free(executable);
		return;
	}

	printf("%d:\t%s\n", pid, executable);

	while (fgets(buff, MAPS_LINE_LENGTH, f)) {
		name = strrchr(buff, ' ');
		if (name == NULL)
			continue;
		name++;
		/* skip anonymous maps */
		if (*name != '/')
			continue;
		/* skip the executable itself */
		name[strlen(name)-1] = '\0';
		if (!(strcmp(name, executable)))
			continue;

		/* if this is an executable map, it's a DLL */
		if ((a = strchr(buff, ' '))) {
			if (a[3] == 'x')
				printf("%s\n", name);
		}
	}
	fclose(f);
	free(executable);

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpldd pid ...\n");
		fprintf(stderr, "  (report process dynamic libraries)\n");
		exit(0);
	}

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	argv++;
	while (--argc)
	{
		do_next_arg((argv++)[0]);
	}

	exit(0);
}
