#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  pmap - print an address space map for the given process ids.
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <dirent.h>
#include <fcntl.h>

#include <errno.h>

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/* the following was copied from fs/proc/array.c */
#define MAPS_LINE_LENGTH        4096

/*
 *  Get the real process id for the process identified by argument
 */
unsigned int verify_pid(char *arg)
{
	unsigned int pid;
	FILE *f;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return 0;
	}
	while (fgets(buff, BUFFSIZE, f))
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
	fclose(f);
	return pid;
}

/*
 *  Retrieve the pathname of the executable
 */
char *get_exec_path(char *arg)
{
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char *link_text;

	sprintf(filename, "/proc/%s/exe", arg);
	if ((readlink(filename, buff, BUFFSIZE)) == -1) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return NULL;
	}

	link_text = malloc(strlen(buff));
	strcpy(link_text, buff);
	return link_text;
}

/*
 *  Get the file/device referred to by the link, stat() it,
 *  and print a nice summary.
 */
void
do_one_file(char *file)
{
	char buff[BUFFSIZE];
	struct stat s;

	memset((void *)buff, 0, BUFFSIZE);
	if ((readlink(file, buff, BUFFSIZE)) == -1)
		return;
	printf("   %s: ", file);

	/* pipes and sockets - not much Linux can do here */
	if (buff[0] != '/') {
		printf("%s\n", buff);
		return;
	}

	/* stat file and print results */
	if ((stat(file, &s)))
		return;

	if (S_ISDIR(s.st_mode))
		printf("S_IFDIR");
	if (S_ISCHR(s.st_mode))
		printf("S_IFCHR");
	if (S_ISBLK(s.st_mode))
		printf("S_IFBLK");
	if (S_ISREG(s.st_mode))
		printf("S_IFREG");
	if (S_ISFIFO(s.st_mode))
		printf("S_IFFIFO");

	printf(" mode:%04o dev:%u,%u ino:%ld uid:%u gid:%u rdev:%u,%u\n",
		(s.st_mode&ACCESSPERMS), major(s.st_dev), minor(s.st_dev),
		s.st_ino, s.st_uid, s.st_gid,
		major(s.st_rdev), minor(s.st_rdev));

	if (S_ISREG(s.st_mode))
		printf("\t%s\n", buff);
	else
		printf("\n");

	return;
}

/*
 *  Walk through the process's fd directory, and read the links.
 */
void
do_next_arg(char *arg)
{
	unsigned int pid;
	char *executable;
	char filename[PROCFILENAMELEN];
	DIR *d;
	struct dirent *ent;

	if ((pid = verify_pid(arg)) == 0)
		return;
	if ((executable = get_exec_path(arg)) == NULL)
		return;

	printf("%d:\t%s\n", pid, executable);
	/* Solaris supports this, Linux doesn't */
	printf("  Current rlimit: unknown\n");
	free(executable);

	sprintf(filename, "/proc/%s/fd", arg);
	if (chdir(filename)) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return;
	}
	if (!(d = opendir(filename))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return;
	}

	while ((ent = readdir(d)))
		if (*(ent->d_name) != '.')
			do_one_file(ent->d_name);

	closedir(d);

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpfiles pid ...\n");
		fprintf(stderr, "  (report process file descriptor info)\n");
		exit(1);
	}

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	while (--argc)
	{
		argv++;
		do_next_arg(argv[0]);
	}

	exit(0);
}
