#ifndef lint
static char rcsid[] = "$Id$";
#endif

/*
**  command-line process tools based on Solaris' /usr/proc/bin
**
**  pcred - return the credentials for given proc ids.
**
**  Version 1.0
**
**  This program is property of Netscape Communications Corporation.
**  This entire comment MUST remain intact.
**
**  Copyright 1999 by Chuck Lever (chuckl@netscape.com)
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <errno.h>

/* these are copied from vmstat.c.  sigh. */
#define BUFFSIZE 1024
#define PROCFILENAMELEN 80

/*
 *  Read /proc/x/status for a process to get credential info.  For
 *  some reason, credential info doesn't appear in the "machine-
 *  readable" /proc/x/stat.
 */
void
do_next_arg(char *arg)
{
	unsigned int pid;
	unsigned long int uid, euid, suid, fsuid;
	unsigned long int gid, egid, sgid, fsgid;
	FILE *f;
	char *g = NULL;
	char filename[PROCFILENAMELEN];
	char buff[BUFFSIZE];
	char groups[BUFFSIZE];

	sprintf(filename, "/proc/%s/status", arg);

	if (!(f = fopen(filename, "r"))) {
		sprintf(filename, "/proc/%s", arg);
		perror(filename);
		return;
	}
	while (fgets(buff, BUFFSIZE, f)) {
		if (!strncmp(buff, "Pid:", 4))
			sscanf(buff, "%*s %d", &pid);
		if (!strncmp(buff, "Uid:", 4))
			sscanf(buff, "%*s %ld %ld %ld %ld",
					&uid, &euid, &suid, &fsuid);
		if (!strncmp(buff, "Gid:", 4))
			sscanf(buff, "%*s %ld %ld %ld %ld",
					&gid, &egid, &sgid, &fsgid);
		if (!strncmp(buff, "Groups:", 7)) {
			g=strchr(buff, ':');
			g++; g++;
			strcpy(groups, g);
		}
	}
	fclose(f);

	printf("%d:\t", pid);
	if ((uid==euid)&&(uid==suid)&&(uid==fsuid))
		printf("e/s/fsuid=%ld\t", uid);
	else
		printf("euid=%ld suid=%ld fsuid=%ld\t", euid, suid, fsuid);
	if ((gid==egid)&&(gid==sgid)&&(gid==fsgid))
		printf("e/s/fsgid=%ld\n", gid);
	else
		printf("egid=%ld sgid=%ld fsgid=%ld\n", egid, sgid, fsgid);
	/* nb: groups already has a trailing \n */
	printf("\tgroups: %s", groups);

	return;
}

int
main(int argc, char **argv)
{
	if (argc < 2) {
		fprintf(stderr, "usage:\tpcred pid ...\n");
		fprintf(stderr, "  (report process credentials)\n");
		exit(0);
	}

	/*
	 *  We don't convert argv to an integer; "self" is a legitimate
	 *  thing to look up with these tools, and there may be others
	 *  in the future.
	 */
	argv++;
	while (--argc)
	{
		do_next_arg((argv++)[0]);
	}

	exit(0);
}
