/* apache includes */
#include "ap_config.h"
#include "httpd.h"
#include "http_config.h"
#include "http_conf_globals.h"
#include "http_protocol.h"
#include "http_request.h"
#include "http_main.h"
#include "http_core.h"
#include "http_log.h"

/* krb5 includes */
#include <com_err.h>


int open_and_lock(char *unparsed_filename, char *mod)
{
  struct flock lck;
  int fd;
  int retval;
  char *filename;

  if((filename = strchr(unparsed_filename, ':')) == NULL)
    filename = unparsed_filename;
  else
    filename++;

  /*
   * Open and lock the file to prevent other processes from messing with
   * credentials cache file while we're working with it.
   */

  if ((fd = open(filename, O_CREAT | O_RDWR, 0600)) == -1) {
    com_err(mod, errno, "opening file '%s' before locking", filename);
    return -1;
  }

  lck.l_type = F_WRLCK;
  lck.l_whence = SEEK_SET;
  lck.l_start = 0;
  lck.l_len = 0;

  if ((retval = fcntl(fd, F_SETLK, &lck)) == -1) {
    com_err(mod, errno, ": locking file '%s'", filename);
    com_err(mod, errno, ": lockfd: %d, errno: %d, filename: %s, 
            fcntl retval: %d", fd, errno, filename, retval);
    close(fd);
    return -1;
  }

  return fd;
}

int unlock_and_close(int fd, char *mod)
{
  struct flock lck;
  /* Unlock the file, and close it */

  lck.l_type = F_UNLCK;
  lck.l_whence = SEEK_SET;
  lck.l_start = 0;
  lck.l_len = 0;

  if ( 0 != fcntl(fd, F_SETLK, &lck)) {
    com_err(mod, errno, ": unlocking cc file");
  }

  close(fd);
}
