/*
 * Copyright    2000
 * The Regents of the University of Michigan
 * ALL RIGHTS RESERVED
 *
 * permission is granted to use, copy, create derivative works 
 * and redistribute this software and such derivative works 
 * for any purpose, so long as the name of the university of 
 * michigan is not used in any advertising or publicity 
 * pertaining to the use or distribution of this software 
 * without specific, written prior authorization.  if the 
 * above copyright notice or any other identification of the 
 * university of michigan is included in any copy of any 
 * portion of this software, then the disclaimer below must 
 * also be included.
 *
 * this software is provided as is, without representation 
 * from the university of michigan as to its fitness for any 
 * purpose, and without warranty by the university of 
 * michigan of any kind, either express or implied, including 
 * without limitation the implied warranties of 
 * merchantability and fitness for a particular purpose. the 
 * regents of the university of michigan shall not be liable 
 * for any damages, including special, indirect, incidental, or 
 * consequential damages, with respect to any claim arising 
 * out of or in connection with the use of the software, even 
 * if it has been or is hereafter advised of the possibility of 
 * such damages.
 */

#include <tchar.h>
#include <stdio.h>
//#include <errno.h> 
//#include <string.h> 
//#include <fcntl.h> 
//#include <sys/types.h> 


#ifdef UNICODE 
#define USTR	L 
#else 
#define	USTR 
#endif // UNICODE 
 
#define	MY_STORE	USTR"My" 

//#define __WINCRYPT_H__       // PREVENT windows.h from including wincrypt.h
//                             // since wincrypt.h and openssl namepsaces collide
//                             //  ex. X509_NAME is #define'd and typedef'd ...
#include <windows.h> 
#define main	kx509_main	// for WIN32, "main" in kx509mfc.cpp calls this main

//#include <winsock.h>         // Must be included before <windows.h> !!! 
//#include <windows.h>
#include "debug.h" 

void HandleError(char *s)
{
	DWORD dwFmtMsgFlags = FORMAT_MESSAGE_ALLOCATE_BUFFER |
		                  FORMAT_MESSAGE_FROM_SYSTEM |
						  FORMAT_MESSAGE_IGNORE_INSERTS;
	LPVOID lpMsgBuf;
	char msg[1024];
	DWORD dwLastError = GetLastError();

	FormatMessage(dwFmtMsgFlags,
		          NULL,
				  dwLastError,
				  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
				  (LPTSTR) &lpMsgBuf,
				  0,
				  NULL);
	sprintf(msg, "%s\nError code 0x%08x -- %s", s, dwLastError, lpMsgBuf);
	MessageBox(0, msg, "KX509: Error!", MB_OK|MB_ICONERROR);
    exit(1);
}

void clean_cert_store()
{
	HCERTSTORE		hStoreHandle;
	PCCERT_CONTEXT		pCertContext=NULL;      
	PCCERT_CONTEXT		prev_pCertContext=NULL;      
	DWORD			dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING;
	DWORD			dwAddDisposition = CERT_STORE_ADD_REPLACE_EXISTING;
	DWORD			dwFindFlags = 0;
# define			OID_KCA_AUTHREALM	"1.3.6.1.4.1.250.42.1"
	DWORD			dwFindType = CERT_FIND_ANY;
	CERT_INFO		*pCertInfo = NULL;
	PCERT_EXTENSION		pCertExt = NULL;
	CRYPT_OBJID_BLOB	*p = NULL;
	int			i = 0;
	char			tmpRealm[250];
	BOOL			bDeleted = 0;
	int			rc;


	//--------------------------------------------------------------------
	// Open a store as the source of the certificates to be deleted and added

	if(!(hStoreHandle = CertOpenSystemStore(
			0,
			MY_STORE)))
	{
		HandleError("Strange.  Unable to access your place in the Registry for certificates");
	}


	// Find and Delete all MY store certs issued by our Certificate Authority

	while ((pCertContext = CertFindCertificateInStore(
						hStoreHandle,					// in
						dwCertEncodingType,				// in
						dwFindFlags,					// in
						dwFindType,					// in
						NULL,						// in
						prev_pCertContext				// in
						)))
	{
		bDeleted = 0;
		if (pCertInfo = pCertContext->pCertInfo)
			for (i = pCertInfo->cExtension; i; i--)
			{
				pCertExt = &pCertInfo->rgExtension[i-1];
				if (!strcmp(pCertExt->pszObjId, OID_KCA_AUTHREALM))
				{
					log_printf("Found KCA_AUTHREALM Extension\n");
					p = &pCertExt->Value;
					memcpy(tmpRealm, &p->pbData[2], p->cbData-2);
					tmpRealm[p->cbData-2] ='\0';
					log_printf("   value is: '%s'\n", tmpRealm);

					if (CertDeleteCertificateFromStore(pCertContext))
					{
						log_printf("deleted cert");
						bDeleted = 1;
						break;
					}
					else
					{
						rc = GetLastError();
						msg_printf("Unable to delete past certificates from registry");
					}
				}
			}

		// advance prev to current cert UNLESS we just deleted it!
		if (!bDeleted)
			prev_pCertContext = pCertContext;
	}
} // clean_cert_store






int main(int argc, char **argv) 
{ 
	clean_cert_store();
 
	return(0);
	} 
