/*
 * plumber's friend
 */

extern char *sbrk();
extern char *getenv();
extern char end[];
#ifdef __svr4__
#define bzero(t,c)	memset(t,0,c)
#define bcopy(f,t,c)	memcpy(t,f,c)
#define bcmp(f,t,c)	memcmp(f,t,c)
#endif

#if 0
#include <stdarg.h>
#define USE_STDARG
#endif

#ifdef _IBMR2
#define STACK_OFFSET 6
#define FRAME_OFF 0
#define RET_OFF 2
#define TOP_STACK 0x2ff80000
#define ALIGNMENT 3
#define ARG0_OFF STACK_OFFSET
#endif

#ifdef sparc
#if defined(__GNUC__)
#define STACK_OFFSET 3
#define FRAME_OFF 14
#define RET_OFF 15
#define ARG0_OFF 8
#else
#define STACK_OFFSET 3
#define FRAME_OFF 0
#define RET_OFF 1
#define ARG0_OFF STACK_OFFSET
#endif
#define TOP_STACK 0xf0000000
#define ALIGNMENT 7
#endif

#ifdef i386
#define STACK_OFFSET 2
#define FRAME_OFF 0
#define RET_OFF 1
#define TOP_STACK 0xc0000000
#define ALIGNMENT 3
#define ARG0_OFF STACK_OFFSET
#endif

struct hdr {
	char *who;
	int callersize;
	short seed, free;
	long magic;
	struct hdr *link;
#ifdef sparc
	double j[1];
#endif
	char data[4];
};
#define MAGIC (0xabcedabc)
static int seed;
static struct hdr *head;
static char msg[512];

struct badness {
	char *what;
	struct badness *next;
} *badhead;

static auditcount;
#define AUDITFREQ	10000
#define AUDITMEMORY(m)	(--auditcount < 0 ? (_auditmemory(m)) : 0)

#define MYHEADERSIZE	((int)((struct hdr *) 0)->data)

/* Mark this address as "known - bad" - expect & ignore a free
 *  to it.
 */
markbad(cp)
	char *cp;
{
	struct badness *bp;

	bp = (struct badness *) sbrk(sizeof(*bp));
	if (bp == (struct badness *) -1)
		return;
	bp->what = cp;
	bp->next = badhead;
	badhead = bp;
}

okitsbad(cp)
	char *cp;
{
	struct badness *bp;

	for (bp = badhead; bp ; bp = bp->next)
		if (bp->what == cp)
			return 1;
	return 0;
}

static char *catnum(s, n,b)
	char *s;
	unsigned n;
{
	char temp[30];
	char *cp;
	cp = temp+30;
	*--cp = 0;
	do {
		*--cp = "0123456789abcdef" [ n % b ];
		n /= b;
	} while (n);
	while (*s++ = *cp++)
		;
	return --s;
}

static char *cathex(s,n)
	char *s;
{
	return catnum(s,n,16);
}

static char *catstr(s, p)
	char *s, *p;
{
	while (*s++ = *p++)
		;
	return --s;
}

int
_auditmemory(m)
	char *m;
{
	struct hdr *x;
	static long m2 = ~MAGIC;
	int bad;
	char *cp;

	for (x = head; x ; x = x->link) {
		if (okitsbad(x->data)) continue;
		bad = x->magic != MAGIC;
		if (bcmp((char*) &m2, x->data+x->callersize, sizeof m2))
			bad |= 2;
		if (!bad) continue;
write(1,msg,catstr(cathex(catstr(catnum(catstr(cathex(catstr(catstr
(catstr(catstr(catstr(catstr(
msg
, m)
, (x->free ? ": free" : ": used"))
," memory overrun scribble ")
,(bad & 1) ? "before " : "")
,((bad&3) == 3) ? "or " : "")
,(bad & 2) ? "after " : "")
,x->data)
," "), x->callersize, 10)
," bytes, allocated by "), x->who)
, "\n")
-msg);
		markbad(x->data);
	}

	if (!(cp = getenv("AUDITFREQ")))
		cp = "10000";
	auditcount = atoi(cp);
}

static char *xalloc(arg,retaddr)
	char *retaddr;
{
	int roundedsize;
	struct hdr *result;
	static long m2 = ~MAGIC;
	int i;

	if ((int) arg <= 0)
		return 0;
	roundedsize = arg;
	roundedsize += sizeof(m2);
	roundedsize += 15;
	roundedsize &= ~15;
	roundedsize += sizeof(struct hdr);
	result = (struct hdr *) sbrk(roundedsize);
	if (result == (struct hdr *) -1)
		return 0;
	result->who = retaddr;
	result->callersize = arg;
	result->free = 0;
	result->magic = MAGIC;
	result->seed = seed;
	result->link = head;
	head = ((struct hdr *)result);
	for (i = 0; i < arg; ++i)
	{
		result->data[i] = -i;
	}
	bcopy((char*) &m2, result->data + arg, sizeof m2);
	return result->data;
}

free(x)
	char *x;
{
	struct hdr *h;
	register char **ap, **xp;
	char *err;
	int i;

	h = (struct hdr *) (x - (int)(((struct hdr *) 0)->data));
	err = 0;
	if (!x) err = "zero";
	else if (x < end || x >= sbrk(0)) err = "out of bounds";
	else if ((int)x & ALIGNMENT) err = "unaligned";
	else if (h->magic != MAGIC) err = "unallocated";
	else if (h->free) err = "already freed";
	if (err)
	{
		if (okitsbad(x))
		{
			AUDITMEMORY("free");
			return;
		}
write(1,msg, catstr(cathex(catstr(catstr(catstr(msg
, "Freeing ")
, err)
, "word ")
, x)
, "\n")
-msg);
#ifdef __GNUC__
		ap = __builtin_frame_address(0);
#if 0
__builtin_return_address
__builtin_frame_address
__builtin_saveregs
__builtin_varargs
__builtin_classify_type
__builtin_next_arg
__builtin_args_info
__builtin_apply_args
__builtin_apply
__builtin_return
#endif
#else
		ap = (char **) &x;
		ap -= STACK_OFFSET;
#endif
		xp = 0;
		for (;;) {
	char *temp;
			if (ap < xp || ap >= (char **) (TOP_STACK) || (((int)ap) & ALIGNMENT)) break;
temp = catstr(cathex(msg
, ap)
, "/link=");
temp = catstr(cathex(catstr(cathex(
temp, ap[FRAME_OFF])
, " ret="), ap[RET_OFF])
, " args=");
write(1,msg,
catstr(cathex(catstr(cathex(
temp
, ap[ARG0_OFF])
, ","), ap[ARG0_OFF+1])
, "\n")
-msg);
#ifdef notdef
			printf ("%lx/link=%lx ret=%lx args=%lx,%lx\n",
				ap,
				ap[FRAME_OFF],
				ap[RET_OFF],
				ap[ARG0_OFF],
				ap[ARG0_OFF+1]);
#endif
			xp = ap;
			ap = (char **) ap[FRAME_OFF];
		}
		AUDITMEMORY("free");
		return;
	}
	h->free = 1;
	for (i = 0; i < h->callersize; ++i)
		x[i] ^= -i;
	AUDITMEMORY("free");
}

fetchseed(f)
{
	if (f) ++seed;
	return seed;
}

mcheck(n)
{
	struct hdr *x;
	for (x = head; x ; x = x->link)
		if (x->seed == n && !x->free)
		{
write(1,msg,catstr(cathex(catstr(catnum(catstr(cathex(
msg
,x->data)
," "), x->callersize, 10)
," bytes, allocated by "), x->who)
, "\n")
-msg);
#if 0
			printf ("%lx %d bytes, allocated by %lx\n",
				x->data,
				x->callersize,
				x->who);
#endif
		}
}

char *calloc(n,s)
{
#if defined(__GNUC__) && defined(sparc)
#else
	register char **ap;
#endif
	char *retaddr;
	char *result;

	AUDITMEMORY("calloc");

#if defined(__GNUC__) && defined(sparc)
	asm("mov %%i7,%0"
		: "=r" (retaddr)
		/* : inputs */
		/* : temps required */
		);
#else
	ap = (char **) &n;
	ap -= STACK_OFFSET;
	retaddr = ap[RET_OFF];
#endif
	n *= s;
	result = xalloc(n,retaddr);
	if (result) bzero(result, n);
	return result;
}

char *realloc(cp, n)
	char *cp;
{
	register char **ap, **xp;
	char *retaddr;
	char *result;
	struct hdr *h;
	char *err;

	AUDITMEMORY("realloc");

	err = 0;
	h = 0;
	h = (struct hdr *) (cp - (int)(((struct hdr *) 0)->data));
	if (!cp)
#if 0
		err = "zero";
#else
		;
#endif
	else if (cp < end || cp >= sbrk(0)) err = "out of bounds";
	else if ((int)cp & ALIGNMENT) err = "unaligned";
	else if (h->magic != MAGIC) err = "unallocated";
	else if (h->free) err = "already freed";
	if (err)
	{
		if (okitsbad(cp))
		{
			AUDITMEMORY("realloc");
		}
write(1,msg, catstr(cathex(catstr(catstr(catstr(msg
, "Reallocating ")
, err)
, "word ")
, cp)
, "\n")
-msg);
		ap = (char **) &cp;
		ap -= STACK_OFFSET;
		xp = 0;
		for (;;) {
			char *temp;
			if (ap < xp || ap >= (char **) (TOP_STACK) || (((int)ap) & ALIGNMENT)) break;
temp = catstr(cathex(msg
, ap)
, "/link=");
temp = catstr(cathex(catstr(cathex(
temp, ap[FRAME_OFF])
, " ret="), ap[RET_OFF])
, " args=");
write(1,msg,
catstr(cathex(catstr(cathex(
temp
, ap[ARG0_OFF])
, ","), ap[ARG0_OFF+1])
, "\n")
-msg);
#ifdef notdef
			printf ("%lx/link=%lx ret=%lx args=%lx,%lx\n",
				ap,
				ap[FRAME_OFF],
				ap[RET_OFF],
				ap[ARG0_OFF],
				ap[ARG0_OFF+1]);
#endif
			xp = ap;
			ap = (char **) ap[FRAME_OFF];
		}
		AUDITMEMORY("realloc");
		return 0;
	}

	result = 0;
#if defined(__GNUC__) && defined(sparc)
	asm("mov %%i7,%0"
		: "=r" (retaddr)
		/* : inputs */
		/* : temps required */
		);
#else
	ap = (char **) &cp;
	ap -= STACK_OFFSET;
	retaddr = ap[RET_OFF];
#endif
	if (n)
		result = xalloc(n,retaddr);
	if (result && cp)
	{
		if (n > h->callersize) n = h->callersize;
		bcopy(cp, result, n);
	}
	if (cp) free(cp);
	return result;
}

#ifdef USE_STDARG
char *malloc(int arg, ...)
#else
char *malloc(arg)
#endif
{
	register char **ap, **xp;
	char *retaddr, *result;

	AUDITMEMORY("malloc");

#if defined(__GNUC__) && defined(sparc)
	asm("mov %%o6,%0"
		: "=r" (ap)
		/* : inputs */
		/* : temps required */
		);
	asm("mov %%i7,%0"
		: "=r" (retaddr)
		/* : inputs */
		/* : temps required */
		);
#else
	ap = (char **) &arg;
	ap -= STACK_OFFSET;
	retaddr = ap[RET_OFF];
#endif

	result = xalloc(arg,retaddr);

	if (!result)
	{
write(1,msg, catstr(cathex(catstr(msg
, "Malloc failed for count ")
, arg)
, "\n")
-msg);
		xp = 0;
		for (;;) {
			char *temp;
			if (ap < xp || ap >= (char **) (TOP_STACK) || (((int)ap) & ALIGNMENT)) break;
temp = catstr(cathex(msg
, ap)
, "/link=");
temp = catstr(cathex(catstr(cathex(
temp, ap[FRAME_OFF])
, " ret="), ap[RET_OFF])
, " args=");
write(1,msg,
catstr(cathex(catstr(cathex(
temp
, ap[ARG0_OFF])
, ","), ap[ARG0_OFF+1])
, "\n")
-msg);
#ifdef notdef
			printf ("%lx/link=%lx ret=%lx args=%lx,%lx\n",
				ap,
				ap[FRAME_OFF],
				ap[RET_OFF],
				ap[ARG0_OFF],
				ap[ARG0_OFF+1]);
#endif
			xp = ap;
			ap = (char **) ap[FRAME_OFF];
		}
		AUDITMEMORY("malloc");
		return 0;
	}
	return result;
}

char *strdup(s)
	char *s;
{
#if defined(__GNUC__) && defined(sparc)
#else
	register char **ap;
#endif
	char *retaddr;
	char *result;

#if defined(__GNUC__) && defined(sparc)
	asm("mov %%i7,%0"
		: "=r" (retaddr)
		/* : inputs */
		/* : temps required */
		);
#else
	ap = (char **) &s;
	ap -= STACK_OFFSET;
	retaddr = ap[RET_OFF];
#endif


	result = xalloc(strlen(s)+1,retaddr);
	if (result)
		strcpy(result, s);
	return result;
}
