/*                          
 * Copyright  ©  2005
 * The Regents of the University of Michigan
 * ALL RIGHTS RESERVED
 *
 * permission is granted to use, copy, create derivative works 
 * and redistribute this software and such derivative works 
 * for any purpose, so long as the name of the university of 
 * michigan is not used in any advertising or publicity 
 * pertaining to the use or distribution of this software 
 * without specific, written prior authorization.  if the 
 * above copyright notice or any other identification of the 
 * university of michigan is included in any copy of any 
 * portion of this software, then the disclaimer below must 
 * also be included.
 *
 * this software is provided as is, without representation 
 * from the university of michigan as to its fitness for any 
 * purpose, and without warranty by the university of 
 * michigan of any kind, either express or implied, including 
 * without limitation the implied warranties of 
 * merchantability and fitness for a particular purpose. the 
 * regents of the university of michigan shall not be liable 
 * for any damages, including special, indirect, incidental, or 
 * consequential damages, with respect to any claim arising 
 * out of or in connection with the use of the software, even 
 * if it has been or is hereafter advised of the possibility of 
 * such damages.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#define BUFF_SIZE 1024
#define KCTLOG_ALWAYS	-1	/* always log these messages */
#define KCTLOG_EMERG	 0	/* system is unusable */
#define KCTLOG_ALERT	 1	/* action must be taken immediately */
#define KCTLOG_CRIT	 2	/* critical conditions */
#define KCTLOG_ERR	 3	/* error conditions */
#define KCTLOG_WARNING	 4	/* warning conditions */
#define KCTLOG_NOTICE	 5	/* normal but significant condition */
#define KCTLOG_INFO	 6	/* informational */
#define KCTLOG_DEBUG	 7	/* debug-level messages */

extern FILE *logfile;
extern int kct_debug_level;

void   *get_memory(size_t, size_t);
void    free_memory(void *memory);
int     kct_open_log(char *name);
void    kct_close_log();
int     kct_log(int, char *, ...);
char   *get_time();
size_t  recvblock(int sd, unsigned char *buf, size_t total);
size_t  sendblock(int sd, unsigned char *buf, size_t total);
void    print_buffer(unsigned char *buffer, size_t len,
		     unsigned char *comment);
