/*                          
 * Copyright  ©  2005
 * The Regents of the University of Michigan
 * ALL RIGHTS RESERVED
 *
 * permission is granted to use, copy, create derivative works 
 * and redistribute this software and such derivative works 
 * for any purpose, so long as the name of the university of 
 * michigan is not used in any advertising or publicity 
 * pertaining to the use or distribution of this software 
 * without specific, written prior authorization.  if the 
 * above copyright notice or any other identification of the 
 * university of michigan is included in any copy of any 
 * portion of this software, then the disclaimer below must 
 * also be included.
 *
 * this software is provided as is, without representation 
 * from the university of michigan as to its fitness for any 
 * purpose, and without warranty by the university of 
 * michigan of any kind, either express or implied, including 
 * without limitation the implied warranties of 
 * merchantability and fitness for a particular purpose. the 
 * regents of the university of michigan shall not be liable 
 * for any damages, including special, indirect, incidental, or 
 * consequential damages, with respect to any claim arising 
 * out of or in connection with the use of the software, even 
 * if it has been or is hereafter advised of the possibility of 
 * such damages.
 */

typedef struct _ok_svc
{
    struct _ok_svc *next;
    char   *sname;
    char   *sinst;
} OK_SVC;

typedef struct _requestor
{
    struct _requestor *next;
    char   *pname;
    OK_SVC *svcs;
} REQUESTOR;

extern REQUESTOR *ok_reqrs;

/* Prototypes */
int     kct_authz_init(char *filename);
int     kct_authz_destroy();
int     kct_authz_verify(char *requestor, const char *service_string);
int     kct_authz_dump_table();

#define KCT_MAXLINELEN 1024
