/*
 * Copyright  ©  2005
 * The Regents of the University of Michigan
 * ALL RIGHTS RESERVED
 *
 * permission is granted to use, copy, create derivative works 
 * and redistribute this software and such derivative works 
 * for any purpose, so long as the name of the university of 
 * michigan is not used in any advertising or publicity 
 * pertaining to the use or distribution of this software 
 * without specific, written prior authorization.  if the 
 * above copyright notice or any other identification of the 
 * university of michigan is included in any copy of any 
 * portion of this software, then the disclaimer below must 
 * also be included.
 *
 * this software is provided as is, without representation 
 * from the university of michigan as to its fitness for any 
 * purpose, and without warranty by the university of 
 * michigan of any kind, either express or implied, including 
 * without limitation the implied warranties of 
 * merchantability and fitness for a particular purpose. the 
 * regents of the university of michigan shall not be liable 
 * for any damages, including special, indirect, incidental, or 
 * consequential damages, with respect to any claim arising 
 * out of or in connection with the use of the software, even 
 * if it has been or is hereafter advised of the possibility of 
 * such damages.
 */

#include <stdio.h>
#include <errno.h>
#include <strings.h>
#include <assert.h>

#include <dirent.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <signal.h>
#include <assert.h>
#include <sys/wait.h>

/* For krb5-1.3 */
#define KRB5_PRIVATE 1
#define KRB5_DEPRECATED 1

#include <krb5.h>
#include <com_err.h>
#include <krb5/kdb.h>
#include <kadm5/admin.h>

#include "kct_util.h"
#include "kct_err.h"

#include <openssl/evp.h>
#include <openssl/ssl.h>
#include <openssl/x509.h>
#include <openssl/x509_vfy.h>
#include <openssl/bio.h>
#include <openssl/md5.h>
#include <openssl/err.h>

#ifdef UOFM_ID_CHECK
#define UOFM_MAX_ID_LEN 8
#define UOFM_MIN_ID_LEN 3
#endif

#define KCT_QUEUE_LEN 20
#define KCT_MAX_ID_LEN 1024
#define KCT_MAX_REALM_LEN 1024
#define KCT_MAX_BUF_SIZE 1024
#define KCT_MAX_MEMORY_ALLOC 1000000

#define KCT_PROCESS_TIMEOUT 300

/* time skew that ssl handshake is valid -- 10 minutes */
#define KCT_DEFAULT_HANDSHAKE_VALID_TIME 600

#define KCT_IMPLICIT_SERVICE_NAME "web_server"

typedef struct kct_services_struct
{
    char   *service_name;
    char   *lifetime;
} kct_services;

typedef struct kct_context_struct
{
    int     ws_sock;		/* Web server socket */

    char   *client_id;		/* Target principal */
    char   *client_realm;	/* Target principal realm */

    char   *ws_id;		/* Requesting principal */
    char   *ws_realm;		/* Requesting principal realm */
    char    ws_host[MAXHOSTNAMELEN];	/* Requestor's hostname */
    int     ws_port;		/* Requestor's port */

    kct_services *services;	/* List of requested services */
    int     num_services;

    krb5_context krb_context;	/* K5 context for this request */
    krb5_context tkt_context;	/* K5 context for this request */
    krb5_auth_context ws_auth_context;	/* K5 auth context for requestor */
    krb5_auth_context tkt_auth_context;	/* K5 auth context for requestor */
    krb5_ticket *ws_ticket;	/* K5 ticket to be returned */
} kct_context;

#define s2n(c,s)        ((s=(((unsigned int)(c[0]))<< 8)| \
			    (((unsigned int)(c[1]))    )),c+=2)

#ifndef min
#define min(a, b)       ((a) < (b) ? (a) : (b))
#define max(a, b)       ((a) > (b) ? (a) : (b))
#endif
