/*                          
 * Copyright  ©  2005
 * The Regents of the University of Michigan
 * ALL RIGHTS RESERVED
 *
 * permission is granted to use, copy, create derivative works 
 * and redistribute this software and such derivative works 
 * for any purpose, so long as the name of the university of 
 * michigan is not used in any advertising or publicity 
 * pertaining to the use or distribution of this software 
 * without specific, written prior authorization.  if the 
 * above copyright notice or any other identification of the 
 * university of michigan is included in any copy of any 
 * portion of this software, then the disclaimer below must 
 * also be included.
 *
 * this software is provided as is, without representation 
 * from the university of michigan as to its fitness for any 
 * purpose, and without warranty by the university of 
 * michigan of any kind, either express or implied, including 
 * without limitation the implied warranties of 
 * merchantability and fitness for a particular purpose. the 
 * regents of the university of michigan shall not be liable 
 * for any damages, including special, indirect, incidental, or 
 * consequential damages, with respect to any claim arising 
 * out of or in connection with the use of the software, even 
 * if it has been or is hereafter advised of the possibility of 
 * such damages.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "kct_authz.h"

int
main(int argc, char *argv[])
{
    int     rc;
    char    linein[KCT_MAXLINELEN];
    char    requestor[KCT_MAXLINELEN];
    char   *sname;
    char   *sinst;
    char   *slash;
    char   *next_scan;

    fprintf(stderr, "Calling kct_authz_init\n");
    rc = kct_authz_init("test.conf");

    kct_authz_dump_table();

    do {
	next_scan = linein;

	fprintf(stderr, "Enter requestor: ");
	fflush(stderr);
	fgets(requestor, sizeof(requestor), stdin);
	if (requestor[strlen(requestor) - 1] == '\n')
	    requestor[strlen(requestor) - 1] = '\0';
	if (0 == strlen(requestor))
	    break;

	fprintf(stderr, "Enter service and instance: ");
	fflush(stderr);
	fgets(linein, sizeof(linein), stdin);

	slash = strchr(linein, '/');

#if 0
	if (NULL == slash) {
	    fprintf(stderr, "Invalid input (must be 'name/instance')\n");
	    continue;
	}
#endif

	sname = linein;
	if (sname[strlen(sname) - 1] == '\n')
	    sname[strlen(sname) - 1] = '\0';

	rc = kct_authz_verify(requestor, sname);
	fprintf(stderr, "kct_authz_verify returned %d\n", rc);
    } while (1);

    fprintf(stderr, "Calling kct_authz_destroy\n");
    kct_authz_destroy();
    kct_authz_dump_table();

    exit(0);
}
