/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/*
 *  PVFS2 server state machine for driving I/O operations (read and write).
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-request.h"
#include "pint-distribution.h"
#include "pint-request.h"

static int small_io_start_job(PINT_server_op *s_op, job_status_s *js_p);
static int small_io_check_size(PINT_server_op *s_op, job_status_s *js_p);
static int small_io_cleanup(PINT_server_op *s_op, job_status_s *js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_start_job[];
static union PINT_state_array_values ST_check_size[];
static union PINT_state_array_values ST_send_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_small_io_sm = {
	.name = "pvfs2_small_io_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_small_io_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_start_job },
	{ .return_value = -1 },
	{ .next_state = ST_send_response }
};

static union PINT_state_array_values ST_start_job[] = {
	{ .state_name = "start_job" },
	{ .parent_machine = &pvfs2_small_io_sm },
	{ .flag = SM_NONE },
	{ .state_action = small_io_start_job },
	{ .return_value = -1 },
	{ .next_state = ST_check_size }
};

static union PINT_state_array_values ST_check_size[] = {
	{ .state_name = "check_size" },
	{ .parent_machine = &pvfs2_small_io_sm },
	{ .flag = SM_NONE },
	{ .state_action = small_io_check_size },
	{ .return_value = -1 },
	{ .next_state = ST_send_response }
};

static union PINT_state_array_values ST_send_response[] = {
	{ .state_name = "send_response" },
	{ .parent_machine = &pvfs2_small_io_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_small_io_sm },
	{ .flag = SM_NONE },
	{ .state_action = small_io_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 66 "src/server/small-io.sm"


static int small_io_start_job(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret;
    job_id_t tmp_id;
    PINT_Request_state * file_req_state;
    PINT_request_file_data fdata;
    PINT_Request_result result;
    struct filesystem_configuration_s * fs_config;
    struct server_configuration_s * server_config;

    memset(&s_op->resp.u.small_io, 0, sizeof(struct PVFS_servresp_small_io));

    /* set io type in response to io type in request.  This is
     * needed by the client so it konws how to decode the response
     * appropriately.
     */
    s_op->resp.u.small_io.io_type = s_op->req->u.small_io.io_type;

    if(s_op->req->u.small_io.io_type == PVFS_IO_READ &&
       s_op->ds_attr.b_size == 0)
    {
        /* nothing to read.  return 0 */
        js_p->error_code = 0;
        return 1;
    }

    file_req_state = PINT_new_request_state(
        s_op->req->u.small_io.file_req);
    fdata.server_nr = s_op->req->u.small_io.server_nr;
    fdata.server_ct = s_op->req->u.small_io.server_ct;
    fdata.dist = s_op->req->u.small_io.dist;
    result.offset_array = s_op->u.small_io.offsets;
    result.size_array = s_op->u.small_io.sizes;
    result.segmax = SMALL_IO_MAX_REGIONS;
    result.bytemax = s_op->req->u.small_io.aggregate_size;
    result.bytes = 0;
    result.segs = 0;

    PINT_REQUEST_STATE_SET_TARGET(file_req_state, 
                                  s_op->req->u.small_io.file_req_offset);
    PINT_REQUEST_STATE_SET_FINAL(file_req_state,
                                 s_op->req->u.small_io.file_req_offset +
                                 s_op->req->u.small_io.aggregate_size);

    s_op->resp.u.small_io.bstream_size = s_op->ds_attr.b_size;
    fdata.fsize = s_op->ds_attr.b_size;
    fdata.extend_flag = 
        (s_op->req->u.small_io.io_type == PVFS_IO_READ) ? 0 : 1;

    /* calculate the offsets and sizes in the datafile for the read or write */
    ret = PINT_process_request(
        file_req_state,
        NULL,
        &fdata,
        &result,
        PINT_SERVER);
    if(ret < 0)
    {
        gossip_err("small_io: Failed to process file request\n");
        js_p->error_code = ret;
        return 1;
    }
 
    /* figure out if the fs config has trove data sync turned on or off
     */
    server_config = get_server_config_struct();
    if(!server_config)
    {
        gossip_err("small_io: server config is NULL!\n");
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }
    
    fs_config = PINT_config_find_fs_id(
        server_config, s_op->req->u.small_io.fs_id);
    if(!fs_config)
    {
        gossip_err("small_io: Failed to get filesystem "
                   "config from fs_id of: %d\n",
                   s_op->req->u.small_io.fs_id);
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }

    if(s_op->req->u.small_io.io_type == PVFS_IO_WRITE)
    {
        ret = job_trove_bstream_write_list(
           s_op->req->u.small_io.fs_id,
           s_op->req->u.small_io.handle,
           (char **)&s_op->req->u.small_io.buffer,
           (TROVE_size *)&s_op->req->u.small_io.total_bytes,
           1,
           s_op->u.small_io.offsets,
           s_op->u.small_io.sizes,
           result.segs,
           &s_op->resp.u.small_io.result_size,
           (fs_config->trove_sync_data ? TROVE_SYNC : 0),
           NULL,
           s_op,
           0,
           js_p,
           &tmp_id,
           server_job_context);
        if(ret < 0)
        {
            gossip_err("small_io: Failed to post trove bstream write\n");
        }
    }
    else
    {
        /* allocate space for the read in the response buffer */
        s_op->resp.u.small_io.buffer = BMI_memalloc(
            s_op->addr, result.bytes, BMI_SEND);
        if(!s_op->resp.u.small_io.buffer)
        {
            js_p->error_code = -PVFS_ENOMEM;
            return 1;
        }
        
        s_op->u.small_io.result_bytes = result.bytes;
        ret = job_trove_bstream_read_list(
            s_op->req->u.small_io.fs_id,
            s_op->req->u.small_io.handle,
            (char **)&s_op->resp.u.small_io.buffer,
            &s_op->u.small_io.result_bytes,
            1,
            s_op->u.small_io.offsets,
            s_op->u.small_io.sizes,
            result.segs,
            &s_op->resp.u.small_io.result_size,
            (fs_config->trove_sync_data ? TROVE_SYNC : 0),
            NULL,
            s_op,
            0,
            js_p,
            &tmp_id,
            server_job_context);
        if(ret < 0)
        {
            gossip_err("small-io: Failed to post trove bstream read\n");
            js_p->error_code = ret;
            return 1;
        }
    }

    PINT_free_request_state(file_req_state);

    return ret;
}

static int small_io_check_size(PINT_server_op *s_op, job_status_s *js_p)
{
    if(s_op->req->u.small_io.io_type == PVFS_IO_READ)
    {
        if(s_op->resp.u.small_io.result_size !=
           s_op->u.small_io.result_bytes)
        {
            /* If we get here assume aio threaded isn't supported and 
             * so result_size won't have been set correctly.  
             * Just set to expected value from process_request for now */
            s_op->resp.u.small_io.result_size = s_op->u.small_io.result_bytes;
        }
    }

    return 1;
}

static int small_io_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    if(s_op->req->u.small_io.io_type == PVFS_IO_READ &&
       s_op->resp.u.small_io.buffer)
    {
        BMI_memfree(s_op->addr, s_op->resp.u.small_io.buffer, 
                    s_op->req->u.small_io.total_bytes, BMI_SEND);
    }

    return server_state_machine_complete(s_op);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
