/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-internal.h"
#include "pvfs2-util.h"

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static int seteattr_verify_eattribs(
    PINT_server_op *s_op, job_status_s *js_p);
static int seteattr_setobj_eattribs(
    PINT_server_op *s_op, job_status_s *js_p);
static int seteattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_verify_eattrib[];
static union PINT_state_array_values ST_setobj_eattrib[];
static union PINT_state_array_values ST_cleanup[];
static union PINT_state_array_values ST_final_response[];

struct PINT_state_machine_s pvfs2_set_eattr_sm = {
	.name = "pvfs2_set_eattr_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_set_eattr_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_verify_eattrib },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_verify_eattrib[] = {
	{ .state_name = "verify_eattrib" },
	{ .parent_machine = &pvfs2_set_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = seteattr_verify_eattribs },
	{ .return_value = 0 },
	{ .next_state = ST_setobj_eattrib },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_setobj_eattrib[] = {
	{ .state_name = "setobj_eattrib" },
	{ .parent_machine = &pvfs2_set_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = seteattr_setobj_eattribs },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_set_eattr_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_set_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = seteattr_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 67 "src/server/set-eattr.sm"


/*
 * This routine checks keys to confirm that the name spaces are valid.
 * It also prints debugging information.
 */
static int seteattr_verify_eattribs(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *a_p = NULL;
    int i;
    char reserved_prefix[] = "system.pvfs2.";
    int reserved_prefix_len = strlen("system.pvfs2.");

    a_p = &s_op->attr;

    js_p->error_code = 0;

    gossip_debug(GOSSIP_SETEATTR_DEBUG,
                 "  ext attr list write to handle %llu refers to a %s\n\t"
                 "[owner = %d, group = %d, perms = %o, type = %d]\n",
                 llu(s_op->req->u.seteattr.handle),
                 get_object_type(a_p->objtype),
                 a_p->owner, a_p->group, a_p->perms, a_p->objtype);

    /* iterate through the keys that are being written */
    for (i = 0; i < s_op->req->u.seteattr.nkey; i++)
    {
        /* make sure that they all fall into a supported name space */
        if(!PINT_eattr_is_prefixed(s_op->req->u.seteattr.key[i].buffer))
        {
            /* emulating return code seen on ext3 */
            js_p->error_code = -PVFS_EOPNOTSUPP;
            return 1;
        }

        /* don't allow anyone to set things in the system.pvfs2 name space */
        if(strncmp(s_op->req->u.seteattr.key[i].buffer, reserved_prefix,
            reserved_prefix_len) == 0)
        {
            /* what error code make sense here? */
            js_p->error_code = -PVFS_EINVAL;
            return 1;
        }
    }

    js_p->error_code = 0;
    return 1;
}

/*
 * This is where the actual extended attrib gets written.
 * Not much to this, its pretty straight-forward.
 * 
 * NOTE: we need to check the value of s_op->req->u.seteattr.flags to determine
 * the following:
 *
 * if (flags & PVFS_XATTR_CREATE)
 *  we need to make sure that the attribute does not exist. (pure create)
 * else if (flags & PVFS_XATTR_REPLACE)
 *  we need to make sure that the attribute does exist. (pure replace)
 * else it is default operation as before.
 * We translate this to an internal trove flag 
 *  (TROVE_NOOVERWRITE, TROVE_ONLYOVERWRITE)
 */
static int seteattr_setobj_eattribs(
        PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = 0;
    PVFS_ds_flags trove_flags = 0;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    gossip_debug(
        GOSSIP_SETEATTR_DEBUG,
        "  writing keylist [%llu,%d,len %d flags %d]\n",
        llu(s_op->req->u.seteattr.handle),
        s_op->req->u.seteattr.fs_id,
        s_op->req->u.seteattr.nkey, s_op->req->u.seteattr.flags);

    if (s_op->req->u.seteattr.flags & PVFS_XATTR_CREATE)
    {
        trove_flags = TROVE_NOOVERWRITE;
    }
    else if (s_op->req->u.seteattr.flags & PVFS_XATTR_REPLACE)
    {
        trove_flags = TROVE_ONLYOVERWRITE;
    }
    trove_flags |= 
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.seteattr.fs_id) |
        PINT_config_get_trove_meta_flags(
            user_opts, s_op->req->u.seteattr.fs_id);

    ret = job_trove_keyval_write_list(
        s_op->req->u.seteattr.fs_id,
        s_op->req->u.seteattr.handle,
        s_op->req->u.seteattr.key,
        s_op->req->u.seteattr.val,
        s_op->req->u.seteattr.nkey,
        trove_flags,
        NULL,
        s_op,
        0,
        js_p,
        &j_id,
        server_job_context);

    return ret;
}

/*
 * Function: setattr_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int seteattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    /* do I need to free memory from decoding key and val?*/
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

