/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <assert.h>

#include "pvfs2-server.h"
#include "pint-perf-counter.h"

static int perf_mon_cleanup(PINT_server_op *s_op, job_status_s* js_p);
static int perf_mon_do_work(PINT_server_op *s_op, job_status_s* js_p);

static uint64_t* static_start_time_array_ms = NULL;
static uint64_t* static_interval_array_ms = NULL;
static int64_t** static_value_matrix = NULL;
static int static_history_size = 0;
static int static_key_count = 0;

static int reallocate_static_arrays_if_needed(void);

#define MAX_NEXT_ID 1000000000

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_perf_mon_sm = {
	.name = "pvfs2_perf_mon_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_perf_mon_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = -1 },
	{ .next_state = ST_do_work }
};

static union PINT_state_array_values ST_do_work[] = {
	{ .state_name = "do_work" },
	{ .parent_machine = &pvfs2_perf_mon_sm },
	{ .flag = SM_NONE },
	{ .state_action = perf_mon_do_work },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_perf_mon_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_perf_mon_sm },
	{ .flag = SM_NONE },
	{ .state_action = perf_mon_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 60 "src/server/perf-mon.sm"


/* perf_mon_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int perf_mon_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    if(s_op->resp.u.mgmt_perf_mon.perf_array)
	free(s_op->resp.u.mgmt_perf_mon.perf_array);

    return(server_state_machine_complete(s_op));
}

/* perf_mon_do_work()
 *
 * gathers statistics and builds response
 */
static int perf_mon_do_work(PINT_server_op *s_op, job_status_s* js_p)
{
    struct timeval tv;
    int i;
    int valid_count = 0;
    uint32_t tmp_next_id;
    int ret = -1;
    int idx;

#ifdef __PVFS2_DISABLE_PERF_COUNTERS__
    gossip_err("Error: perf_mon request received, but perf counters are disabled.\n");
    js_p->error_code = -PVFS_ENOSYS;
    return(1);
#endif

    /* allocate memory to hold statistics */
    s_op->resp.u.mgmt_perf_mon.perf_array 
	= (struct PVFS_mgmt_perf_stat*)malloc(s_op->req->u.mgmt_perf_mon.count *
	sizeof(struct PVFS_mgmt_perf_stat));
    if(!s_op->resp.u.mgmt_perf_mon.perf_array)
    {
	js_p->error_code = -PVFS_ENOMEM;
	return(1);
    }

    /* fill in some of the response */
    gettimeofday(&tv, NULL);
    s_op->resp.u.mgmt_perf_mon.cur_time_ms = tv.tv_sec*1000 + 
	tv.tv_usec/1000;
    s_op->resp.u.mgmt_perf_mon.suggested_next_id 
	= s_op->req->u.mgmt_perf_mon.next_id;
    s_op->resp.u.mgmt_perf_mon.perf_array_count
	= s_op->req->u.mgmt_perf_mon.count;

    /* make sure we have scratch memory to use as an intermediate buffer for
     * performance counters
     */
    ret = reallocate_static_arrays_if_needed();
    if(ret < 0)
    {
        free(s_op->resp.u.mgmt_perf_mon.perf_array);
        s_op->resp.u.mgmt_perf_mon.perf_array = NULL;
        js_p->error_code = ret;
        return(1);
    }

    PINT_perf_retrieve(PINT_server_pc,
        static_value_matrix,
        static_start_time_array_ms,
        static_interval_array_ms,
        static_key_count,
        static_history_size);

    /* work through start times, and find the oldest one that is new enough
     * to satisfy next_id
     * NOTE: we encode hi order bits of timestamp as id values.  That
     * should be sufficient to maintain compatibility.
     */
    for(i=static_history_size-1; i>=0; i--)
    {
        tmp_next_id = 0;
        tmp_next_id += (uint32_t)(static_start_time_array_ms[i] % MAX_NEXT_ID);
        
        /* check three conditions:
         * 1) that this interval from the perf counter is valid (start time
         * not zero)
         * 2) if the interval is equal to or more recent than what was
         * suggested by client
         * 3) if the start time has rolled over within MAX_NEXT_ID
         */
        if(tmp_next_id != 0 &&
            ((tmp_next_id >= s_op->req->u.mgmt_perf_mon.next_id) ||
            ((s_op->req->u.mgmt_perf_mon.next_id-tmp_next_id)>(MAX_NEXT_ID/2))))
        {
            /* found the first valid timestamp */
            valid_count = i+1;
            /* compute a next id to suggest that the client use next time 
             * (newest time plus 1)
             */
            tmp_next_id = 0;
            tmp_next_id += (uint32_t)(static_start_time_array_ms[0] %
                MAX_NEXT_ID);
            tmp_next_id += 1;
            s_op->resp.u.mgmt_perf_mon.suggested_next_id = tmp_next_id;
            break;
        }
    }
    if(valid_count > s_op->req->u.mgmt_perf_mon.count)
    {
        valid_count = s_op->req->u.mgmt_perf_mon.count;
    }

    /* fill in all of the valid values */
    for(i=0; i<s_op->req->u.mgmt_perf_mon.count; i++)
    {
        if(i<valid_count && static_start_time_array_ms[i] != 0)
        {
            /* we are filling per_array in backwards, but this is the order
             * karma and other programs that collect data over multiple
             * intervals expect it */
            idx = valid_count - i - 1;
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].valid_flag = 1;
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].id = 0;
                s_op->resp.u.mgmt_perf_mon.perf_array[idx].id += 
                (uint32_t)(static_start_time_array_ms[i] % 1000000000);
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].start_time_ms = 
                static_start_time_array_ms[i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].read = 
                static_value_matrix[PINT_PERF_READ][i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].write = 
                static_value_matrix[PINT_PERF_WRITE][i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].metadata_read = 
                static_value_matrix[PINT_PERF_METADATA_READ][i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].metadata_write = 
                static_value_matrix[PINT_PERF_METADATA_WRITE][i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].dspace_queue =
                static_value_matrix[PINT_PERF_METADATA_DSPACE_OPS][i];
            s_op->resp.u.mgmt_perf_mon.perf_array[idx].keyval_queue =
                static_value_matrix[PINT_PERF_METADATA_KEYVAL_OPS][i];
        }
        else
        {
            s_op->resp.u.mgmt_perf_mon.perf_array[i].valid_flag = 0;
        }
    }

    /* set final end time */
    if(valid_count > 0)
    {
        s_op->resp.u.mgmt_perf_mon.end_time_ms = 
            static_start_time_array_ms[0] +
            static_interval_array_ms[0];
    }

    js_p->error_code = 0;
    return(1);
}

/* reallocate_static_arrays()
 *
 * allocates new arrays for temporary storage of performance counter data,
 * freeing old memory if needed
 *
 * returns 0 on success, -PVFS_error on failure
 */
static int reallocate_static_arrays_if_needed(void)
{
    unsigned int history_size;
    unsigned int key_count;
    int ret = -1;
    int i;

    /* how many keys and history intervals do we have in the perf counter? */
    ret = PINT_perf_get_info(PINT_server_pc, PINT_PERF_KEY_COUNT, 
        &key_count);
    if(ret < 0)
    {
        return(ret);
    }
    ret = PINT_perf_get_info(PINT_server_pc, PINT_PERF_HISTORY_SIZE, 
        &history_size);
    if(ret < 0)
    {
        return(ret);
    }

    if(history_size > static_history_size)
    {
        if(static_start_time_array_ms)
        {
            free(static_start_time_array_ms);
        }
        if(static_interval_array_ms)
        {
            free(static_interval_array_ms);
        }

        /* reallocate time arrays */
        static_start_time_array_ms =
            (uint64_t*)malloc(history_size*sizeof(uint64_t));
        if(!static_start_time_array_ms)
        {
            return(-PVFS_ENOMEM);
        }
        static_interval_array_ms = 
            (uint64_t*)malloc(history_size*sizeof(uint64_t));
        if(!static_interval_array_ms)
        {
            free(static_start_time_array_ms);
            return(-PVFS_ENOMEM);
        }

        /* the key count shouldn't change once acquired */
        assert((static_key_count == 0)||(key_count == static_key_count));

        /* allocate value matrix */
        if(!static_value_matrix)
        {
            static_value_matrix =
                (int64_t**)malloc(key_count*sizeof(int64_t*));
            if(!static_value_matrix)
            {
                free(static_start_time_array_ms);
                free(static_interval_array_ms);
                return(-PVFS_ENOMEM);
            }
            memset(static_value_matrix, 0, key_count*sizeof(int64_t*));
        }

        for(i=0; i<key_count; i++)
        {
            static_value_matrix[i] =
                (int64_t*)malloc(history_size*sizeof(int64_t));
            if(!static_value_matrix[i])
            {
                for(i=i-1; i>=0; i--)
                {
                    free(static_value_matrix[i]);
                }
                free(static_start_time_array_ms);
                free(static_interval_array_ms);
                return(-PVFS_ENOMEM);
            }
        }
    }

    /* NOTE: we change the static counts, even if they are decreasing.  It is
     * ok if the arrays are bigger than needed.
     */
    static_history_size = history_size;
    static_key_count = key_count;

    return(0);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

