/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-storage.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "gossip.h"
#include "pvfs2-internal.h"

static int mgmt_remove_dirent_get_dirdata_handle_from_parent(
    PINT_server_op *s_op, job_status_s *js_p);
static int mgmt_remove_dirent(
    PINT_server_op *s_op, job_status_s *js_p);
static int mgmt_remove_dirent_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_get_dirdata_handle_from_parent[];
static union PINT_state_array_values ST_remove_dirent[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_mgmt_remove_dirent_sm = {
	.name = "pvfs2_mgmt_remove_dirent_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_mgmt_remove_dirent_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_get_dirdata_handle_from_parent },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_get_dirdata_handle_from_parent[] = {
	{ .state_name = "get_dirdata_handle_from_parent" },
	{ .parent_machine = &pvfs2_mgmt_remove_dirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_remove_dirent_get_dirdata_handle_from_parent },
	{ .return_value = 0 },
	{ .next_state = ST_remove_dirent },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_remove_dirent[] = {
	{ .state_name = "remove_dirent" },
	{ .parent_machine = &pvfs2_mgmt_remove_dirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_remove_dirent },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_mgmt_remove_dirent_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_mgmt_remove_dirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_remove_dirent_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 68 "src/server/mgmt-remove-dirent.sm"


static int mgmt_remove_dirent_get_dirdata_handle_from_parent(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    s_op->val.buffer = &s_op->u.mgmt_remove_dirent.dirdata_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(
        GOSSIP_SERVER_DEBUG,
        "  reading dirdata handle (coll_id = %d, handle = %llu, "
        "key = %s (%d), val_buf = %p (%d))\n",
        s_op->req->u.mgmt_remove_dirent.fs_id,
        llu(s_op->req->u.mgmt_remove_dirent.handle),
        (char *) s_op->key.buffer, s_op->key.buffer_sz,
        s_op->val.buffer, s_op->val.buffer_sz);


    ret = job_trove_keyval_read(
        s_op->req->u.mgmt_remove_dirent.fs_id,
        s_op->req->u.mgmt_remove_dirent.handle,
        &s_op->key, &s_op->val, 
        PINT_config_get_trove_meta_flags(
            get_server_config_struct(), s_op->req->u.mgmt_remove_dirent.fs_id), 
        NULL, s_op, 0, js_p, &i,
        server_job_context);

    return ret;
}

static int mgmt_remove_dirent(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    s_op->key.buffer = s_op->req->u.mgmt_remove_dirent.entry;
    s_op->key.buffer_sz = strlen(
        s_op->req->u.mgmt_remove_dirent.entry) + 1;

    gossip_debug(
        GOSSIP_SERVER_DEBUG, "  removing entry %s from dirdata "
        "object (handle = %llu)\n", s_op->req->u.mgmt_remove_dirent.entry,
        llu(s_op->u.mgmt_remove_dirent.dirdata_handle));

    ret = job_trove_keyval_remove(
        s_op->req->u.mgmt_remove_dirent.fs_id,
        s_op->u.mgmt_remove_dirent.dirdata_handle,
        &s_op->key,
        NULL,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.mgmt_remove_dirent.fs_id) |
        PINT_config_get_trove_meta_flags(
            user_opts, s_op->req->u.mgmt_remove_dirent.fs_id),
        NULL,
        s_op,
        0,
        js_p,
        &j_id,
        server_job_context);

    return ret;
}

static int mgmt_remove_dirent_cleanup(
    PINT_server_op *s_op, job_status_s *js_p)
{
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
