/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "pvfs2-server.h"
#include "server-config.h"

static int iterate_handles_cleanup(PINT_server_op *s_op, job_status_s* js_p);
static int iterate_handles_do_work(PINT_server_op *s_op, job_status_s* js_p);
static int iterate_handles_fill_resp(PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_fill_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_iterate_handles_sm = {
	.name = "pvfs2_iterate_handles_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_iterate_handles_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = -1 },
	{ .next_state = ST_do_work }
};

static union PINT_state_array_values ST_do_work[] = {
	{ .state_name = "do_work" },
	{ .parent_machine = &pvfs2_iterate_handles_sm },
	{ .flag = SM_NONE },
	{ .state_action = iterate_handles_do_work },
	{ .return_value = -1 },
	{ .next_state = ST_fill_resp }
};

static union PINT_state_array_values ST_fill_resp[] = {
	{ .state_name = "fill_resp" },
	{ .parent_machine = &pvfs2_iterate_handles_sm },
	{ .flag = SM_NONE },
	{ .state_action = iterate_handles_fill_resp },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_iterate_handles_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_iterate_handles_sm },
	{ .flag = SM_NONE },
	{ .state_action = iterate_handles_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 55 "src/server/iterate-handles.sm"


/* iterate_handles_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int iterate_handles_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    if(s_op->resp.u.mgmt_iterate_handles.handle_array)
	free(s_op->resp.u.mgmt_iterate_handles.handle_array);

    return(server_state_machine_complete(s_op));
}


/* iterate_handles_do_work()
 *
 * actually performs work necessary to retrieve handles
 */
static int iterate_handles_do_work(PINT_server_op *s_op, job_status_s* js_p)
{
    job_id_t tmp_id;

    /* allocate memory to hold handles */
    s_op->resp.u.mgmt_iterate_handles.handle_array
	= (PVFS_handle*)malloc(s_op->req->u.mgmt_iterate_handles.handle_count *
	sizeof(PVFS_handle));
    if(!s_op->resp.u.mgmt_iterate_handles.handle_array)
    {
	js_p->error_code = -PVFS_ENOMEM;
	return(1);
    }
    
    s_op->resp.u.mgmt_iterate_handles.position
	= s_op->req->u.mgmt_iterate_handles.position;

    return(job_trove_dspace_iterate_handles(
	s_op->req->u.mgmt_iterate_handles.fs_id,
	s_op->resp.u.mgmt_iterate_handles.position,
	s_op->resp.u.mgmt_iterate_handles.handle_array,
	s_op->req->u.mgmt_iterate_handles.handle_count,
	PINT_config_get_trove_meta_flags(
            get_server_config_struct(), s_op->req->u.mgmt_iterate_handles.fs_id),
	NULL,
	s_op,
	0,
	js_p,
	&tmp_id,
	server_job_context));
}

/* iterate_handles_fill_resp()
 *
 * gathers results from job status for response
 */
static int iterate_handles_fill_resp(PINT_server_op *s_op, job_status_s* js_p)
{
    if(js_p->error_code != 0)
    {
	/* propigate error and let final_response handle it */
	return(1);
    }

    s_op->resp.u.mgmt_iterate_handles.handle_count = js_p->count;
    s_op->resp.u.mgmt_iterate_handles.position = js_p->position;

    return(1);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

