/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/* pvfs2_get_eattr_sm
 *
 * This state machine handles incoming server geteattr operations.  These
 * are the operations sent by PVFS_sys_geteattr() among others.
 *
 * The pvfs2_prelude_sm is responsible for reading the actual metadata
 * to begin with, because it does this as part of the permission checking
 * process.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-types.h"
#include "pvfs2-types-debug.h"
#include "pvfs2-util.h"
#include "pint-util.h"

static int geteattr_setup_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int geteattr_read_eattrib(
    PINT_server_op *s_op, job_status_s *js_p);
static int geteattr_check_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int geteattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_read_eattrib[];
static union PINT_state_array_values ST_check_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_get_eattr_sm = {
	.name = "pvfs2_get_eattr_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_setup_resp },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_setup_resp[] = {
	{ .state_name = "setup_resp" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = geteattr_setup_resp },
	{ .return_value = 0 },
	{ .next_state = ST_read_eattrib },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_read_eattrib[] = {
	{ .state_name = "read_eattrib" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = geteattr_read_eattrib },
	{ .return_value = -1 },
	{ .next_state = ST_check_resp }
};

static union PINT_state_array_values ST_check_resp[] = {
	{ .state_name = "check_resp" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = geteattr_check_resp },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_get_eattr_sm },
	{ .flag = SM_NONE },
	{ .state_action = geteattr_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 88 "src/server/get-eattr.sm"


/*
 * geteattr_setup_resp()
 * Set up the response - allocate needed resources
 */
static int geteattr_setup_resp(PINT_server_op *s_op, job_status_s *js_p)
{
    int i, tsz;
    char reserved_prefix[] = "system.pvfs2.";
    int reserved_prefix_len = strlen("system.pvfs2.");
    char* tmp_buffer = NULL;
    int tmp_len = 0;
    int ret;

    gossip_debug(GOSSIP_GETEATTR_DEBUG,"geteattr requesting %d keys\n",
            s_op->req->u.geteattr.nkey);

    js_p->error_code = 0;
 
    tmp_buffer = (char*)malloc(PVFS_REQ_LIMIT_KEY_LEN);
    if(!tmp_buffer)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }

    /* iterate through the keys and see if they fall into valid name spaces */
    for(i=0; i<s_op->req->u.geteattr.nkey; i++)
    {
        if(!PINT_eattr_is_prefixed(s_op->req->u.geteattr.key[i].buffer))
        {
            /* not prefixed: treat this as if the key does not exist */
            free(tmp_buffer);
            js_p->error_code = -PVFS_ENOENT;
            return(1);
        }

        /* look for keys in the special "system.pvfs2." prefix and strip the
         * prefix off; they are stored as keyvals with no prefix within
         * trove.
         */
        if(strncmp(s_op->req->u.geteattr.key[i].buffer, reserved_prefix,
            reserved_prefix_len) == 0)
        {
            ret = sscanf(s_op->req->u.geteattr.key[i].buffer,
                "system.pvfs2.%s", tmp_buffer);
            if(ret != 1)
            {
                free(tmp_buffer);
                js_p->error_code = -PVFS_ENOENT;
                return(1);
            }
            tmp_len = strlen(tmp_buffer) + 1;
            memcpy(s_op->req->u.geteattr.key[i].buffer, tmp_buffer, tmp_len);
            s_op->req->u.geteattr.key[i].buffer_sz = tmp_len;
        }
    }

    s_op->resp.u.geteattr.val =
        malloc(s_op->req->u.geteattr.nkey*sizeof(PVFS_ds_keyval));
    if (!s_op->resp.u.geteattr.val)
    {
        free(tmp_buffer);
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }
    s_op->resp.u.geteattr.err =
        malloc(s_op->req->u.geteattr.nkey*sizeof(PVFS_error));
    if (!s_op->resp.u.geteattr.err)
    {
        free(s_op->resp.u.geteattr.val);
        free(tmp_buffer);
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }
    s_op->resp.u.geteattr.nkey = s_op->req->u.geteattr.nkey;
    for (i = 0, tsz = 0; i < s_op->req->u.geteattr.nkey; i++)
        tsz += s_op->req->u.geteattr.valsz[i];
    s_op->u.eattr.buffer = malloc(tsz);
    if (!s_op->u.eattr.buffer)
    {
        s_op->resp.u.geteattr.nkey = 0;
        free (s_op->resp.u.geteattr.val);
        free (s_op->resp.u.geteattr.err);
        free(tmp_buffer);
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }
    gossip_debug(GOSSIP_GETEATTR_DEBUG,"geteattr buffer size %d bytes\n",
            tsz);
    for (i = 0, tsz = 0; i < s_op->req->u.geteattr.nkey; i++)
    {
        s_op->resp.u.geteattr.val[i].buffer_sz =
            s_op->req->u.geteattr.valsz[i];
        s_op->resp.u.geteattr.val[i].buffer =
            (char *) s_op->u.eattr.buffer + tsz;
        tsz += s_op->req->u.geteattr.valsz[i];
    }
    free(tmp_buffer);
    return 1;
}

/*
 * geteattr_read_eattrib()
 * Here is where the eattrib get read.  Not much to this.
 */
static int geteattr_read_eattrib(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    js_p->error_code = 0;

    ret = job_trove_keyval_read_list(
        s_op->req->u.geteattr.fs_id,
        s_op->req->u.geteattr.handle,
        s_op->req->u.geteattr.key,
        s_op->resp.u.geteattr.val,
        s_op->resp.u.geteattr.err,
        s_op->req->u.geteattr.nkey,
        PINT_config_get_trove_meta_flags(
            get_server_config_struct(), s_op->req->u.geteattr.fs_id),
        NULL,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}

/*
 * geteattr_check_resp()
 * Check the response - handle any errors
 */
static int geteattr_check_resp(PINT_server_op *s_op, job_status_s *js_p)
{
    int k;
    gossip_debug(GOSSIP_GETEATTR_DEBUG,"geteattr returning %d values\n",
            s_op->resp.u.geteattr.nkey);
    /* put the returned read buffer size in buffer_sz */
    gossip_debug(GOSSIP_GETEATTR_DEBUG,"status %d error_code %d nkeys %d\n",
            s_op->resp.status, js_p->error_code, s_op->resp.u.geteattr.nkey);
    /* it is the only thing returned across the wire */
    for (k = 0; k < s_op->resp.u.geteattr.nkey; k++)
    {
        if (js_p->error_code == 0)
        {
            s_op->resp.u.geteattr.val[k].buffer_sz =
                s_op->resp.u.geteattr.val[k].read_sz;
            gossip_debug(GOSSIP_GETEATTR_DEBUG, "key %s, read_sz = %d\n",
                (char *) s_op->req->u.geteattr.key[k].buffer, s_op->resp.u.geteattr.val[k].buffer_sz);
        }
        /* in case of any errors, we initialize it to 0 */
        else {
            s_op->resp.u.geteattr.val[k].buffer_sz = 0;
        }
    }
    return 1;
}

/* geteattr_cleanup()
 * free resources alloc'd by state machine
 */
static int geteattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    if (s_op->resp.u.geteattr.val)
        free(s_op->resp.u.geteattr.val);
    if (s_op->resp.u.geteattr.err)
        free(s_op->resp.u.geteattr.err);
    if (s_op->u.eattr.buffer)
        free(s_op->u.eattr.buffer);
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

