/*
 * (C) 2006 CITI @ the University of Michigan
 *
 * See COPYING in top-level directory.
 */

/** \defgroup pvfs2linux PVFS2 Linux kernel support
 *
 *  pNFS definitions
 *
 * @{
 */

/** \file
 *  Declarations and macros for the pNFS Linux kernel support.
 */

#ifndef __PVFS2_PNFS_H
#define __PVFS2_PNFS_H

/* pnfs-pvfs2 layout structure */
struct pvfs2_layout {
	u32     length;
	void	*layout;
};

extern struct export_operations pvfs2layout_export_ops;
extern struct export_operations nfslayout_export_ops;
extern struct export_operations nfsmanuallayout_export_ops;

/* Structs need to be defined just to compile kernel module since they
 * are used in include/linux/nfs4_pnfs.h.
 */
struct nfs_write_data;
struct nfs_read_data;
struct pnfs_layoutcommit_arg;
struct pnfs_layoutcommit_res;

#endif
/* @} */

/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ts=8 sts=4 sw=4 expandtab
 */
