/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for reading and writing small files.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-types-debug.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

#define SMALL_IO_MAX_REGIONS 64

/* The small-io state machine should only be invoked/jumped-to from the
 * sys-io state machine.  We make this assumption and expect io parameters
 * to be initialized already.
 */

static int small_io_setup_msgpairs(PINT_client_sm *sm_p,
				   job_status_s *js_p);

static int small_io_cleanup(PINT_client_sm *sm_p,
                            job_status_s *js_p);

static int small_io_completion_fn(void * user_args,
                                  struct PVFS_server_resp * resp_p,
                                  int index);

static union PINT_state_array_values ST_setup_msgpairs[];
static union PINT_state_array_values ST_xfer_msgpairs[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_small_io_sm = {
	.name = "pvfs2_client_small_io_sm",
	.state_machine = ST_setup_msgpairs
};

static union PINT_state_array_values ST_setup_msgpairs[] = {
	{ .state_name = "setup_msgpairs" },
	{ .parent_machine = &pvfs2_client_small_io_sm },
	{ .flag = SM_NONE },
	{ .state_action = small_io_setup_msgpairs },
	{ .return_value = 0 },
	{ .next_state = ST_xfer_msgpairs },
	{ .return_value = -1 },
	{ .flag = SM_RETURN }
};

static union PINT_state_array_values ST_xfer_msgpairs[] = {
	{ .state_name = "xfer_msgpairs" },
	{ .parent_machine = &pvfs2_client_small_io_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_client_small_io_sm },
	{ .flag = SM_NONE },
	{ .state_action = small_io_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_RETURN }
};

# 72 "src/client/sysint/sys-small-io.sm"


/**
 * Small I/O is done in cases where the size of data transferred between
 * client and server is smaller than the maximum unexpected message size
 * accepted by the BMI transport interface in use.  In this case, we don't
 * need to perform initial rendezvous setup messages before sending the
 * actual data (the 'flow'), instead we just pack the data in the unexpected
 * message.  The sys-io state machine checks for possible 'small i/o' cases
 * and routes to the small i/o state actions in case.
 */
static int small_io_setup_msgpairs(PINT_client_sm * sm_p,
                                   job_status_s *js_p)
{
    PVFS_object_attr *attr = NULL;
    int i = 0;
    int ret;
    PVFS_handle datafile_handle;
    int regions = 0;

    js_p->error_code = 0;

    attr = &sm_p->getattr.attr;
    assert(attr);
    
    /* initialize msgarray */
    ret = PINT_msgpairarray_init(&sm_p->msgarray, sm_p->u.io.datafile_count);
    if(ret < 0)
    {
        js_p->error_code = ret;
        return 1;
    }
    sm_p->msgarray_count = sm_p->u.io.datafile_count;

    for(i = 0; i < sm_p->u.io.datafile_count; ++i)
    {
        datafile_handle = attr->u.meta.dfile_array[
            sm_p->u.io.datafile_index_array[i]];

        gossip_debug(GOSSIP_IO_DEBUG, "   small_io_setup_msgpairs: "
                     "handle: %llu\n", llu(datafile_handle));

        if(sm_p->u.io.io_type == PVFS_IO_WRITE)
        {
            PINT_Request_state * file_req_state = NULL;
            PINT_Request_state * mem_req_state = NULL;
            PINT_request_file_data file_data;
            PINT_Request_result result;

            memset(&file_data, 0, sizeof(PINT_request_file_data));
            file_data.server_ct = attr->u.meta.dfile_count;
            file_data.fsize = 0;
            file_data.dist = attr->u.meta.dist;
            file_data.extend_flag = 1;

            result.segmax = SMALL_IO_MAX_REGIONS;
            result.bytemax = PINT_REQUEST_TOTAL_BYTES(sm_p->u.io.mem_req);
            file_req_state = PINT_new_request_state(sm_p->u.io.file_req);
            mem_req_state = PINT_new_request_state(sm_p->u.io.mem_req);

            PINT_REQUEST_STATE_SET_TARGET(file_req_state, 
                                          sm_p->u.io.file_req_offset);

            PINT_REQUEST_STATE_SET_FINAL(file_req_state, 
                                         sm_p->u.io.file_req_offset + 
                                         result.bytemax);

            file_data.server_nr = sm_p->u.io.datafile_index_array[i];

            result.segs = 0;
            result.bytes = 0;
            result.offset_array = sm_p->msgarray[i].req.u.small_io.offsets;
            result.size_array = sm_p->msgarray[i].req.u.small_io.sizes;
            sm_p->msgarray[i].req.u.small_io.buffer = sm_p->u.io.buffer;

            ret = PINT_process_request(
                file_req_state, mem_req_state,
                &file_data,
                &result,
                PINT_CLIENT);
            if(ret < 0)
            {
                js_p->error_code = ret;
                PINT_free_request_state(file_req_state);
                PINT_free_request_state(mem_req_state);
                return 1;
            }

            regions = result.segs;

            PINT_free_request_state(file_req_state);
            PINT_free_request_state(mem_req_state);
        }

        /* if this is a write operation, the appropriate offset and size
         * arrays will have been filled in by the request processing above.
         * reads don't require processing of the memory request until
         * the response.  
         */ 
        PINT_SERVREQ_SMALL_IO_FILL(
            sm_p->msgarray[i].req,
            *sm_p->cred_p,
            sm_p->object_ref.fs_id,
            datafile_handle,
            sm_p->u.io.io_type,
            sm_p->u.io.datafile_index_array[i],
            attr->u.meta.dfile_count,
            attr->u.meta.dist,
            sm_p->u.io.file_req,
            sm_p->u.io.file_req_offset,
            regions,
            PINT_REQUEST_TOTAL_BYTES(sm_p->u.io.mem_req));

        sm_p->msgarray[i].fs_id = sm_p->object_ref.fs_id;
        sm_p->msgarray[i].handle = sm_p->object_ref.handle;
        sm_p->msgarray[i].retry_flag = PVFS_MSGPAIR_RETRY;
        sm_p->msgarray[i].comp_fn = small_io_completion_fn;

        ret = PINT_cached_config_map_to_server(
            &sm_p->msgarray[i].svr_addr, datafile_handle,
            sm_p->object_ref.fs_id);
        if(ret < 0)
        {
            gossip_err("Failed to map meta server address\n");
            js_p->error_code = ret;
            return 1;
        }
    }

    js_p->error_code = 0;
    return 1;
}

/**
 * We assume that the response buffer hasn't been freed yet (before
 * the completion function is called.   The msgpairarray.sm doesn't
 * free the response buffer until after the completion function is
 * called.
 */
static int small_io_completion_fn(void * user_args,
                                  struct PVFS_server_resp * resp_p,
                                  int index)
{
    PINT_client_sm * sm_p = (PINT_client_sm *)user_args;
    int ret = 0;

    assert(resp_p->op == PVFS_SERV_SMALL_IO);

    if(resp_p->status != 0)
    {
        return resp_p->status;
    }

    if(resp_p->u.small_io.io_type == PVFS_IO_READ)
    {
        PVFS_size sizes[SMALL_IO_MAX_REGIONS];
        PVFS_offset offsets[SMALL_IO_MAX_REGIONS];
        PVFS_object_attr * attr = &sm_p->getattr.attr;
        PINT_request_file_data fdata;
        PINT_Request_result result;
        PINT_Request_state * file_req_state;
        PINT_Request_state * mem_req_state;
        int i = 0;
        int done = 0;
        PVFS_size bytes_processed = 0;

        if(resp_p->u.small_io.result_size != 0)
        {
            fdata.server_ct = attr->u.meta.dfile_count;
            fdata.server_nr = sm_p->u.io.datafile_index_array[index];
            fdata.dist = attr->u.meta.dist;
            fdata.fsize = resp_p->u.small_io.bstream_size;

            result.segmax = SMALL_IO_MAX_REGIONS;
            result.bytemax = resp_p->u.small_io.result_size;
            result.size_array = sizes;
            result.offset_array = offsets;

            file_req_state = PINT_new_request_state(sm_p->u.io.file_req);
            mem_req_state = PINT_new_request_state(sm_p->u.io.mem_req);

            PINT_REQUEST_STATE_SET_TARGET(file_req_state, 
                                          sm_p->u.io.file_req_offset);
            PINT_REQUEST_STATE_SET_FINAL(
                file_req_state, sm_p->u.io.file_req_offset + 
                PINT_REQUEST_TOTAL_BYTES(sm_p->u.io.mem_req));

            do
            {
                result.segs = 0;
                result.bytes = 0;

                ret = PINT_process_request(
                    file_req_state,
                    mem_req_state,
                    &fdata,
                    &result,
                    PINT_CLIENT);
                if(ret < 0)
                {
                    gossip_err("Failed processing request in small I/O read\n");
                    return ret;
                }

                for(i = 0; i < result.segs && !done; ++i)
                {
                    int tmp_size;
                    char * src_ptr;
                    char * dest_ptr;

                    dest_ptr = (char *)sm_p->u.io.buffer + offsets[i];
                    src_ptr = (char *)resp_p->u.small_io.buffer + 
                        bytes_processed;

                    if((bytes_processed + sizes[i]) <= 
                       resp_p->u.small_io.result_size)
                    {
                        tmp_size = sizes[i];
                    }
                    else
                    {
                        tmp_size = resp_p->u.small_io.result_size - 
                            bytes_processed;
                        done = 1;
                    }

                    memcpy(dest_ptr, src_ptr, sizes[i]);
                    bytes_processed += tmp_size;
                }
            } while(!PINT_REQUEST_DONE(file_req_state) && !done);

            if(resp_p->u.small_io.result_size != bytes_processed)
            {
                gossip_err("size of bytes copied to user buffer "
                           "(%llu) do not match size of response (%llu)\n", 
                           llu(bytes_processed),
                           llu(resp_p->u.small_io.result_size));
                return -PVFS_EINVAL;
            }
            PINT_free_request_state(file_req_state);
            PINT_free_request_state(mem_req_state);
        }
    }

    sm_p->u.io.dfile_size_array[index] = resp_p->u.small_io.bstream_size;
    sm_p->u.io.total_size += resp_p->u.small_io.result_size;
 
    return 0;
}

static int small_io_cleanup(PINT_client_sm *sm_p,
                                   job_status_s *js_p)
{
    PINT_msgpairarray_destroy(sm_p->msgarray);
    sm_p->msgarray = NULL;
    sm_p->msgarray_count = 0;

    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
