/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for obtaining the handle of
 *  the object that holds directory data (the dirdata object).
 *
 *  These routines are used primarily for file system check and repair
 *  purposes, and expose internal details of PVFS2 that may change.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

static int mgmt_get_dirdata_handle_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_get_dirdata_handle_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_get_dirdata_handle_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int mgmt_get_dirdata_handle_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_get_dirdata_handle_setup_msgpair[];
static union PINT_state_array_values ST_get_dirdata_handle_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_get_dirdata_handle_sm = {
	.name = "pvfs2_client_mgmt_get_dirdata_handle_sm",
	.state_machine = ST_init
};

static union PINT_state_array_values ST_init[] = {
	{ .state_name = "init" },
	{ .parent_machine = &pvfs2_client_mgmt_get_dirdata_handle_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_get_dirdata_handle_init },
	{ .return_value = -1 },
	{ .next_state = ST_get_dirdata_handle_setup_msgpair }
};

static union PINT_state_array_values ST_get_dirdata_handle_setup_msgpair[] = {
	{ .state_name = "get_dirdata_handle_setup_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_get_dirdata_handle_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_get_dirdata_handle_setup_msgpair },
	{ .return_value = 0 },
	{ .next_state = ST_get_dirdata_handle_xfer_msgpair },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_get_dirdata_handle_xfer_msgpair[] = {
	{ .state_name = "get_dirdata_handle_xfer_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_get_dirdata_handle_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_client_mgmt_get_dirdata_handle_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_get_dirdata_handle_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 76 "src/client/sysint/mgmt-get-dirdata-handle.sm"


/** Initiate retrieval of handle for dirdata object for a specific
 *  directory.
 */
PVFS_error PVFS_imgmt_get_dirdata_handle(
    PVFS_object_ref parent_ref,
    PVFS_handle *out_dirdata_handle,
    PVFS_credentials *credentials,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_get_dirdata_handle entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) || !out_dirdata_handle)
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->parent_ref = parent_ref;
    sm_p->u.mgmt_get_dirdata_handle.dirdata_handle = out_dirdata_handle;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Trying to get dirdata object of parent "
        "dir %llu,%d\n", llu(parent_ref.handle), parent_ref.fs_id);

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_GET_DIRDATA_HANDLE, op_id, user_ptr);
}

/** Obtain handle for dirdata object for a specific directory.
 */
PVFS_error PVFS_mgmt_get_dirdata_handle(
    PVFS_object_ref parent_ref,
    PVFS_handle *out_dirdata_handle,
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_get_dirdata_handle entered\n");

    ret = PVFS_imgmt_get_dirdata_handle(
        parent_ref, out_dirdata_handle, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_get_dirdata_handle call", ret);
        error = ret;
    }
    else
    {
        ret = PVFS_mgmt_wait(op_id, "get_dirdata_handle", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    PVFS_mgmt_release(op_id);
    return error;
}

static int mgmt_get_dirdata_handle_init(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "mgmt_get_dirdata_handle_init called\n");

    assert(js_p->error_code == 0);
    return 1;
}

static int mgmt_get_dirdata_handle_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_MGMT_GET_DIRDATA_HANDLE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->parent_ref.fs_id,
        sm_p->parent_ref.handle);

    gossip_debug(GOSSIP_CLIENT_DEBUG, "- doing MGMT_GET_DIRDATA_HANDLE "
                 "under %llu,%d\n", llu(sm_p->parent_ref.handle),
                 sm_p->parent_ref.fs_id);

    msg_p->fs_id = sm_p->parent_ref.fs_id;
    msg_p->handle = sm_p->parent_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mgmt_get_dirdata_handle_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map server address\n");
	js_p->error_code = ret;
    }
    return 1;
}

static int mgmt_get_dirdata_handle_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;

    assert(resp_p->op == PVFS_SERV_MGMT_GET_DIRDATA_HANDLE);

    if (resp_p->status == 0)
    {
        assert(sm_p->u.mgmt_get_dirdata_handle.dirdata_handle);

        *sm_p->u.mgmt_get_dirdata_handle.dirdata_handle =
            resp_p->u.mgmt_get_dirdata_handle.handle;

        gossip_debug(
            GOSSIP_CLIENT_DEBUG, "  mgmt_get_dirdata_handle_comp_fn: "
            "got dirdata handle %llu under %llu,%d removed\n",
            llu(*sm_p->u.mgmt_get_dirdata_handle.dirdata_handle),
            llu(sm_p->parent_ref.handle), sm_p->parent_ref.fs_id);
    }
    return resp_p->status;
}

static int mgmt_get_dirdata_handle_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "mgmt_get_dirdata_handle _cleanup called\n");

    sm_p->error_code = js_p->error_code;

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
