/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <assert.h>

#include "pvfs2-server.h"
#include "trove-handle-mgmt.h"
#include "pint-cached-config.h"

#ifdef HAVE_SYSINFO
#include <sys/sysinfo.h>
#endif

static int statfs_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int statfs_do_statfs(
    PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_do_statfs[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_statfs_sm = {
	.name = "pvfs2_statfs_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_statfs_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = -1 },
	{ .next_state = ST_do_statfs }
};

static union PINT_state_array_values ST_do_statfs[] = {
	{ .state_name = "do_statfs" },
	{ .parent_machine = &pvfs2_statfs_sm },
	{ .flag = SM_NONE },
	{ .state_action = statfs_do_statfs },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_statfs_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_statfs_sm },
	{ .flag = SM_NONE },
	{ .state_action = statfs_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 60 "src/server/statfs.sm"


/* statfs_do_statfs()
 *
 * issue the trove call to retrieve fs statistics
 */
static int statfs_do_statfs(PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -1;
    TROVE_context_id tmp_context;
    struct server_configuration_s *user_opts = get_server_config_struct();

    /* first try to gather handle statistics */
    ret = trove_handle_get_statistics(
        s_op->req->u.statfs.fs_id,
        &s_op->resp.u.statfs.stat.handles_available_count);

    if (ret < 0)
    {
        js_p->error_code = ret;
        return 1;
    }

    /* find out how many total handles this server controls */
    ret = PINT_cached_config_get_server_handle_count(
        user_opts->host_id, s_op->req->u.statfs.fs_id,
        &s_op->resp.u.statfs.stat.handles_total_count);
    if(ret < 0)
    {   
        js_p->error_code = ret;
        return(1);
    }

    /* we need a context to be able to make the getinfo call */
    ret = trove_open_context(s_op->req->u.statfs.fs_id, &tmp_context);
    if (ret < 0)
    {
        js_p->error_code = ret;
        return 1;
    }

    ret = trove_collection_getinfo(
        s_op->req->u.statfs.fs_id, tmp_context,
        PVFS_COLLECTION_STATFS, &(s_op->resp.u.statfs.stat));

    /* close context regardless of whether getinfo was successful */
    trove_close_context(s_op->req->u.statfs.fs_id, tmp_context);
    
    /* getinfo should always return immediately, no testing needed */
    assert(ret != 0);

#ifdef HAVE_SYSINFO
    {
        struct sysinfo system_metrics;
        memset(&system_metrics, 0, sizeof(struct sysinfo));
        if (sysinfo(&system_metrics) == 0)
        {
            s_op->resp.u.statfs.stat.ram_total_bytes = (uint64_t)
                (system_metrics.totalram * system_metrics.mem_unit);
            s_op->resp.u.statfs.stat.ram_free_bytes = (uint64_t)
                (system_metrics.freeram * system_metrics.mem_unit);
            s_op->resp.u.statfs.stat.uptime_seconds = (uint64_t)
                system_metrics.uptime;
            s_op->resp.u.statfs.stat.load_1 = (uint64_t)
                system_metrics.loads[0];
            s_op->resp.u.statfs.stat.load_5 = (uint64_t)
                system_metrics.loads[1];
            s_op->resp.u.statfs.stat.load_15 = (uint64_t)
                system_metrics.loads[2];
        }
    }
#else
    s_op->resp.u.statfs.stat.ram_total_bytes = 0;
    s_op->resp.u.statfs.stat.ram_free_bytes = 0;
    s_op->resp.u.statfs.stat.uptime_seconds = 0;
    s_op->resp.u.statfs.stat.load_1 = 0;
    s_op->resp.u.statfs.stat.load_5 = 0;
    s_op->resp.u.statfs.stat.load_15 = 0;
#endif

    js_p->error_code = ((ret != 1) ? ret : 0);
    return 1;
}


/* statfs_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int statfs_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    return(server_state_machine_complete(s_op));
}


/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
