/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "server-config.h"
#include "pvfs2-server.h"

static int getconfig_cleanup(PINT_server_op *s_op, job_status_s* js_p);
static int getconfig_init(PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_get_config_sm = {
	.name = "pvfs2_get_config_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_get_config_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_init },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_init[] = {
	{ .state_name = "init" },
	{ .parent_machine = &pvfs2_get_config_sm },
	{ .flag = SM_NONE },
	{ .state_action = getconfig_init },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_get_config_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_get_config_sm },
	{ .flag = SM_NONE },
	{ .state_action = getconfig_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 50 "src/server/get-config.sm"



/*
 * Function: getconfig_init
 *
 * Params:   server_op *b, 
 *           job_status_s* js_p
 *
 * Pre:      fs_id mapping exists on server
 *
 * Post:     None
 *
 * Returns:  void
 *
 * Synopsis: Get information from config structure
 *           then move to next state.
 *           
 */

static int getconfig_init(PINT_server_op *s_op, job_status_s* js_p)
{
    struct server_configuration_s *user_opts = get_server_config_struct();
    assert(user_opts);

    /* TODO: handle this properly later */
    assert(user_opts->fs_config_buflen <= PVFS_REQ_LIMIT_CONFIG_FILE_BYTES);
    assert(user_opts->server_config_buflen <= PVFS_REQ_LIMIT_CONFIG_FILE_BYTES);

    s_op->resp.u.getconfig.fs_config_buf_size =
        (uint32_t)user_opts->fs_config_buflen;
    s_op->resp.u.getconfig.fs_config_buf =
        (char*)user_opts->fs_config_buf;
    s_op->resp.u.getconfig.server_config_buf_size =
        (uint32_t)user_opts->server_config_buflen;
    s_op->resp.u.getconfig.server_config_buf =
        (char*)user_opts->server_config_buf;

    js_p->error_code = 0;
    return(1);
}

/*
 * Function: getconfig_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s* js_p
 *
 * Pre:      None
 *
 * Post:     None
 *
 * Returns:  void
 *
 * Synopsis: cleans up string memory
 *           response structure
 */

static int getconfig_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    return(server_state_machine_complete(s_op));
}


/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

