/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-internal.h"

/*
 * if given a metafile, do a keyval flush
 * if given a datafile, do a bstream flush
 */
enum
{
    FLUSH_KEYVAL  = 4,
    FLUSH_BSTREAM = 5
};

static int flush_check_type(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_keyval_flush(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_bstream_flush(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_cleanup(
    PINT_server_op *s_op, job_status_s *ret);
static int flush_check_error(
    PINT_server_op *s_op, job_status_s *js_p);
void flush_init_state_machine(void);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_flush_check_type[];
static union PINT_state_array_values ST_kflush[];
static union PINT_state_array_values ST_kflush_check_error[];
static union PINT_state_array_values ST_bflush[];
static union PINT_state_array_values ST_bflush_check_error[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_flush_sm = {
	.name = "pvfs2_flush_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_flush_check_type },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_flush_check_type[] = {
	{ .state_name = "flush_check_type" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_check_type },
	{ .return_value = FLUSH_KEYVAL },
	{ .next_state = ST_kflush },
	{ .return_value = FLUSH_BSTREAM },
	{ .next_state = ST_bflush },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_kflush[] = {
	{ .state_name = "kflush" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_keyval_flush },
	{ .return_value = -1 },
	{ .next_state = ST_kflush_check_error }
};

static union PINT_state_array_values ST_kflush_check_error[] = {
	{ .state_name = "kflush_check_error" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_check_error },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_bflush[] = {
	{ .state_name = "bflush" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_bstream_flush },
	{ .return_value = -1 },
	{ .next_state = ST_bflush_check_error }
};

static union PINT_state_array_values ST_bflush_check_error[] = {
	{ .state_name = "bflush_check_error" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_check_error },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_flush_sm },
	{ .flag = SM_NONE },
	{ .state_action = flush_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 104 "src/server/flush.sm"


static int flush_check_type(PINT_server_op *s_op, job_status_s *js_p)
{
    js_p->error_code = 0;

    if (s_op->attr.objtype == PVFS_TYPE_METAFILE)
    {
        js_p->error_code = FLUSH_KEYVAL;
    }
    else if (s_op->attr.objtype == PVFS_TYPE_DATAFILE)
    {
        js_p->error_code = FLUSH_BSTREAM;
    }
    return 1;
}

/*
 * Function: flush_keyval_flush
 *
 * Params:  server_op *s_op,
 *	    job_status_s *js_p
 *
 * Pre: None
 * Post: None
 * Returns: int
 *
 * Synopsys: send a keyval flush request to storage
 *
 */
static int flush_keyval_flush(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t tmp_id;

    gossip_debug(GOSSIP_SERVER_DEBUG, " doing keyval flush on %llu,%d\n",
                 llu(s_op->req->u.flush.handle), s_op->req->u.flush.fs_id);

    ret = job_trove_keyval_flush(
        s_op->req->u.flush.fs_id,
        s_op->req->u.flush.handle,
        s_op->req->u.flush.flags,
        s_op,
        PINT_config_get_trove_meta_flags(
            get_server_config_struct(), s_op->req->u.flush.fs_id),
        js_p,
        &tmp_id,
        server_job_context);

    return ret;
}

static int flush_check_error(PINT_server_op *s_op, job_status_s *js_p)
{
    char buf[64] = {0};
    if (js_p->error_code != 0)
    {
        PVFS_strerror_r(js_p->error_code, buf, 64);

        gossip_err("failed to flush handle %llu: %s\n",
                   llu(s_op->req->u.flush.handle), buf);
    }
    return 1;
}

/*
 * Function: flush_bstream_flush
 *
 * Params:  server_op *s_op,
 *	    job_status_s *js_p
 *
 * Pre: None
 * Post: None
 * Returns: int
 *
 * Synopsys: send a bstream flush request to storage
 *
 */
static int flush_bstream_flush(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t i;

    gossip_debug(GOSSIP_SERVER_DEBUG, " doing bstream flush on %llu,%d\n",
                 llu(s_op->req->u.flush.handle), s_op->req->u.flush.fs_id);

    ret = job_trove_bstream_flush(
        s_op->req->u.flush.fs_id,
        s_op->req->u.flush.handle,
        s_op->req->u.flush.flags,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}
	    
static int flush_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
