/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "gossip.h"
#include "pvfs2-internal.h"

static int create_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int create_create(
    PINT_server_op *s_op, job_status_s* js_p);
static int create_setup_resp(
    PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_create[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_create_sm = {
	.name = "pvfs2_create_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_create_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_create },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_create[] = {
	{ .state_name = "create" },
	{ .parent_machine = &pvfs2_create_sm },
	{ .flag = SM_NONE },
	{ .state_action = create_create },
	{ .return_value = -1 },
	{ .next_state = ST_setup_resp }
};

static union PINT_state_array_values ST_setup_resp[] = {
	{ .state_name = "setup_resp" },
	{ .parent_machine = &pvfs2_create_sm },
	{ .flag = SM_NONE },
	{ .state_action = create_setup_resp },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_create_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_create_sm },
	{ .flag = SM_NONE },
	{ .state_action = create_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 64 "src/server/create.sm"


/*
 * Function: create_create
 *
 * Params:   server_op *s_op, 
 *           job_status_s* js_p
 *
 * Pre:      None
 *
 * Post:     None
 *
 * Returns:  int
 *
 * Synopsis: Create the new dataspace with the values provided in the response.
 *           
 */
static int create_create(PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -1;
    job_id_t i;
    struct server_configuration_s *user_opts = get_server_config_struct();

    ret = job_trove_dspace_create(
        s_op->req->u.create.fs_id,
        &s_op->req->u.create.handle_extent_array,
        s_op->req->u.create.object_type,
        NULL,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.create.fs_id) |
        PINT_config_get_trove_meta_flags(
            user_opts, s_op->req->u.create.fs_id),
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return(ret);
}

/* create_setup_resp()
 *
 * fills in the response structure based on results of previous operation
 */
static int create_setup_resp(PINT_server_op *s_op, job_status_s* js_p)
{
    if (js_p->error_code == 0)
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "Handle created: %llu\n",
                     llu(js_p->handle));
	s_op->resp.u.create.handle = js_p->handle;
        switch(s_op->req->u.create.object_type)
        {
            case PVFS_TYPE_NONE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %llu, type unknown.\n");
                break;
            case PVFS_TYPE_METAFILE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %llu, type metafile.\n");
                break;
            case PVFS_TYPE_DATAFILE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %llu, type datafile.\n");
                break;
            case PVFS_TYPE_DIRECTORY:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %llu, type directory.\n");
                break;
            case PVFS_TYPE_SYMLINK:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %llu, type symlink.\n");
                break;
            case PVFS_TYPE_DIRDATA:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %llu, type dirdata.\n");
                break;
        }
    }

    /* NOTE: we _deliberately_ leave the error_code unchanged so that it
     * can be used by the next state.
     */
    return(1);
}


/*
 * Function: create_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s* js_p
 *
 * Pre:      None
 *
 * Post:     None
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int create_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    return(server_state_machine_complete(s_op));
}


/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
