/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <ctype.h>
#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-util.h"
#include "pvfs2-internal.h"

enum
{
    INVALID_OBJECT = 131,
    UPDATE_DIR_ATTR_REQUIRED
};

static int crdirent_setup_op(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_validate(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_write_directory_entry(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_check_for_req_dir_update(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_update_directory_attr(
    PINT_server_op *s_op, job_status_s *js_p);
static int crdirent_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int validation_object_type_failure(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_setup_op[];
static union PINT_state_array_values ST_validate[];
static union PINT_state_array_values ST_validation_object_type_failure[];
static union PINT_state_array_values ST_read_directory_entry_handle[];
static union PINT_state_array_values ST_write_directory_entry[];
static union PINT_state_array_values ST_check_for_req_dir_update[];
static union PINT_state_array_values ST_update_directory_attr[];
static union PINT_state_array_values ST_cleanup[];
static union PINT_state_array_values ST_final_response[];

struct PINT_state_machine_s pvfs2_crdirent_sm = {
	.name = "pvfs2_crdirent_sm",
	.state_machine = ST_prelude
};

static union PINT_state_array_values ST_prelude[] = {
	{ .state_name = "prelude" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_prelude_sm },
	{ .return_value = 0 },
	{ .next_state = ST_setup_op },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_setup_op[] = {
	{ .state_name = "setup_op" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_setup_op },
	{ .return_value = -1 },
	{ .next_state = ST_validate }
};

static union PINT_state_array_values ST_validate[] = {
	{ .state_name = "validate" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_validate },
	{ .return_value = 0 },
	{ .next_state = ST_read_directory_entry_handle },
	{ .return_value = INVALID_OBJECT },
	{ .next_state = ST_validation_object_type_failure },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_validation_object_type_failure[] = {
	{ .state_name = "validation_object_type_failure" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = validation_object_type_failure },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_read_directory_entry_handle[] = {
	{ .state_name = "read_directory_entry_handle" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_read_directory_entry_handle },
	{ .return_value = 0 },
	{ .next_state = ST_write_directory_entry },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_write_directory_entry[] = {
	{ .state_name = "write_directory_entry" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_write_directory_entry },
	{ .return_value = 0 },
	{ .next_state = ST_check_for_req_dir_update },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_check_for_req_dir_update[] = {
	{ .state_name = "check_for_req_dir_update" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_check_for_req_dir_update },
	{ .return_value = UPDATE_DIR_ATTR_REQUIRED },
	{ .next_state = ST_update_directory_attr },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_update_directory_attr[] = {
	{ .state_name = "update_directory_attr" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_update_directory_attr },
	{ .return_value = -1 },
	{ .next_state = ST_final_response }
};

static union PINT_state_array_values ST_final_response[] = {
	{ .state_name = "final_response" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_final_response_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_crdirent_sm },
	{ .flag = SM_NONE },
	{ .state_action = crdirent_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 123 "src/server/crdirent.sm"


/*
 * Function: crdirent_validate
 *
 * Synopsis: verifies that entry name and object type is valid
 */
static int crdirent_validate(PINT_server_op *s_op,
                             job_status_s *js_p)
{
    char *ptr = NULL;

    if ((s_op->u.crdirent.name == NULL) ||
        (s_op->u.crdirent.parent_handle == PVFS_HANDLE_NULL))
    {
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }

    gossip_debug(GOSSIP_SERVER_DEBUG,
            "  got crdirent for %s (with handle %llu) in %llu\n",
            s_op->u.crdirent.name,
            llu(s_op->u.crdirent.new_handle),
            llu(s_op->u.crdirent.parent_handle));

    /* check for invalid characters in name */
    ptr = s_op->u.crdirent.name;
    while (*ptr != '\0' && *ptr != '/' ) ptr++;

    if (*ptr != '\0')
    {
        /* found an invalid character -- report it and send error response */
        gossip_lerr("crdirent: error: invalid character (%s)"
                "in name (%s); sending error response.\n",
                ptr, s_op->u.crdirent.name);
        /* for parity with linux VFS, allow any character except / in 
         * filenames.   */
        
        js_p->error_code = -PVFS_EINVAL;

         /* Do not zero the scheduled_id, as this operation was
          * scheduled before we checked the filename */
        return 1;
    }

    /* make sure we're dealing with a directory */
    if (!(s_op->attr.mask & PVFS_ATTR_COMMON_TYPE) ||
        !(s_op->attr.objtype == PVFS_TYPE_DIRECTORY))
    {
        gossip_debug(GOSSIP_SERVER_DEBUG, " Cannot read dirent on "
                     "a non-directory!  Returning error.\n");

        js_p->error_code = INVALID_OBJECT;
        return 1;
    }

    js_p->error_code = 0;
    return 1;
}

/*
 * Function: crdirent_read_directory_entry_handle
 *
 * Params:   server_op *s_op, 
 *           job_status_s *js_p
 *
 * Pre:      s_op->u.crdirent.parent_handle is handle of directory
 *
 * Post:     s_op->val.buffer is the directory entry k/v space OR NULL
 *           if first entry
 *
 * Returns:  int
 *
 * Synopsis: Given a directory handle, look up the handle used to store
 * directory entries for this directory.
 *
 * Get the directory entry handle for the directory entry k/v space.
 * Recall that directories have two key-val spaces, one of which is
 * synonymous with files where the metadata is stored.  The other
 * space holds the filenames and their handles.  In this function, we
 * attempt to retrieve the handle for the filename/handle key/val
 * space and if it does not exist, we need to create it.
 *
 */
static int crdirent_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    /* get the key and key size out of our list of common keys */
    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    /* store the handle in the crdirent-specific space in s_op */
    s_op->val.buffer = &s_op->u.crdirent.dirent_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    ret = job_trove_keyval_read(
        s_op->u.crdirent.fs_id,
        s_op->u.crdirent.parent_handle,
        &s_op->key,
        &s_op->val,
        PINT_config_get_trove_meta_flags(
            get_server_config_struct(), s_op->u.crdirent.fs_id),
        NULL,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}

static int validation_object_type_failure(
    PINT_server_op *s_op, job_status_s *js_p)
{
    gossip_debug(GOSSIP_SERVER_DEBUG, "crdirent: validation_object_"
                 "type_failure called\n");

    js_p->error_code = -PVFS_ENOTDIR;
    return 1;
}

/*
 * Function: crdirent_write_directory_entry
 *
 * Params:   server_op *s_op, 
 *           job_status_s *js_p
 *
 * Pre:      s_op->u.crdirent.dirent_handle is the directory entry k/v space
 *           s_op->u.crdirent.name != NULL
 *           s_op->u.crdirent.new_handle != NULL
 *
 * Post:     key/val pair stored
 *
 * Returns:  int
 *
 * Synopsis: We are now ready to store the name/handle pair in the k/v
 *           space for directory handles.
 */
static int crdirent_write_directory_entry(PINT_server_op *s_op,
                                          job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;
    TROVE_ds_flags keyval_flags;

    assert(s_op->u.crdirent.dirent_handle);

    js_p->error_code = 0;

    /* This buffer came from one of two places, either phase two of
     * creating the directory space when we wrote the value back to
     * trove, or from the initial read from trove.
     */

    /* this is the name for the parent entry */
    s_op->key.buffer = s_op->u.crdirent.name;
    s_op->key.buffer_sz = strlen(s_op->u.crdirent.name) + 1;

    s_op->val.buffer = &s_op->u.crdirent.new_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(GOSSIP_SERVER_DEBUG, "  writing new directory entry "
                 "for %s (handle = %llu) to dirdata dspace %llu\n",
                 s_op->u.crdirent.name, llu(s_op->u.crdirent.new_handle),
                 llu(s_op->u.crdirent.dirent_handle));

    /* get the flags from the config file, such as immediate completion
     * or sync coalescing. 
     */
    keyval_flags = PINT_config_get_trove_meta_flags(
        get_server_config_struct(), s_op->u.crdirent.fs_id);
    
    /* here we add the sync flag if its specified in the config file */
    keyval_flags |= PINT_config_get_trove_sync_meta(
        get_server_config_struct(), s_op->u.crdirent.fs_id);
        
    /* Specify that we want an error returned if the entry already exists.
     * This allows us to return an EEXIST error back to the client
     */
    keyval_flags |= TROVE_NOOVERWRITE;

    /* We also want to keep track of the keyval entries added on this
     * handle, which allows us to get the size of the directory later
     */
    keyval_flags |= TROVE_KEYVAL_HANDLE_COUNT;

    ret = job_trove_keyval_write(
        s_op->u.crdirent.fs_id, s_op->u.crdirent.dirent_handle,
        &s_op->key, &s_op->val, 
        keyval_flags,
        NULL, s_op, 0, js_p, &i, server_job_context);

    /*
      check if any attributes have changed on the parent that require
      an update; object times only are considered
    */
    if (s_op->req->u.crdirent.parent_atime ||
        s_op->req->u.crdirent.parent_mtime ||
        s_op->req->u.crdirent.parent_ctime)
    {
        s_op->u.crdirent.dir_attr_update_required = 1;
    }
    return ret;
}

static int crdirent_check_for_req_dir_update(
    PINT_server_op *s_op, job_status_s *js_p)
{
    if ((js_p->error_code == 0) &&
        (s_op->u.crdirent.dir_attr_update_required))
    {
        js_p->error_code = UPDATE_DIR_ATTR_REQUIRED;
    }
    return 1;
}
    
static int crdirent_update_directory_attr(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t j_id;
    PVFS_object_attr tmp_attr, *tmp_attr_ptr = &tmp_attr;
    PVFS_object_attr *dspace_attr = NULL;
    PVFS_ds_attributes *ds_attr = NULL;
    struct server_configuration_s *user_opts = get_server_config_struct();

    if (js_p->error_code != UPDATE_DIR_ATTR_REQUIRED)
    {
        PVFS_perror_gossip("previous keyval write failed",
                           js_p->error_code);
        return 1;
    }

    memset(&tmp_attr, 0, sizeof(PVFS_object_attr));
    dspace_attr = &s_op->attr;
    ds_attr = &(s_op->ds_attr);

    PVFS_object_attr_overwrite_setable(tmp_attr_ptr, dspace_attr);

    /* overwrite all non-null attribute time fields */
    if (s_op->req->u.crdirent.parent_atime)
    {
        tmp_attr_ptr->atime = s_op->req->u.crdirent.parent_atime;
    }

    if (s_op->req->u.crdirent.parent_mtime)
    {
        /*
          directory mtime is stored as a version, but converted to a
          normal mtime on getattr; the mtime version is passed back on
          readdir operations
        */
        gossip_debug(
            GOSSIP_SERVER_DEBUG, "updating parent dir version "
            "to %llu\n\tmtime is %llu\n",
            llu(PVFS_util_mktime_version(s_op->req->u.crdirent.parent_mtime)),
            llu(s_op->req->u.crdirent.parent_mtime));

        tmp_attr_ptr->mtime = PVFS_util_mktime_version(
                    s_op->req->u.crdirent.parent_mtime);
    }

    if (s_op->req->u.crdirent.parent_ctime)
    {
        tmp_attr_ptr->ctime = s_op->req->u.crdirent.parent_ctime;
    }

    ds_attr = &(s_op->ds_attr);
    PVFS_object_attr_to_ds_attr(tmp_attr_ptr, ds_attr);

    ret = job_trove_dspace_setattr(
        s_op->req->u.crdirent.fs_id, s_op->req->u.crdirent.parent_handle,
        ds_attr, 
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.crdirent.fs_id) |
        PINT_config_get_trove_meta_flags(
            user_opts, s_op->req->u.crdirent.fs_id),
        s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

static int crdirent_cleanup(PINT_server_op *s_op,
                            job_status_s *js_p)
{
    return(server_state_machine_complete(s_op));
}

/* crdirent_setup_op()
 *
 * prepare some state machine fields for later processing; mainly just
 * storing request structure fields in state machine so that nested
 * machines are not dependent on request type
 */
static int crdirent_setup_op(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "crdirent entry: %s points to %llu\n",
        s_op->req->u.crdirent.name, llu(s_op->req->u.crdirent.new_handle));

    s_op->u.crdirent.name = s_op->req->u.crdirent.name;
    s_op->u.crdirent.new_handle = s_op->req->u.crdirent.new_handle;
    s_op->u.crdirent.parent_handle = s_op->req->u.crdirent.parent_handle;
    s_op->u.crdirent.fs_id = s_op->req->u.crdirent.fs_id;
    s_op->u.crdirent.dir_attr_update_required = 0;

    js_p->error_code = 0;
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
