/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for modifying the size of a file,
 *  either growing or shrinking.
 */
#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-util.h"
#include "pint-request.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "acache.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

static int truncate_datafile_setup_msgpairarray(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int truncate_datafile_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int truncate_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static union PINT_state_array_values ST_truncate_getattr[];
static union PINT_state_array_values ST_truncate_datafile_setup_msgpairarray[];
static union PINT_state_array_values ST_truncate_datafile_xfer_msgpairarray[];
static union PINT_state_array_values ST_truncate_datafile_failure[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_truncate_sm = {
	.name = "pvfs2_client_truncate_sm",
	.state_machine = ST_truncate_getattr
};

static union PINT_state_array_values ST_truncate_getattr[] = {
	{ .state_name = "truncate_getattr" },
	{ .parent_machine = &pvfs2_client_truncate_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_client_getattr_sm },
	{ .return_value = 0 },
	{ .next_state = ST_truncate_datafile_setup_msgpairarray },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_truncate_datafile_setup_msgpairarray[] = {
	{ .state_name = "truncate_datafile_setup_msgpairarray" },
	{ .parent_machine = &pvfs2_client_truncate_sm },
	{ .flag = SM_NONE },
	{ .state_action = truncate_datafile_setup_msgpairarray },
	{ .return_value = 0 },
	{ .next_state = ST_truncate_datafile_xfer_msgpairarray },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_truncate_datafile_xfer_msgpairarray[] = {
	{ .state_name = "truncate_datafile_xfer_msgpairarray" },
	{ .parent_machine = &pvfs2_client_truncate_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = 0 },
	{ .next_state = ST_cleanup },
	{ .return_value = -1 },
	{ .next_state = ST_truncate_datafile_failure }
};

static union PINT_state_array_values ST_truncate_datafile_failure[] = {
	{ .state_name = "truncate_datafile_failure" },
	{ .parent_machine = &pvfs2_client_truncate_sm },
	{ .flag = SM_NONE },
	{ .state_action = truncate_datafile_failure },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_client_truncate_sm },
	{ .flag = SM_NONE },
	{ .state_action = truncate_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 81 "src/client/sysint/sys-truncate.sm"


/** Initiate resizing of a file.
 */
PVFS_error PVFS_isys_truncate(
    PVFS_object_ref ref,
    PVFS_size size,
    PVFS_credentials *credentials,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    if ((ref.fs_id == PVFS_FS_ID_NULL) ||
        (ref.handle == PVFS_HANDLE_NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    if (size < 0)
    {
        gossip_err("invalid size (negative) specified: %lld\n", lld(size));
        return ret;
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_isys_truncate entered with %lld\n", lld(size));

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.truncate.size = size;
    sm_p->object_ref = ref;

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_META_ALL|PVFS_ATTR_COMMON_TYPE,
        PVFS_TYPE_METAFILE,
        0);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_TRUNCATE, op_id, user_ptr);
}

PVFS_error PVFS_sys_truncate(
    PVFS_object_ref ref,
    PVFS_size size,
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_sys_truncate entered with %lld\n", lld(size));

    ret = PVFS_isys_truncate(ref, size, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_truncate call", ret);
        error = ret;
    }
    else
    {
        ret = PVFS_sys_wait(op_id, "truncate", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PVFS_sys_release(op_id);
    return error;
}

/** Resize a file.
 */
static int truncate_datafile_setup_msgpairarray(PINT_client_sm *sm_p,
                                                job_status_s *js_p)
{
    int ret = -PVFS_EINVAL, i = 0;
    PVFS_object_attr *attr = NULL;
    PINT_sm_msgpair_state *msg_p = NULL;
    PVFS_size new_dfile_size = 0;
    PINT_request_file_data file_data;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG,
            "(%p) truncate state: datafile_setup_msgpairarray\n", sm_p);

    js_p->error_code = 0;

    attr = &sm_p->getattr.attr;
    assert(attr);

    assert(attr->mask & PVFS_ATTR_META_DFILES);
    assert(attr->mask & PVFS_ATTR_META_DIST);
    assert(attr->u.meta.dfile_count > 0);
    assert(attr->u.meta.dist_size > 0);

    sm_p->msgarray_count = attr->u.meta.dfile_count;

    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        sm_p->msgarray_count * sizeof(PINT_sm_msgpair_state));
    if (!sm_p->msgarray)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    /* Initialize the file data struct */
    memset(&file_data, 0, sizeof(file_data));
    file_data.dist = attr->u.meta.dist;
    file_data.server_ct = attr->u.meta.dfile_count;
    file_data.extend_flag = 1;

    /* Construct truncate messages */
    for (i = 0; i < attr->u.meta.dfile_count; i++)
    {
        msg_p = &sm_p->msgarray[i];

        gossip_debug(
            GOSSIP_CLIENT_DEBUG,
            "  datafile_truncate: client requests %lld: resizing %lld",
            lld(sm_p->u.truncate.size),
            llu(attr->u.meta.dfile_array[i]));

        file_data.server_nr = i;
        new_dfile_size = 
            attr->u.meta.dist->methods->logical_to_physical_offset(
                attr->u.meta.dist->params,
                &file_data,
                sm_p->u.truncate.size);
       
        gossip_debug(GOSSIP_CLIENT_DEBUG,
                " to %lld bytes\n", lld(new_dfile_size));

        PINT_SERVREQ_TRUNCATE_FILL(
            msg_p->req,
            *sm_p->cred_p,
            sm_p->object_ref.fs_id,
            new_dfile_size,
            attr->u.meta.dfile_array[i]);
        /*
          no callback. the status will be in the generic response
          structure
        */
        msg_p->fs_id = sm_p->object_ref.fs_id;
        msg_p->handle = attr->u.meta.dfile_array[i];
        msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
        msg_p->comp_fn = NULL;
    }

    sm_p->getattr.size = sm_p->u.truncate.size;
    ret = PINT_serv_msgpairarray_resolve_addrs(
        sm_p->msgarray_count, sm_p->msgarray);

    if (ret)
    {
        gossip_err("Error: failed to resolve server addresses.\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int truncate_datafile_failure(PINT_client_sm *sm_p,
                                     job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
            "(%p) truncate state: datafile_failure\n", sm_p);
    return 1;
}

static int truncate_cleanup(PINT_client_sm *sm_p,
                            job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "(%p) truncate state: "
                 "truncate_cleanup\n", sm_p);

    sm_p->error_code = js_p->error_code;

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    if(sm_p->error_code == 0)
    {
        PINT_acache_invalidate_size(sm_p->object_ref);
    }
    else
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
