/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>

#include "client-state-machine.h"
#include "pint-perf-counter.h"

extern job_context_id pint_client_sm_context;

static int perf_count_timer_do_work(
    PINT_client_sm *sm_p, job_status_s* js_p);
static int perf_count_timer_error(
    PINT_client_sm *sm_p, job_status_s* js_p);

static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_error[];

struct PINT_state_machine_s pvfs2_client_perf_count_timer_sm = {
	.name = "pvfs2_client_perf_count_timer_sm",
	.state_machine = ST_do_work
};

static union PINT_state_array_values ST_do_work[] = {
	{ .state_name = "do_work" },
	{ .parent_machine = &pvfs2_client_perf_count_timer_sm },
	{ .flag = SM_NONE },
	{ .state_action = perf_count_timer_do_work },
	{ .return_value = 0 },
	{ .next_state = ST_do_work },
	{ .return_value = -1 },
	{ .next_state = ST_error }
};

static union PINT_state_array_values ST_error[] = {
	{ .state_name = "error" },
	{ .parent_machine = &pvfs2_client_perf_count_timer_sm },
	{ .flag = SM_NONE },
	{ .state_action = perf_count_timer_error },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 42 "src/client/sysint/perf-count-timer.sm"


/* perf_count_timer_error()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int perf_count_timer_error(PINT_client_sm *sm_p, job_status_s* js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "perf timer state: perf_count_timer_error\n");
    gossip_err("Error: stopping client perf timer.\n");

    sm_p->op_complete = 1;
    return 0;
}

/* perf_count_timer_do_work()
 *
 * periodically resets performance counters
 */
static int perf_count_timer_do_work(PINT_client_sm *sm_p, job_status_s* js_p)
{
    job_id_t tmp_id;
    uint64_t current_mask = 0;
    int current_debug_on = 0;
    char* tmp_text;
    char* ptr;
    char* token;
    char delim[] = "\n";

#if 0
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "perf count timer state: perf_count_timer_do_work\n");
#endif
    
    /* log current statistics if the gossip mask permits */
    gossip_get_debug_mask(&current_debug_on, &current_mask);
    if(current_mask & GOSSIP_PERFCOUNTER_DEBUG)
    {
        tmp_text = PINT_perf_generate_text(sm_p->u.perf_count_timer.pc, 4096);
        if(tmp_text)
        {
            token = strtok_r(tmp_text, delim, &ptr);
            while(token)
            {
                gossip_perf_log("%s\n", token);
                token = strtok_r(NULL, delim, &ptr);
            }
            free(tmp_text);
        }
    }
 
    PINT_perf_rollover(sm_p->u.perf_count_timer.pc);
        
    /* post another timer */
    return job_req_sched_post_timer(
        ((*sm_p->u.perf_count_timer.interval_secs)*1000), 
        sm_p, 0, js_p, &tmp_id, pint_client_sm_context);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
