/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for sending "no operation"
 *  (no-op) requests.  This is primarily used for verifying connectivity
 *  to servers.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "bmi.h"

extern job_context_id pint_client_sm_context;

static int mgmt_noop_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_noop_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_noop_sm = {
	.name = "pvfs2_client_mgmt_noop_sm",
	.state_machine = ST_setup_msgpair
};

static union PINT_state_array_values ST_setup_msgpair[] = {
	{ .state_name = "setup_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_noop_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_noop_setup_msgpair },
	{ .return_value = 0 },
	{ .next_state = ST_xfer_msgpair },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
	{ .state_name = "xfer_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_noop_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_client_mgmt_noop_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_noop_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 62 "src/client/sysint/mgmt-noop.sm"


/** Initiate sending of no-op request to a specific server.
 */
PVFS_error PVFS_imgmt_noop(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_BMI_addr_t addr,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_imgmt_noop entered\n");

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (!sm_p)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->msgpair.fs_id = fs_id;
    sm_p->msgpair.retry_flag = PVFS_MSGPAIR_NO_RETRY;
    sm_p->msgpair.svr_addr = addr;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_mgmt_noop calling "
                 "PINT_client_state_machine_post()\n");

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_NOOP, op_id, user_ptr);
}

/** Send a no-op request to a specific server and receive response.
 */
PVFS_error PVFS_mgmt_noop(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_BMI_addr_t addr)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_mgmt_noop entered\n");

    ret = PVFS_imgmt_noop(fs_id, credentials, addr, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_noop call", ret);
        error = ret;
    }
    else
    {
        ret = PVFS_mgmt_wait(op_id, "noop", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    PVFS_mgmt_release(op_id);
    return error;
}

static int mgmt_noop_setup_msgpair(PINT_client_sm *sm_p,
                                   job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "noop state: mgmt_noop_setup_msgpair\n");

    PINT_SERVREQ_MGMT_NOOP_FILL(sm_p->msgpair.req, *sm_p->cred_p);

    sm_p->msgarray = &(sm_p->msgpair);
    sm_p->msgarray_count = 1;

    js_p->error_code = 0;
    return 1;
}

static int mgmt_noop_cleanup(PINT_client_sm *sm_p,
                             job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "noop state: mgmt_noop_cleanup\n");

    sm_p->error_code = js_p->error_code;
    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
