/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/*
 * (C) 2001 Clemson University and The University of Chicago
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management routines for iterating through handles of objects
 *  stored on servers. These routines are used primarily for file system
 *  check and repair purposes.
 */

#include <string.h>

#include "client-state-machine.h"
#include "pvfs2-types.h"
#include "pvfs2-mgmt.h"
#include "server-config.h"

extern job_context_id pint_client_sm_context;

/* state function prototypes */
static int mgmt_iterate_handles_list_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_iterate_handles_list_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int iterate_handles_list_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_iterate_handles_list_sm = {
	.name = "pvfs2_client_mgmt_iterate_handles_list_sm",
	.state_machine = ST_setup_msgpair
};

static union PINT_state_array_values ST_setup_msgpair[] = {
	{ .state_name = "setup_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_iterate_handles_list_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_iterate_handles_list_setup_msgpair },
	{ .return_value = 0 },
	{ .next_state = ST_xfer_msgpair },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
	{ .state_name = "xfer_msgpair" },
	{ .parent_machine = &pvfs2_client_mgmt_iterate_handles_list_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = -1 },
	{ .next_state = ST_cleanup }
};

static union PINT_state_array_values ST_cleanup[] = {
	{ .state_name = "cleanup" },
	{ .parent_machine = &pvfs2_client_mgmt_iterate_handles_list_sm },
	{ .flag = SM_NONE },
	{ .state_action = mgmt_iterate_handles_list_cleanup },
	{ .return_value = -1 },
	{ .flag = SM_TERMINATE }
};

# 61 "src/client/sysint/mgmt-iterate-handles-list.sm"


/** Initiate retrieval of a list of handles in use on a collection of
 *  servers.
 *
 * \return 0 on success, -PVFS_error on failure.
 */
PVFS_error PVFS_imgmt_iterate_handles_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_handle **handle_matrix,
    int *handle_count_array,
    PVFS_ds_position *position_array,
    PVFS_BMI_addr_t *addr_array,
    int server_count,
    PVFS_error_details *details,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_iterate_handles_list() entered.\n");

    if (server_count < 1 || !handle_matrix || !position_array 
	|| !handle_count_array || !addr_array)
    {
	return -PVFS_EINVAL;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.iterate_handles_list.fs_id = fs_id;
    sm_p->u.iterate_handles_list.server_count = server_count;
    sm_p->u.iterate_handles_list.addr_array = addr_array;
    sm_p->u.iterate_handles_list.handle_matrix = handle_matrix;
    sm_p->u.iterate_handles_list.handle_count_array = handle_count_array;
    sm_p->u.iterate_handles_list.position_array = position_array;
    sm_p->u.iterate_handles_list.details = details;

    sm_p->msgarray_count = server_count;
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        server_count * sizeof(PINT_sm_msgpair_state));
    if (sm_p->msgarray == NULL)
    {
        PVFS_util_release_credentials(sm_p->cred_p);
        free(sm_p);
        return -PVFS_ENOMEM;
    }

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_ITERATE_HANDLES_LIST, op_id, user_ptr);
}

/** Obtain a list of handles in use on a collection of servers.
 */
PVFS_error PVFS_mgmt_iterate_handles_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_handle **handle_matrix,
    int *handle_count_array,
    PVFS_ds_position *position_array,
    PVFS_BMI_addr_t *addr_array,
    int server_count,
    PVFS_error_details *details)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_iterate_handles_list entered\n");

    ret = PVFS_imgmt_iterate_handles_list(
        fs_id, credentials, handle_matrix, handle_count_array,
        position_array, addr_array, server_count, details, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_iterate_handles_list call", ret);
        error = ret;
    }
    else
    {
        ret = PVFS_mgmt_wait(op_id, "iterate_handles_list", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_iterate_handles_list completed\n");

    PVFS_mgmt_release(op_id);
    return error;
}

static int mgmt_iterate_handles_list_setup_msgpair(PINT_client_sm * sm_p,
						   job_status_s * js_p)
{
    int i = 0, j = 0;
    PINT_sm_msgpair_state *msg_p;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "iterate_handles_list state: "
                 "mgmt_iterate_handles_list_setup_msgpair\n");

    /* setup msgpair array */
    j=0;
    for(i=0; i < sm_p->u.iterate_handles_list.server_count; i++)
    {
	msg_p = &sm_p->msgarray[j];

	/* skip servers that have already reached end */
	/* TODO: use a better #define or something for ITERATE_END */
	if(sm_p->u.iterate_handles_list.position_array[i]
	    == PVFS_ITERATE_END)
	{
	    sm_p->msgarray_count--;
	    sm_p->u.iterate_handles_list.handle_count_array[i] = 0;
	}
	else
	{
	    PINT_SERVREQ_MGMT_ITERATE_HANDLES_FILL(
                msg_p->req,
		*sm_p->cred_p,
		sm_p->u.iterate_handles_list.fs_id,
		sm_p->u.iterate_handles_list.handle_count_array[i],
		sm_p->u.iterate_handles_list.position_array[i]);
	    j++;
	    msg_p->fs_id = sm_p->u.iterate_handles_list.fs_id;
	    msg_p->handle = PVFS_HANDLE_NULL;
	    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
	    msg_p->comp_fn = iterate_handles_list_comp_fn;
	    msg_p->svr_addr = sm_p->u.iterate_handles_list.addr_array[i];
	}
    }

    /* TODO: be nicer about this, user called function too many times */
    assert(sm_p->msgarray_count > 0);

    /* immediate return: next state jumps to msgpairarray machine */
    js_p->error_code = 0;
    return 1;
}

static int mgmt_iterate_handles_list_cleanup(PINT_client_sm * sm_p,
					     job_status_s * js_p)
{
    int i = 0, errct = 0;
    PVFS_error error = js_p->error_code;

    /* store server-specific errors if requested and present */
    if ((error != 0) && (sm_p->u.iterate_handles_list.details != NULL))
    {
	sm_p->u.iterate_handles_list.details->count_exceeded = 0;

	for(i = 0; i < sm_p->u.iterate_handles_list.server_count; i++)
        {
	    if (sm_p->msgarray[i].op_status != 0)
	    {
		if (errct <
                    sm_p->u.iterate_handles_list.details->count_allocated)
		{
		    sm_p->u.iterate_handles_list.details->error[
                        errct].error = sm_p->msgarray[i].op_status;
		    sm_p->u.iterate_handles_list.details->error[
                        errct].addr = sm_p->msgarray[i].svr_addr;
		    errct++;
		}
		else
		{
		    sm_p->u.iterate_handles_list.details->count_exceeded = 1;
		}
	    }
	}
	sm_p->u.iterate_handles_list.details->count_used = errct;
	error = -PVFS_EDETAIL;
    }

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
	free(sm_p->msgarray);
    }

    sm_p->error_code  = error;
    sm_p->op_complete = 1;

    return 0;
}

static int iterate_handles_list_comp_fn(void *v_p,
					struct PVFS_server_resp *resp_p,
					int i)
{
    int j = 0;
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;

    /* if this particular request was successful, then collect info from 
     * response
     */
    if (sm_p->msgarray[i].op_status == 0)
    {
	/* first, we have to match this up with the correct array entry */
	for (j=0; j<sm_p->u.iterate_handles_list.server_count; j++)
	{
	    if (sm_p->msgarray[i].svr_addr 
		== sm_p->u.iterate_handles_list.addr_array[j])
	    {
		break;
	    }
	}
	assert(j != sm_p->u.iterate_handles_list.server_count);

	sm_p->u.iterate_handles_list.handle_count_array[j] =
	    resp_p->u.mgmt_iterate_handles.handle_count;
	sm_p->u.iterate_handles_list.position_array[j] =
	    resp_p->u.mgmt_iterate_handles.position;
	memcpy(sm_p->u.iterate_handles_list.handle_matrix[j],
	       resp_p->u.mgmt_iterate_handles.handle_array,
	       resp_p->u.mgmt_iterate_handles.handle_count
	       * sizeof(PVFS_handle));
    }
 
    /* if this is the last response, check all of the status values and 
     * return error code if any requests failed 
     */
    if (i == (sm_p->msgarray_count -1))
    {
	for (j=0; j<sm_p->msgarray_count; j++)
	{
	    if (sm_p->msgarray[j].op_status != 0)
	    {
		return(sm_p->msgarray[j].op_status);
	    }
	}
    }
   
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ts=8 sts=4 sw=4 expandtab
 */
