/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/* pvfs2_client_getattr_pcache_sm
 *
 * The purpose of this state machine is to resolve a segment (one
 * component of a path) and a parent handle down to an object handle.
 * This object handle might already be present in a local cache (the
 * ncache) or could be obtained from a remote server.
 *
 * This state machine uses the msgpair structure in the PINT_client_sm
 * structure in order to perform the message passing.  It assumes that
 * this has been previously set up by the state machine above this
 * one.  In particular the following fields of the msgpair structure
 * must be filled in:
 *
 * - req (unencoded lookup request)
 * - fs_id
 * - handle
 * - svr_addr
 * - comp_fn - called to pull attributes out of decoded response and store
 *   them in the appropriate place for the state machine jumping to this one
 *   (e.g. copies object handle out in the remove case)
 *
 * This state machine in turns jumps to the pvfs2_msgpairarray_sm to
 * perform messaging, if necessary.
 *
 * NOTE: the comp_fn can cause a non-zero error_code to be passed back
 * up from the msgpair state machine and through this state machine
 * back to the one that jumped to here.  so be aware!
 *
 * TODO: sometimes we will get new attributes back with the lookup
 * response.  we should add these into the pcache as appropriate.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"

#include "pint-servreq.h"
#include "ncache.h"
#include "PINT-reqproto-encode.h"
#include "pvfs2-internal.h"

enum
{
    LOOKUP_NCACHE_MISS = 1
};

static int lookup_ncache_lookup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static union PINT_state_array_values ST_lookup[];
static union PINT_state_array_values ST_xfer_msgpair[];

struct PINT_state_machine_s pvfs2_client_lookup_ncache_sm = {
	.name = "pvfs2_client_lookup_ncache_sm",
	.state_machine = ST_lookup
};

static union PINT_state_array_values ST_lookup[] = {
	{ .state_name = "lookup" },
	{ .parent_machine = &pvfs2_client_lookup_ncache_sm },
	{ .flag = SM_NONE },
	{ .state_action = lookup_ncache_lookup },
	{ .return_value = LOOKUP_NCACHE_MISS },
	{ .next_state = ST_xfer_msgpair },
	{ .return_value = -1 },
	{ .flag = SM_RETURN }
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
	{ .state_name = "xfer_msgpair" },
	{ .parent_machine = &pvfs2_client_lookup_ncache_sm },
	{ .flag = SM_JUMP },
	{ .nested_machine = &pvfs2_msgpairarray_sm },
	{ .return_value = -1 },
	{ .flag = SM_RETURN }
};

# 81 "src/client/sysint/lookup-ncache.sm"


static int lookup_ncache_lookup(PINT_client_sm *sm_p,
				job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_object_ref parent_ref, object_ref;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "lookup_ncache state: lookup\n");

    assert(js_p->error_code == 0);

    parent_ref.fs_id = sm_p->msgpair.fs_id;
    parent_ref.handle = sm_p->msgpair.handle;

    assert(parent_ref.handle != PVFS_HANDLE_NULL);
    assert(parent_ref.fs_id != PVFS_FS_ID_NULL);

    ret = PINT_ncache_lookup(
        sm_p->u.lookup.orig_pathname, 0 /* sm_p->u.lookup.follow_link */,
        parent_ref, &object_ref);

    if (ret == 0)
    {
	struct PVFS_server_resp fake_resp;

	/* build a fake response, call the completion function on it */
	fake_resp.op = PVFS_SERV_LOOKUP_PATH;
	fake_resp.status = 0;
	fake_resp.u.lookup_path.handle_array = &object_ref.handle;
	fake_resp.u.lookup_path.attr_array = NULL;
	fake_resp.u.lookup_path.handle_count = 1;
	fake_resp.u.lookup_path.attr_count = 0;

        gossip_debug(
            GOSSIP_NCACHE_DEBUG, "*** ncache hit on %s (%llu|%d)!\n",
            sm_p->msgpair.req.u.lookup_path.path,
            llu(object_ref.handle), object_ref.fs_id);

        sm_p->ncache_hit = 1;
	ret = sm_p->msgpair.comp_fn(sm_p, &fake_resp, 0);
	return 1;
    }

    gossip_debug(GOSSIP_NCACHE_DEBUG, "*** ncache clean miss on %s.\n",
                 sm_p->msgpair.req.u.lookup_path.path);

    js_p->error_code = LOOKUP_NCACHE_MISS;
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
