#include <stdlib.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <string.h>
#include <pvfs2-request.h>
#include <pint-request.h>

int main(int argc, char **argv)
{
	struct PINT_Request *r;
	struct PINT_Request *r_packed;
	int r_size;

	/* build a request */
	PVFS_Request_vector(16, 4, 64, PVFS_DOUBLE, &r);
	PINT_dump_request(r);

	/* pack the request */
	r_size = PINT_REQUEST_PACK_SIZE(r);
	r_packed = (struct PINT_Request *)malloc(r_size);
	PINT_request_commit(r_packed, r);
	PINT_dump_request(r_packed);

	/* now prepare for sending on wire */
	PINT_request_encode(r_packed);

	{
		struct PINT_Request *r2;
		r2 = (struct PINT_Request *)malloc(r_size);
		memcpy(r2, r_packed, r_size); /* simulates sending on wire */

		/* now we'll unencode and see what we have */
		PINT_request_decode(r2);

		/* for now we'll just dump the request */
		PINT_dump_request(r2);

		/* we're done */
		free(r2);
	}

	return 0;
}
