/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */


#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "src/server/request-scheduler/request-scheduler.h"
#include "trove.h"
#include "pint-util.h"
#include "pvfs2-internal.h"
#include "pint-perf-counter.h"

extern struct PINT_perf_counter *PINT_server_pc;

/* prelude state machine:
 * This is a nested state machine that performs initial setup 
 * steps that are common to many server operations.
 * - post the request to the request scheduler
 * - check permissions
 */
static int prelude_req_sched(
    PINT_server_op *s_op, job_status_s *js_p);
static int prelude_perm_check(
    PINT_server_op *s_op, job_status_s *js_p);
static int prelude_getattr_if_needed(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_req_sched[];
static union PINT_state_array_values ST_getattr_if_needed[];
static union PINT_state_array_values ST_perm_check[];

struct PINT_state_machine_s pvfs2_prelude_sm =
{
	ST_req_sched,
	"pvfs2_prelude_sm"
};
static union PINT_state_array_values ST_req_sched[] = {
(union PINT_state_array_values) "req_sched",
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) prelude_req_sched,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_getattr_if_needed,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_getattr_if_needed[] = {
(union PINT_state_array_values) "getattr_if_needed",
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) prelude_getattr_if_needed,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_perm_check
};

static union PINT_state_array_values ST_perm_check[] = {
(union PINT_state_array_values) "perm_check",
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) prelude_perm_check,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

# 64 "src/server/prelude.sm"


/* prelude_req_sched()
 *
 * posts a request scheduler job
 */
static int prelude_req_sched(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;

    gossip_debug(GOSSIP_SERVER_DEBUG,
        "(%p) %s (prelude sm) state: req_sched\n", s_op,
        PINT_map_server_op_to_string(s_op->req->op));

    PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DETAIL_DEBUG, "request\n");

    /* this is the first state for every normal pvfs2 server state
     * machine, so we get to do some housekeeping here.  In
     * particular, bump up the reference count on the bmi address that
     * we are using
     */
    BMI_set_info(s_op->addr, BMI_INC_ADDR_REF, NULL);

    /* this is a bit of a hack; if we are changing server mode we must
     * preserve the old mode value before calling req scheduler
     */
    if ((s_op->op == PVFS_SERV_MGMT_SETPARAM) &&
        (s_op->req->u.mgmt_setparam.param == PVFS_SERV_PARAM_MODE))
    {
        s_op->resp.u.mgmt_setparam.old_value = PINT_req_sched_get_mode();
    }
    
    ret = job_req_sched_post(s_op->req, 0, s_op, 0, js_p,
                             &(s_op->scheduled_id), server_job_context);

    PINT_perf_count(PINT_server_pc, PINT_PERF_REQSCHED, 1, PINT_PERF_ADD);
    return ret;
}

/* prelude_getattr_if_needed()
 *
 * reads basic attributes of target object, if there is a particular
 * target object for the operation
 */
static int prelude_getattr_if_needed(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL, readonly_flag = 0;
    PVFS_handle target_handle = PVFS_HANDLE_NULL;
    PVFS_fs_id target_fs_id = PVFS_FS_ID_NULL;
    job_id_t tmp_id;

    PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DETAIL_DEBUG, "start\n");

    gossip_debug(GOSSIP_SERVER_DEBUG,
                 "(%p) %s (prelude sm) state: getattr_if_needed\n", s_op,
                 PINT_map_server_op_to_string(s_op->req->op));

    /* first, run a request scheduler utility function that tells us
     * what handle this request will operate on
     */
    ret = PINT_req_sched_target_handle(
        s_op->req, 0, &target_handle, &target_fs_id, &readonly_flag);

    if (ret < 0)
    {
        gossip_debug(GOSSIP_SERVER_DEBUG, "PINT_req_sched_target_handle "
                     "returned %d ret, skipping getattr on handle %llu\n",
                     ret, llu(target_handle));

        js_p->error_code = ret;
        return 1;
    }

    /* if the handle is 0, that indicates that the request does not
     * operate on a specific handle, so there is nothing we can do
     * here
     */
    if (target_handle == PVFS_HANDLE_NULL)
    {
        js_p->error_code = 0;
        return 1;
    }

    /* all other operations fall to this point and read basic
     * attribute information
     */
    memset(&(s_op->ds_attr), 0, sizeof(PVFS_ds_attributes));

    gossip_debug(GOSSIP_SERVER_DEBUG, "About to retrieve attributes "
                 "for handle %llu\n", llu(target_handle));

    ret = job_trove_dspace_getattr(
        target_fs_id, target_handle, s_op, &(s_op->ds_attr),
        0, js_p, &tmp_id, server_job_context);

    return ret;
}

/* prelude_perm_check()
 *
 * this really just marks the spot where we would want to do
 * permission checking, it will be replaced by a couple of states that
 * actually perform this task later
 */
static int prelude_perm_check(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *obj_attr = NULL;
    PVFS_ds_attributes *ds_attr = NULL;

    /* moved gossip server debug output to end of state, so we can report
     * resulting status value.
     */

    /*
      first we translate the dspace attributes into a more convenient
      server use-able format.  i.e. a PVFS_object_attr
    */
    ds_attr = &s_op->ds_attr;
    obj_attr = &s_op->attr;
    PVFS_ds_attr_to_object_attr(ds_attr, obj_attr);
    s_op->attr.mask = PVFS_ATTR_COMMON_ALL;

    /* the next thing we need to do is interpret the error code from
     * reading the attributes.  Normally it is an error if that step
     * failed, but we have to look for the special case in which we
     * set attributes on a file that did not have attributes
     * previously.
     */
    if (PINT_server_req_table[s_op->req->op].attrib_flags ==
        PINT_SERVER_ATTRIBS_NOT_REQUIRED)
    {
        js_p->error_code = 0;
    }

    /* anything else we treat as a real error */
    if (js_p->error_code)
    {
        js_p->error_code = -PVFS_ERROR_CODE(-js_p->error_code);
        return(1);
    }

    gossip_debug(
        GOSSIP_PERMISSIONS_DEBUG, "PVFS operation \"%s\" got "
        "attr mask %d\n\t(attr_uid_valid? %s, attr_owner = "
        "%d, credentials_uid = %d)\n\t(attr_gid_valid? %s, attr_group = "
        "%d, credentials.gid = %d)\n",
        PINT_map_server_op_to_string(s_op->req->op), s_op->attr.mask,
        ((s_op->attr.mask & PVFS_ATTR_COMMON_UID) ? "yes" : "no"),
        s_op->attr.owner, s_op->req->credentials.uid,
        ((s_op->attr.mask & PVFS_ATTR_COMMON_GID) ? "yes" : "no"),
        s_op->attr.group, s_op->req->credentials.gid);
    
    switch(PINT_server_req_table[s_op->req->op].perm)
    {
        case PINT_SERVER_CHECK_WRITE:
            js_p->error_code = PINT_check_mode(
                &(s_op->attr), s_op->req->credentials.uid,
                s_op->req->credentials.gid, PINT_ACCESS_WRITABLE);
            break;
        case PINT_SERVER_CHECK_READ:
            js_p->error_code = PINT_check_mode(
                &(s_op->attr), s_op->req->credentials.uid,
                s_op->req->credentials.gid, PINT_ACCESS_READABLE);
            break;
        case PINT_SERVER_CHECK_CRDIRENT:
            /* must also check executable after writable */
            js_p->error_code = PINT_check_mode(
                &(s_op->attr), s_op->req->credentials.uid,
                s_op->req->credentials.gid, PINT_ACCESS_WRITABLE);
            if(js_p->error_code == 0)
            {
                js_p->error_code = PINT_check_mode(
                    &(s_op->attr), s_op->req->credentials.uid,
                    s_op->req->credentials.gid, PINT_ACCESS_EXECUTABLE);
            }
            break;
        case PINT_SERVER_CHECK_ATTR:
            /* a datafile will have a 0 mask value here */
            if (s_op->attr.mask == 0)
            {
                js_p->error_code = 0;
            }
            /* for now we'll assume extended attribs are treated
             * the same as regular attribs as far as permissions
             */
	    else if (s_op->req->op == PVFS_SERV_GETATTR ||
                    s_op->req->op == PVFS_SERV_GETEATTR ||
                    s_op->req->op == PVFS_SERV_LISTEATTR)
	    {
		/* getting or listing attributes is always ok -- permission
		 * is checked on the parent directory at read time
		 */
		js_p->error_code = 0;
	    }
            else /* setattr, seteattr, seteattr_list */
            {
                /*
                  NOTE: on other file systems, setattr doesn't
                  seem to require read permissions by the user, group
                  OR other, so long as the user or group matches (or
                  is root)
                */
                if (((s_op->attr.mask & PVFS_ATTR_COMMON_UID) &&
                     ((s_op->attr.owner == 0) ||
                      (s_op->attr.owner == s_op->req->credentials.uid))) ||
                    (((s_op->attr.mask & PVFS_ATTR_COMMON_GID) &&
                      ((s_op->attr.group == 0) ||
                       (s_op->attr.group == s_op->req->credentials.gid)))) ||
                    (s_op->req->credentials.uid == 0))
                {
                    js_p->error_code = 0;
                }
                else
                {
                    js_p->error_code = -PVFS_EPERM;
                }
            }
            break;
        case PINT_SERVER_CHECK_NONE:
            js_p->error_code = 0;
            break;
        case PINT_SERVER_CHECK_INVALID:
            js_p->error_code = -PVFS_EINVAL;
            break;
    }

    gossip_debug(
        GOSSIP_PERMISSIONS_DEBUG, "Final permission check for \"%s\" set "
        "error code to %d\n", PINT_map_server_op_to_string(s_op->req->op),
        js_p->error_code);

    gossip_debug(GOSSIP_SERVER_DEBUG, 
        "(%p) %s (prelude sm) state: perm_check (status = %d)\n",
	s_op,
        PINT_map_server_op_to_string(s_op->req->op),
	js_p->error_code);
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
