/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/* pvfs2_list_eattr_sm
 *
 * This state machine handles incoming server listxattr operations.  These
 * are the operations sent by PVFS_sys_listeattr() among others.
 *
 * The pvfs2_prelude_sm is responsible for reading the actual metadata
 * to begin with, because it does this as part of the permission checking
 * process.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-types.h"
#include "pvfs2-types-debug.h"
#include "pvfs2-util.h"
#include "pint-util.h"

static inline char *get_object_type(int objtype)
{
    static char *obj_types[] =
    {
         "NONE", "METAFILE", "DATAFILE",
         "DIRECTORY", "SYMLINK", "DIRDATA", "UNKNOWN"
    };
    switch(objtype)
    {
    case PVFS_TYPE_NONE:
         return obj_types[0];
    case PVFS_TYPE_METAFILE:
         return obj_types[1];
    case PVFS_TYPE_DATAFILE:
         return obj_types[2];
    case PVFS_TYPE_DIRECTORY:
         return obj_types[3];
    case PVFS_TYPE_SYMLINK:
         return obj_types[4];
    case PVFS_TYPE_DIRDATA:
         return obj_types[5];
    }
    return obj_types[6];
}

static int listeattr_setup_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int listeattr_list_eattrib(
    PINT_server_op *s_op, job_status_s *js_p);
static int listeattr_check_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int listeattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_list_eattrib[];
static union PINT_state_array_values ST_check_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_list_eattr_sm =
{
	ST_prelude,
	"pvfs2_list_eattr_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) "prelude",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) "setup_resp",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) listeattr_setup_resp,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_list_eattrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_list_eattrib[] = {
(union PINT_state_array_values) "list_eattrib",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) listeattr_list_eattrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_check_resp
};

static union PINT_state_array_values ST_check_resp[] = {
(union PINT_state_array_values) "check_resp",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) listeattr_check_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) "final_response",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_list_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) listeattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 113 "src/server/list-eattr.sm"


/*
 * listeattr_setup_resp()
 * Set up the response - allocate needed resources
 */
static int listeattr_setup_resp(PINT_server_op *s_op, job_status_s *js_p)
{
    int i, tsz;
    PINT_STATE_DEBUG("setup_resp");
    gossip_debug(GOSSIP_LISTEATTR_DEBUG, "listeattr requesting %d keys\n",
            s_op->req->u.listeattr.nkey);

    js_p->error_code = 0;

    s_op->resp.u.listeattr.key =
        malloc(s_op->req->u.listeattr.nkey * sizeof(PVFS_ds_keyval));
    if (!s_op->resp.u.listeattr.key)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }

    s_op->resp.u.listeattr.nkey = s_op->req->u.listeattr.nkey;
    for (i = 0, tsz = 0; i < s_op->req->u.listeattr.nkey; i++)
        tsz += s_op->req->u.listeattr.keysz[i];
    s_op->u.eattr.buffer = malloc(tsz);
    if (!s_op->u.eattr.buffer)
    {
        s_op->resp.u.listeattr.nkey = 0;
        free (s_op->resp.u.listeattr.key);
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }
    gossip_debug(GOSSIP_LISTEATTR_DEBUG,"listeattr buffer size %d bytes\n",
            tsz);
    for (i = 0, tsz = 0; i < s_op->req->u.listeattr.nkey; i++)
    {
        s_op->resp.u.listeattr.key[i].buffer_sz =
            s_op->req->u.listeattr.keysz[i];
        s_op->resp.u.listeattr.key[i].buffer =
            (char *)s_op->u.eattr.buffer + tsz;
        tsz += s_op->req->u.listeattr.keysz[i];
    }
    return 1;
}

/*
 * listeattr_list_eattrib()
 * Here is where the eattrib get listed.
 */
static int listeattr_list_eattrib(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    PINT_STATE_DEBUG("list_eattrib");

    js_p->error_code = 0;

    ret = job_trove_keyval_iterate_keys(
        s_op->req->u.listeattr.fs_id,
        s_op->req->u.listeattr.handle,
        s_op->req->u.listeattr.token,
        s_op->resp.u.listeattr.key,
        s_op->req->u.listeattr.nkey,
        0,
        NULL,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}

#if 0
static void print_string(char *buffer, size_t length)
{
    int i;
    if (length == 0 || buffer == NULL)
    {
        return;
    }
    for (i = 0; i < length; i++)
    {
        printf("%c", buffer[i]);
    }
    printf("\n");
    return;
}
#endif

/* listeattr_check_resp()
 *
 * checks what attributes we found, handles errors, filters for appropriate
 * extended attribute name spaces
 *
 * NOTE: all attributes should fall into one of the name spaces defined in 
 * the PINT_eattr_namespaces array.  If we find a key that does not, then we
 * will translate it so that it appears in the "system.pvfs2." name
 * space on the client side.
 */
static int listeattr_check_resp(PINT_server_op *s_op, job_status_s *js_p)
{
    int num_found = 0;
    int i = 0;
    char* tmp_buffer = NULL;
    char translate_prefix[] = "system.pvfs2.";
    int translate_prefix_len = strlen("system.pvfs2.");
    int ret = 0;

    /* Nothing was requested? then fill token to hold the max available keys */
    if (s_op->resp.u.listeattr.nkey == 0)
    {
        s_op->resp.u.listeattr.token = js_p->count;
        js_p->error_code = 0;
        return 1;
    }

    /* how many entries did we find that we can process? */
    num_found = js_p->count;
    if(num_found > s_op->resp.u.listeattr.nkey)
    {
        num_found = s_op->resp.u.listeattr.nkey;
    }

    s_op->resp.u.listeattr.token = js_p->position;
    s_op->resp.u.listeattr.nkey = num_found;

    if(num_found == 0)
    {
        /* there aren't any extended attr's; go ahead and return */
        js_p->error_code = 0;
        return(1);
    }
  
    tmp_buffer = (char*)malloc(PVFS_REQ_LIMIT_KEY_LEN);
    if(!tmp_buffer)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return(1);
    }

    /* iterate through the keys that we found */
    for(i=0; i<num_found; i++)
    {
        /* check to see if it is prefixed into a supported name space */
        if(!PINT_eattr_is_prefixed(s_op->resp.u.listeattr.key[i].buffer))
        {
            /* we need to tack on a "system.pvfs2." prefix */

            /* find out if the key size requested is large enough */
            if((translate_prefix_len + s_op->resp.u.listeattr.key[i].read_sz) >
                s_op->req->u.listeattr.keysz[i])
            {
                /* NOTE: trying to mimic the semantics of
                 * trove_keyval_iterate_keys(): it will also report an
                 * overall error if one of the key buffers is to small,
                 * though the choice of error code may be different.
                 */
                free(tmp_buffer);
                js_p->error_code = -PVFS_EMSGSIZE;
                return(1);
            }

            /* add a prefix onto the key and adjust sizes accordingly */
            /* NOTE: this will have to change if we ever permit non-string
             * keys (which would break using them for xattrs anyway)
             */
            ret = sprintf(tmp_buffer,
                "%s%s", translate_prefix,
                (char*)s_op->resp.u.listeattr.key[i].buffer);
            memcpy(s_op->resp.u.listeattr.key[i].buffer, tmp_buffer,
                (ret+1));
            s_op->resp.u.listeattr.key[i].read_sz += translate_prefix_len;
        }

        s_op->resp.u.listeattr.key[i].buffer_sz =
            s_op->resp.u.listeattr.key[i].read_sz;
    }    

    free(tmp_buffer);
    js_p->error_code = 0;
    return(1);
}

/* listeattr_cleanup()
 * free resources alloc'd by state machine
 */
static int listeattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("listeattr_cleanup");
    if (s_op->resp.u.listeattr.key)
        free(s_op->resp.u.listeattr.key);
    if (s_op->u.eattr.buffer)
        free(s_op->u.eattr.buffer);
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

