/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 *
 * Changes by Acxiom Corporation to add dirent_count field to attributes
 * Copyright  Acxiom Corporation, 2005.
 */

/* pvfs2_get_attr_sm
 *
 * This state machine handles incoming server getattr operations.  These
 * are the operations sent by PVFS_sys_getattr() among others.
 *
 * The pvfs2_prelude_sm is responsible for reading the actual metadata
 * to begin with, because it does this as part of the permission checking
 * process.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-types.h"
#include "pvfs2-types-debug.h"
#include "pvfs2-util.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

enum
{
    STATE_METAFILE = 7,
    STATE_SYMLINK  = 9,
    STATE_DIR      = 10
};

static inline char *get_object_type(int objtype)
{
    static char *obj_types[] =
    {
        "NONE", "METAFILE", "DATAFILE",
        "DIRECTORY", "SYMLINK", "DIRDATA", "UNKNOWN"
    };

    switch(objtype)
    {
        case PVFS_TYPE_NONE:
            return obj_types[0];
        case PVFS_TYPE_METAFILE:
            return obj_types[1];
        case PVFS_TYPE_DATAFILE:
            return obj_types[2];
        case PVFS_TYPE_DIRECTORY:
            return obj_types[3];
        case PVFS_TYPE_SYMLINK:
            return obj_types[4];
        case PVFS_TYPE_DIRDATA:
            return obj_types[5];
    }
    return obj_types[6];
}

static int getattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_verify_attribs(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_read_symlink_target(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_get_dirent_count(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_interpret_dirent_count(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_read_metafile_datafile_handles_if_required(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_read_metafile_distribution_if_required(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_setup_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int getattr_setup_op(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_verify_attribs[];
static union PINT_state_array_values ST_read_symlink_target[];
static union PINT_state_array_values ST_read_metafile_datafile_handles_if_required[];
static union PINT_state_array_values ST_read_metafile_distribution_if_required[];
static union PINT_state_array_values ST_get_dirent_count[];
static union PINT_state_array_values ST_interpret_dirent_count[];
static union PINT_state_array_values ST_setup_resp[];

struct PINT_state_machine_s pvfs2_get_attr_work_sm =
{
	ST_verify_attribs,
	"pvfs2_get_attr_work_sm"
};
static union PINT_state_array_values ST_verify_attribs[] = {
(union PINT_state_array_values) "verify_attribs",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_verify_attribs,
(union PINT_state_array_values) STATE_SYMLINK,
(union PINT_state_array_values) ST_read_symlink_target,
(union PINT_state_array_values) STATE_METAFILE,
(union PINT_state_array_values) ST_read_metafile_datafile_handles_if_required,
(union PINT_state_array_values) STATE_DIR,
(union PINT_state_array_values) ST_get_dirent_count,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_symlink_target[] = {
(union PINT_state_array_values) "read_symlink_target",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_read_symlink_target,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_metafile_datafile_handles_if_required[] = {
(union PINT_state_array_values) "read_metafile_datafile_handles_if_required",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_read_metafile_datafile_handles_if_required,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_metafile_distribution_if_required,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_metafile_distribution_if_required[] = {
(union PINT_state_array_values) "read_metafile_distribution_if_required",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_read_metafile_distribution_if_required,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_get_dirent_count[] = {
(union PINT_state_array_values) "get_dirent_count",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_get_dirent_count,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_interpret_dirent_count,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_interpret_dirent_count[] = {
(union PINT_state_array_values) "interpret_dirent_count",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_interpret_dirent_count,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) "setup_resp",
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_setup_op[];
static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_get_attr_sm =
{
	ST_prelude,
	"pvfs2_get_attr_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) "prelude",
(union PINT_state_array_values) &pvfs2_get_attr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setup_op,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_setup_op[] = {
(union PINT_state_array_values) "setup_op",
(union PINT_state_array_values) &pvfs2_get_attr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_setup_op,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_do_work
};

static union PINT_state_array_values ST_do_work[] = {
(union PINT_state_array_values) "do_work",
(union PINT_state_array_values) &pvfs2_get_attr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_get_attr_work_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) "final_response",
(union PINT_state_array_values) &pvfs2_get_attr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_get_attr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) getattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 184 "src/server/get-attr.sm"


/* getattr_verify_attribs()
 *
 * We initialize the attribute mask that will be returned in this
 * function.  This mask can be augmented in some of the other states.
 */
static int getattr_verify_attribs(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *resp_attr = NULL;

    PINT_STATE_DEBUG("verify_attribs");

    js_p->error_code = 0;

    /*
      explicitly copy basic attributes structure (read in from the
      prelude.sm for the matching dspace) into response to be sent
      back to the client.  this is mostly for readability here to be
      sure we know which fields are valid in the response at this
      point.
    */
    resp_attr = &s_op->resp.u.getattr.attr;
    memset(resp_attr, 0, sizeof(PVFS_object_attr));

    resp_attr->owner = s_op->attr.owner;
    resp_attr->group = s_op->attr.group;
    resp_attr->perms = s_op->attr.perms;
    resp_attr->atime = s_op->attr.atime;

    resp_attr->mtime = PVFS_util_mkversion_time(s_op->attr.mtime);
    if (resp_attr->mtime == 0)
    {
        /*
          this is a compatibility hack to allow existing storage
          spaces to be automagically converted to this versioned time
          on-disk format slowly over time and doing the right thing in
          the meantime
        */
        resp_attr->mtime = s_op->attr.mtime;

        gossip_debug(GOSSIP_GETATTR_DEBUG, " No version found!  Using "
                     "mtime %llu\n", llu(resp_attr->mtime));
    }
    else
    {
        gossip_debug(
            GOSSIP_GETATTR_DEBUG, " VERSION is %llu, mtime is %llu\n",
            llu(s_op->attr.mtime), llu(resp_attr->mtime));
    }

    resp_attr->ctime = s_op->attr.ctime;
    resp_attr->mask = s_op->attr.mask;
    resp_attr->objtype = s_op->attr.objtype;
    resp_attr->u.meta.dfile_count = s_op->attr.u.meta.dfile_count;
    resp_attr->u.meta.dist_size = s_op->attr.u.meta.dist_size;

#if 0
    gossip_debug(
        GOSSIP_GETATTR_DEBUG,
        "+  _DSPACE_ retrieved attrs: [owner = %d, group = %d\n\t"
        "perms = %o, type = %d, atime = %llu, mtime = %llu\n\t"
        "ctime = %llu, dfile_count = %d, dist_size = %d]\n",
        resp_attr->owner, resp_attr->group, resp_attr->perms,
        resp_attr->objtype, llu(resp_attr->atime),
        llu(resp_attr->mtime), llu(resp_attr->ctime),
        (int)resp_attr->u.meta.dfile_count,
        (int)resp_attr->u.meta.dist_size);
#endif

    /*
      weed out the attr mask of the response based on what the client
      request asked for.  also, check if we need to retrieve more
      information before returning the response to the client (by
      guiding the state machine to get it).

      we can safely do this now that we have the type of the object
      (read in from the dspace, not stored in the resp_attr), and we
      have the original client request attr mask
      (s_op->u.getattr.attrmask).
    */
    if (resp_attr->objtype == PVFS_TYPE_METAFILE)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "type: metafile\n");
        gossip_debug(GOSSIP_GETATTR_DEBUG,
                     "  Req handle %llu refers to a metafile\n",
                     llu(s_op->u.getattr.handle));

        if (s_op->u.getattr.attrmask & PVFS_ATTR_META_DFILES)
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         " dspace has dfile_count of %d\n",
                         resp_attr->u.meta.dfile_count);
            resp_attr->mask |= PVFS_ATTR_META_DFILES;
        }
        else
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG, " client doesn't want "
                         "dfile info, clearing response attr mask\n");
            resp_attr->mask &= ~PVFS_ATTR_META_DFILES;
        }

        if (s_op->u.getattr.attrmask & PVFS_ATTR_META_DIST)
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         " dspace has dist size of %d\n",
                         resp_attr->u.meta.dist_size);

            resp_attr->mask |= PVFS_ATTR_META_DIST;
        }
        else
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG, " client doesn't want "
                         "dist info, clearing response attr mask\n");

            resp_attr->mask &= ~PVFS_ATTR_META_DIST;
        }

        if ((resp_attr->mask & PVFS_ATTR_META_DFILES) ||
            (resp_attr->mask & PVFS_ATTR_META_DIST))
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG, " * client wants extra "
                         "meta info, about to retrieve it now\n");
            js_p->error_code = STATE_METAFILE;
        }
        else
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG, " * client doesn't want "
                         "extra meta info, preparing response now\n");
        }
    }
    else if (resp_attr->objtype == PVFS_TYPE_DATAFILE)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "type: datafile\n");
        /*
          note: the prelude already retrieved the size for us, so
          there's no special action that needs to be taken if we have
          a datafile here (other than adjusting our mask to include
          the data information and copying the retrieved size from the
          ds_attribute the prelude used)
        */
        resp_attr->u.data.size = s_op->ds_attr.b_size;
        resp_attr->mask |= PVFS_ATTR_DATA_ALL;

	gossip_debug(GOSSIP_GETATTR_DEBUG, "  handle %llu refers to "
                     "a datafile (size = %lld).\n",
                     llu(s_op->u.getattr.handle),
                     lld(resp_attr->u.data.size));
    }
    else if (resp_attr->objtype == PVFS_TYPE_DIRECTORY)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "type: directory\n");
        if (s_op->u.getattr.attrmask & PVFS_ATTR_DIR_DIRENT_COUNT)
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         " getattr: dirent_count needed.\n");
            assert(resp_attr->mask & PVFS_ATTR_COMMON_ALL);
            resp_attr->mask |= PVFS_ATTR_DIR_DIRENT_COUNT;
            js_p->error_code = STATE_DIR;
        }
        else
        {
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         " getattr: dirent_count not needed.\n");
            js_p->error_code = 0;
            assert(resp_attr->mask & PVFS_ATTR_COMMON_ALL);
        }
    }
    else if (resp_attr->objtype == PVFS_TYPE_DIRDATA)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "type: dirdata\n");
	gossip_debug(
            GOSSIP_GETATTR_DEBUG, "  handle %llu refers to "
            "a dirdata object. doing nothing special\n",
            llu(s_op->u.getattr.handle));
        assert(resp_attr->mask & PVFS_ATTR_COMMON_ALL);
    }
    else if (resp_attr->objtype == PVFS_TYPE_SYMLINK)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "type: symlink\n");
	gossip_debug(
            GOSSIP_GETATTR_DEBUG, "  handle %llu refers to a symlink.\n",
            llu(s_op->u.getattr.handle));

        /*
          we'll definitely have to fetch the symlink target in this
          case, as the prelude will never retrieve it for us
        */
        js_p->error_code = STATE_SYMLINK;
    }
    else
    {
	gossip_debug(
            GOSSIP_GETATTR_DEBUG, "  handle %llu refers to something "
            "unknown -- assuming datafile!\n",
            llu(s_op->u.getattr.handle));

        resp_attr->objtype = PVFS_TYPE_DATAFILE;
        resp_attr->u.data.size = s_op->ds_attr.b_size;
        resp_attr->mask |= (PVFS_ATTR_COMMON_TYPE | PVFS_ATTR_DATA_ALL);

	gossip_debug(GOSSIP_GETATTR_DEBUG, "  handle %llu now refers to "
                     "a datafile (size = %lld).\n",
                     llu(s_op->u.getattr.handle),
                     lld(resp_attr->u.data.size));
    }
    return 1;
}

static int getattr_read_symlink_target(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret;
    job_id_t i;

    PINT_STATE_DEBUG("read_symlink_target");

    /* if we don't need to fill in the symlink target, skip it */
    if (!(s_op->u.getattr.attrmask & PVFS_ATTR_SYMLNK_TARGET))
    {
        gossip_debug(GOSSIP_GETATTR_DEBUG, "skipping symlink target read\n");
        js_p->error_code = 0;
        return 1;
    }

    s_op->key.buffer    = Trove_Common_Keys[SYMLINK_TARGET_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[SYMLINK_TARGET_KEY].size;

    /*
      optimistically add mask value to indicate the symlink target is
      filled (error_code is checked in next state)
    */
    s_op->resp.u.getattr.attr.mask |= PVFS_ATTR_SYMLNK_TARGET;

    s_op->resp.u.getattr.attr.u.sym.target_path_len = PVFS_NAME_MAX;
    s_op->resp.u.getattr.attr.u.sym.target_path =
	malloc(s_op->resp.u.getattr.attr.u.sym.target_path_len);
    if (!s_op->resp.u.getattr.attr.u.sym.target_path)
    {
	js_p->error_code = -PVFS_ENOMEM;
	return(1);
    }

    s_op->val.buffer = s_op->resp.u.getattr.attr.u.sym.target_path;
    s_op->val.buffer_sz = s_op->resp.u.getattr.attr.u.sym.target_path_len;

    ret = job_trove_keyval_read(
        s_op->u.getattr.fs_id, s_op->u.getattr.handle,
        &(s_op->key), &(s_op->val), 
        0, NULL, s_op, 0, js_p,
        &i, server_job_context);

    return ret;
}


static int getattr_read_metafile_datafile_handles_if_required(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    int dfile_count = 0;
    job_id_t i;

    PINT_STATE_DEBUG("read_metafile_datafile_handles_if_required");

    assert(s_op->attr.objtype == PVFS_TYPE_METAFILE);

    js_p->error_code = 0;

    /* if we don't need to fill in the dfiles, skip them */
    if (!(s_op->u.getattr.attrmask & PVFS_ATTR_META_DFILES))
    {
        gossip_debug(GOSSIP_GETATTR_DEBUG, "skipping data handle read\n");
        return 1;
    }

    dfile_count = s_op->resp.u.getattr.attr.u.meta.dfile_count;

    gossip_debug(GOSSIP_GETATTR_DEBUG,
                 " request has dfile_count of %d | dspace has %d\n",
                 s_op->resp.u.getattr.attr.u.meta.dfile_count,
                 s_op->resp.u.getattr.attr.u.meta.dfile_count);

    /* verify that the retrieved dfile count is sane */
    if (!PVFS_REQ_LIMIT_DFILE_COUNT_IS_VALID(dfile_count))
    {
        gossip_err("The requested dfile count of %d is invalid; "
                   "aborting operation.\n", dfile_count);
	gossip_err(
            "+ attrs read from dspace: (owner = %d, group = %d, "
            "perms = %o, type = %d\n   atime = %lld, mtime = %lld, "
            "ctime = %lld |\n   dfile_count = %d | dist_size = %d)\n",
            s_op->resp.u.getattr.attr.owner,
            s_op->resp.u.getattr.attr.group, 
            s_op->resp.u.getattr.attr.perms,
            s_op->resp.u.getattr.attr.objtype, 
            lld(s_op->resp.u.getattr.attr.atime),
            lld(s_op->resp.u.getattr.attr.mtime), 
            lld(s_op->resp.u.getattr.attr.ctime),
            (int)s_op->resp.u.getattr.attr.u.meta.dfile_count,
            (int)s_op->resp.u.getattr.attr.u.meta.dist_size);

	gossip_err("handle: %llu (%llx), fsid: %d.\n",
	    llu(s_op->u.getattr.handle), llu(s_op->u.getattr.handle),
	    (int)s_op->u.getattr.fs_id);

	js_p->error_code = -PVFS_EOVERFLOW;
	return 1;
    }

    s_op->key.buffer = Trove_Common_Keys[METAFILE_HANDLES_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[METAFILE_HANDLES_KEY].size;

    /* add mask value to indicate the data file array is filled */
    s_op->resp.u.getattr.attr.mask |= PVFS_ATTR_META_DFILES;

    s_op->resp.u.getattr.attr.u.meta.dfile_array =
        malloc(dfile_count * sizeof(PVFS_handle));
    if (!s_op->resp.u.getattr.attr.u.meta.dfile_array)
    {
        gossip_err("Cannot allocate dfile array of count %d\n",
                   dfile_count);
	js_p->error_code = -PVFS_ENOMEM;
	return 1;
    }

    s_op->val.buffer = s_op->resp.u.getattr.attr.u.meta.dfile_array;
    s_op->val.buffer_sz = (dfile_count * sizeof(PVFS_handle));

    gossip_debug(GOSSIP_GETATTR_DEBUG,
		 "  reading %d datafile handles (coll_id = %d, "
                 "handle = %llu, key = %s (%d), val_buf = %p (%d))\n",
		 dfile_count, s_op->u.getattr.fs_id,
		 llu(s_op->u.getattr.handle), (char *)s_op->key.buffer,
		 s_op->key.buffer_sz, s_op->val.buffer,
		 s_op->val.buffer_sz);

    ret = job_trove_keyval_read(
        s_op->u.getattr.fs_id, s_op->u.getattr.handle,
        &s_op->key, &s_op->val, 
        0, NULL, s_op, 0, js_p,
        &i, server_job_context);

    return ret;
}

static int getattr_read_metafile_distribution_if_required(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    PINT_STATE_DEBUG("read_metafile_distribution_if_required");

    assert(s_op->attr.objtype == PVFS_TYPE_METAFILE);

    js_p->error_code = 0;

    /* if we don't need to fill in the distribution, skip it */
    if (!(s_op->u.getattr.attrmask & PVFS_ATTR_META_DIST))
    {
        gossip_debug(GOSSIP_GETATTR_DEBUG, "skipping data handle "
                     "distribution read\n");
        return 1;
    }

    s_op->key.buffer = Trove_Common_Keys[METAFILE_DIST_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[METAFILE_DIST_KEY].size;

    /*
      there *should* be some distribution information.  if not, dump
      which handle is busted and assertion die for now while we're not
      handling this kind of error
    */
    if (s_op->resp.u.getattr.attr.u.meta.dist_size < 1)
    {
        gossip_err("Cannot Read Dist!  Got an invalid dist size for "
                   "handle %llu,%d\n",llu(s_op->u.getattr.handle),
                   s_op->u.getattr.fs_id);
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }
    assert(s_op->resp.u.getattr.attr.u.meta.dist_size > 0);

    /* add mask value to indicate the distribution is filled */
    s_op->resp.u.getattr.attr.mask |= PVFS_ATTR_META_DIST;

    s_op->val.buffer_sz = s_op->resp.u.getattr.attr.u.meta.dist_size; 
    s_op->val.buffer = malloc(s_op->val.buffer_sz);
    if (!s_op->val.buffer)
    {
        gossip_err("Cannot allocate dist of size %d\n",
                   s_op->val.buffer_sz);
	js_p->error_code = -PVFS_ENOMEM;
	return 1;
    }

    ret = job_trove_keyval_read(
        s_op->u.getattr.fs_id, s_op->u.getattr.handle,
        &(s_op->key), &(s_op->val), 
        0, NULL,
        s_op, 0, js_p, &i, server_job_context);

    return ret;
}

static int getattr_setup_resp(PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *resp_attr = &s_op->resp.u.getattr.attr;

    PINT_STATE_DEBUG("setup_resp");

    gossip_debug(
        GOSSIP_GETATTR_DEBUG,
        "- RETURNING retrieved attrs: [owner = %d, group = %d\n\t"
        "perms = %o, type = %d, atime = %llu, mtime = %llu\n\t"
        "ctime = %llu, dfile_count = %d, dist_size = %d]\n",
        resp_attr->owner, resp_attr->group, resp_attr->perms,
        resp_attr->objtype, llu(resp_attr->atime),
        llu(resp_attr->mtime), llu(resp_attr->ctime),
        (int)resp_attr->u.meta.dfile_count,
        (int)resp_attr->u.meta.dist_size);

    if (resp_attr->objtype == PVFS_TYPE_METAFILE)
    {
        if (resp_attr->mask & PVFS_ATTR_META_DFILES)
        {
            if (resp_attr->u.meta.dfile_count)
            {
                assert(resp_attr->u.meta.dfile_array);
            }
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         "  also returning %d datafile handles\n",
                         resp_attr->u.meta.dfile_count);
        }

        if (resp_attr->mask & PVFS_ATTR_META_DIST)
        {
            PINT_dist_decode(&resp_attr->u.meta.dist, s_op->val.buffer);
            free(s_op->val.buffer);

            if(resp_attr->u.meta.dist == 0) {
                gossip_err("Found dist of 0 for handle %llu,%d\n",
                        llu(s_op->u.getattr.handle), s_op->u.getattr.fs_id);
                PVFS_perror("Metafile getattr_setup_resp",js_p->error_code);
                js_p->error_code = -PVFS_EIO;
                return 1;
            }
            
            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         "  also returning dist size of %d\n",
                         resp_attr->u.meta.dist_size);
        }
    }
    else if ((resp_attr->objtype == PVFS_TYPE_DATAFILE) &&
             (resp_attr->mask & PVFS_ATTR_DATA_SIZE))
    {
        gossip_debug(GOSSIP_GETATTR_DEBUG,
                     "  also returning data size of %lld\n",
                     lld(resp_attr->u.data.size));
    }
    else if ((resp_attr->objtype == PVFS_TYPE_SYMLINK) &&
             (resp_attr->mask & PVFS_ATTR_SYMLNK_TARGET))
    {
        if (js_p->error_code == 0)
        {
            assert(resp_attr->u.sym.target_path);
            assert(resp_attr->u.sym.target_path_len);
            /*
              adjust target path len down to actual size ; always
              include the null termination char in the target_path_len
            */
            resp_attr->u.sym.target_path_len =
                (strlen(resp_attr->u.sym.target_path) + 1);

            gossip_debug(GOSSIP_GETATTR_DEBUG,
                         "  also returning link target of %s (len %d)\n",
                         resp_attr->u.sym.target_path,
                         resp_attr->u.sym.target_path_len);
        }
        else
        {
            gossip_err("Failed to retrieve symlink target path for "
                       "handle %llu,%d\n",llu(s_op->u.getattr.handle),
                       s_op->u.getattr.fs_id);
            PVFS_perror("Symlink retrieval failure",js_p->error_code);

            js_p->error_code = -PVFS_EINVAL;
            return 1;
        }
    }

    gossip_debug(GOSSIP_GETATTR_DEBUG,"@ End %s attributes: sending "
                 "status %d (error = %d)\n",
                 get_object_type(resp_attr->objtype),
		 s_op->resp.status, js_p->error_code);

#if 0
    gossip_debug(GOSSIP_GETATTR_DEBUG, "returning attrmask ");
    PINT_attrmask_print(GOSSIP_GETATTR_DEBUG,
                        s_op->resp.u.getattr.attr.mask);
#endif

    return 1;
}

static int getattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("getattr_cleanup");

    PINT_free_object_attr(&s_op->resp.u.getattr.attr);
    return(server_state_machine_complete(s_op));
}

static int getattr_setup_op(
    PINT_server_op *s_op, job_status_s *js_p)
{
    s_op->u.getattr.handle = s_op->req->u.getattr.handle;
    s_op->u.getattr.fs_id = s_op->req->u.getattr.fs_id;
    s_op->u.getattr.attrmask = s_op->req->u.getattr.attrmask;

    js_p->error_code = 0;
    return(1);
}

static int getattr_get_dirent_count(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret;
    job_id_t tmp_id;

    PINT_STATE_DEBUG("get_dirent_count");

    s_op->key.buffer = Trove_Common_Keys[DIRDATA_SIZE_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIRDATA_SIZE_KEY].size;
    s_op->val.buffer = &s_op->u.getattr.dirent_count;
    s_op->val.buffer_sz = sizeof(PVFS_size);

    ret = job_trove_keyval_read(
        s_op->u.getattr.fs_id,
        s_op->u.getattr.handle,
        &s_op->key,
        &s_op->val,
        0,
        NULL,
        s_op,
        0,
        js_p,
        &tmp_id,
        server_job_context);

    return ret;
}

static int getattr_interpret_dirent_count(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("interpret_dirent_count");

    s_op->resp.u.getattr.attr.u.dir.dirent_count =
        s_op->u.getattr.dirent_count;

    gossip_debug(GOSSIP_GETATTR_DEBUG, "getattr: dirent_count: %lld\n",
        lld(s_op->resp.u.getattr.attr.u.dir.dirent_count));

    js_p->error_code = 0;
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

