/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>

#include "pvfs2-server.h"
#include "pint-event.h"

static int event_mon_cleanup(PINT_server_op *s_op, job_status_s* js_p);
static int event_mon_do_work(PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_event_mon_sm =
{
	ST_prelude,
	"pvfs2_event_mon_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) "prelude",
(union PINT_state_array_values) &pvfs2_event_mon_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_do_work
};

static union PINT_state_array_values ST_do_work[] = {
(union PINT_state_array_values) "do_work",
(union PINT_state_array_values) &pvfs2_event_mon_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) event_mon_do_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) "final_response",
(union PINT_state_array_values) &pvfs2_event_mon_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_event_mon_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) event_mon_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 49 "src/server/event-mon.sm"


/* event_mon_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int event_mon_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");

    if(s_op->resp.u.mgmt_event_mon.event_array)
	free(s_op->resp.u.mgmt_event_mon.event_array);

    return(server_state_machine_complete(s_op));
}

/* event_mon_do_work()
 *
 * gathers statistics and builds response
 */
static int event_mon_do_work(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("do_work");

    /* allocate memory to hold events */
    s_op->resp.u.mgmt_event_mon.event_array
	= (struct PVFS_mgmt_event*)malloc(s_op->req->u.mgmt_event_mon.event_count
	*sizeof(struct PVFS_mgmt_event));
    if(!s_op->resp.u.mgmt_event_mon.event_array)
    {
	js_p->error_code = -PVFS_ENOMEM;
	return(1);
    }

    s_op->resp.u.mgmt_event_mon.event_count = 
	s_op->req->u.mgmt_event_mon.event_count;

    /* get events */
    PINT_event_retrieve(s_op->resp.u.mgmt_event_mon.event_array,
	s_op->req->u.mgmt_event_mon.event_count);

    js_p->error_code = 0;
    return(1);
}



/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

