/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-internal.h"

static inline char *get_object_type(int objtype)
{
    static char *obj_types[] =
    {
         "NONE", "METAFILE", "DATAFILE",
         "DIRECTORY", "SYMLINK", "DIRDATA", "UNKNOWN"
    };
    switch(objtype)
    {
    case PVFS_TYPE_NONE:
         return obj_types[0];
    case PVFS_TYPE_METAFILE:
         return obj_types[1];
    case PVFS_TYPE_DATAFILE:
         return obj_types[2];
    case PVFS_TYPE_DIRECTORY:
         return obj_types[3];
    case PVFS_TYPE_SYMLINK:
         return obj_types[4];
    case PVFS_TYPE_DIRDATA:
         return obj_types[5];
    }
    return obj_types[6];
}

static int deleattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int deleattr_delobj_eattribs(
    PINT_server_op *s_op, job_status_s *js_p);
static int deleattr_verify_eattribs(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_cleanup[];
static union PINT_state_array_values ST_verify_eattribs[];
static union PINT_state_array_values ST_delobj_eattrib[];
static union PINT_state_array_values ST_final_response[];

struct PINT_state_machine_s pvfs2_del_eattr_sm =
{
	ST_prelude,
	"pvfs2_del_eattr_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) "prelude",
(union PINT_state_array_values) &pvfs2_del_eattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_eattribs,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_verify_eattribs[] = {
(union PINT_state_array_values) "verify_eattribs",
(union PINT_state_array_values) &pvfs2_del_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) deleattr_verify_eattribs,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_delobj_eattrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_delobj_eattrib[] = {
(union PINT_state_array_values) "delobj_eattrib",
(union PINT_state_array_values) &pvfs2_del_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) deleattr_delobj_eattribs,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) "final_response",
(union PINT_state_array_values) &pvfs2_del_eattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_del_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) deleattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 91 "src/server/del-eattr.sm"


/*
 * This routine really just does debugging - can print out info about
 * the target of the operation.  There are few things to verify here
 * be we'll try to verify what we can.  We can also disallow setting
 * extended attributes on certain object types if we want.  We might
 * want to prevent access to standard metadata keys.
 */
static int deleattr_verify_eattribs(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *a_p = NULL;

    PINT_STATE_DEBUG("verify_eattribs");

    a_p = &s_op->attr;

    js_p->error_code = 0;

    gossip_debug(GOSSIP_DELEATTR_DEBUG,
                 "  ext attr delete from handle %llu refers to a %s\n\t"
                 "[owner = %d, group = %d, perms = %o, type = %d]\n",
                 llu(s_op->req->u.deleattr.handle),
                 get_object_type(a_p->objtype),
                 a_p->owner, a_p->group, a_p->perms, a_p->objtype);

    switch (a_p->objtype)
    {
    case PVFS_TYPE_METAFILE :
        if (!strncmp(s_op->req->u.deleattr.key.buffer,
                    Trove_Common_Keys[METAFILE_HANDLES_KEY].key,
                    s_op->req->u.deleattr.key.buffer_sz) ||
            !strncmp(s_op->req->u.deleattr.key.buffer,
                    Trove_Common_Keys[METAFILE_DIST_KEY].key,
                    s_op->req->u.deleattr.key.buffer_sz))
        {
            /* can't set these keys with this request */
            js_p->error_code = -PVFS_EINVAL;
            return -PVFS_EINVAL;
        }
    case PVFS_TYPE_SYMLINK :
        if (!strncmp(s_op->req->u.deleattr.key.buffer,
                    Trove_Common_Keys[SYMLINK_TARGET_KEY].key,
                    s_op->req->u.deleattr.key.buffer_sz))
        {
            /* can't set these keys with this request */
            js_p->error_code = -PVFS_EINVAL;
            return -PVFS_EINVAL;
        }
    case PVFS_TYPE_DIRECTORY :
        if (!strncmp(s_op->req->u.deleattr.key.buffer,
                    Trove_Common_Keys[DIR_ENT_KEY].key,
                    s_op->req->u.deleattr.key.buffer_sz))
        {
            /* can't set these keys with this request */
            js_p->error_code = -PVFS_EINVAL;
            return -PVFS_EINVAL;
        }
    default :
        /* no holds barred for other types */
        ;
    }

    /* no one is allowed to set standard attribs with this op */
    if (!strncmp((void *)s_op->req->u.deleattr.key.buffer,
                (void *)&s_op->req->u.deleattr.handle,
                sizeof(s_op->req->u.deleattr.handle)))
    {
        /* can't set these keys with this request */
        js_p->error_code = -PVFS_EINVAL;
        return -PVFS_EINVAL;
    }

    return 1;
}

/*
 * This is where the actual extended attrib gets written.
 * Not much to this, its pretty straight-forward.
 */
static int deleattr_delobj_eattribs(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = 0;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("seteattr_setobj_eattribs");

    /* set up key and value structure for keyval write */
    s_op->key.buffer = s_op->req->u.deleattr.key.buffer;
    s_op->key.buffer_sz = s_op->req->u.deleattr.key.buffer_sz;

    gossip_debug(
        GOSSIP_DELEATTR_DEBUG,
        "  writing %s [%llu,%d,len %d]\n",
        (char *)s_op->key.buffer,
        llu(s_op->req->u.deleattr.handle),
        s_op->req->u.deleattr.fs_id,
        s_op->val.buffer_sz);

    gossip_debug(
        GOSSIP_DELEATTR_DEBUG,
        "keybuf %p keylen %d\n",
        s_op->req->u.deleattr.key.buffer, s_op->req->u.deleattr.key.buffer_sz);

    ret = job_trove_keyval_remove(
        s_op->req->u.deleattr.fs_id,
        s_op->req->u.deleattr.handle,
        &(s_op->key),
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.deleattr.fs_id),
        NULL,
        s_op,
        0,
        js_p,
        &j_id,
        server_job_context);

    return ret;
}

/*
 * Function: delattr_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int deleattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("deleattr_cleanup");

    gossip_debug(
        GOSSIP_DELEATTR_DEBUG,
        "keybuf %p keylen %d\n",
        s_op->req->u.deleattr.key.buffer, s_op->req->u.deleattr.key.buffer_sz);

    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

