DIR := src/common/statecomp

STATECOMP := $(DIR)/statecomp
STATECOMPSRC := \
    $(DIR)/statecomp.c \
    $(DIR)/statecomp-symbol.c \
    $(DIR)/emalloc.c \
    $(DIR)/codegen.c \
    $(DIR)/stringtbl.c \
    $(DIR)/parser.c \
    $(DIR)/scanner.c

STATECOMPGEN := \
    $(DIR)/scanner.c \
    $(DIR)/parser.c \
    $(DIR)/parser.h \

# Trying to build lots of .c files at once confuses the MODCFLAGS calculation.
# Point it to the target to get the real dir name.
statecomp: $(STATECOMP)
$(STATECOMP): $(STATECOMPSRC)
	$(Q) "  CC		$@"
	$(E)$(BUILD_CC) $(LIBCFLAGS) $(CFLAGS) $(call modcflags, $@) $^ -o $@

.SECONDARY: $(STATECOMPGEN)
