/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for setting the attributes of an object
 *  (file or directory).
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

static int setattr_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int setattr_msg_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int setattr_msg_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int setattr_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int setattr_msg_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_setattr_msg_setup_msgpair[];
static union PINT_state_array_values ST_setattr_msg_xfer_msgpair[];
static union PINT_state_array_values ST_setattr_msg_failure[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_setattr_sm =
{
	ST_init,
	"pvfs2_client_setattr_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) "init",
(union PINT_state_array_values) &pvfs2_client_setattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setattr_msg_setup_msgpair
};

static union PINT_state_array_values ST_setattr_msg_setup_msgpair[] = {
(union PINT_state_array_values) "setattr_msg_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_setattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_msg_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setattr_msg_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_setattr_msg_xfer_msgpair[] = {
(union PINT_state_array_values) "setattr_msg_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_setattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setattr_msg_failure
};

static union PINT_state_array_values ST_setattr_msg_failure[] = {
(union PINT_state_array_values) "setattr_msg_failure",
(union PINT_state_array_values) &pvfs2_client_setattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_msg_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_setattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 84 "src/client/sysint/sys-setattr.sm"


/** Initiate modification of attributes of a single object.
 */
PVFS_error PVFS_isys_setattr(
    PVFS_object_ref ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_setattr entered\n");

    if ((ref.handle == PVFS_HANDLE_NULL) ||
        (ref.fs_id == PVFS_FS_ID_NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    /*
     * make sure the caller didn't set invalid mask bits.
     * only common attributes can be set.
     */
    if ((attr.mask & ~PVFS_ATTR_SYS_ALL_SETABLE) != 0)
    {
        gossip_lerr("PVFS_isys_setattr() failure: invalid attributes "
                    "specified\n");
        return ret;
    }

    /* make sure that the permission bits are acceptable */
    if ((attr.perms & ~PVFS_PERM_VALID) != 0)
    {
        gossip_lerr("PVFS_isys_setattr() failure: invalid or unsupported" 
                    "permission bits\n");
        return(-PVFS_EINVAL);
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->object_ref = ref;
    
    ret = PVFS_util_copy_sys_attr(&sm_p->u.setattr.sys_attr, &attr);
    if(ret < 0)
    {
        gossip_lerr("PVFS_isys_setattr() failure: %s\n",
                    strerror(PVFS_get_errno_mapping(-ret)));
        return ret;
    } 

    gossip_debug(GOSSIP_CLIENT_DEBUG, "Doing setattr on handle %llu "
                 "on fs %d\n", llu(ref.handle),
                 ref.fs_id);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_SETATTR, op_id, user_ptr);
}

/**  Modify the attributes of a single object.
 */
PVFS_error PVFS_sys_setattr(
    PVFS_object_ref ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_setattr entered\n");

    ret = PVFS_isys_setattr(ref, attr, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_setattr call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "setattr", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

/****************************************************************/

static int setattr_init(PINT_client_sm *sm_p,
                        job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "setattr state: init\n");

    assert(js_p->error_code == 0);
    return 1;
}

static int setattr_msg_comp_fn(void *v_p,
                               struct PVFS_server_resp *resp_p,
                               int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "setattr_msg_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_SETATTR);
    return resp_p->status;
}

static int setattr_msg_setup_msgpair(PINT_client_sm *sm_p,
                                     job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "setattr state: "
                 "setattr_msg_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," setattr: posting setattr req\n");

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_SETATTR_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->object_ref.handle,
        ((sm_p->u.setattr.sys_attr.mask & PVFS_ATTR_SYS_TYPE) ? 
         sm_p->u.setattr.sys_attr.objtype : PVFS_TYPE_NONE),
        sm_p->u.setattr.sys_attr,
        PVFS_ATTR_COMMON_TYPE);

    /* clients should not be able to mess with dfile and distribution
     * information here.  Those parameters should only be set at create time.
     * Maybe at some point we'll have a utility to adjust those attributes.  At
     * this time if they somehow get changed we'll have garbage on disk */

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
    msg_p->comp_fn = setattr_msg_comp_fn;

    gossip_debug(
            GOSSIP_CLIENT_DEBUG, "setattr attr mask sent to server: 0x%x\n",
            (int)sm_p->u.setattr.sys_attr.mask);

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int setattr_msg_failure(PINT_client_sm *sm_p,
                               job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "setattr state: setattr_msg_failure\n");

    assert(js_p->error_code != 0);
    return 1;
}

static int setattr_cleanup(PINT_client_sm *sm_p,
                           job_status_s *js_p)
{
    PVFS_object_attr attr;
    gossip_debug(GOSSIP_CLIENT_DEBUG, "setattr state: cleanup\n");

    sm_p->error_code = js_p->error_code;

    /* either update acache or invalidate depending on if we were successful
     * or not 
     */
    if(sm_p->error_code == 0)
    {
        PINT_CONVERT_ATTR(&attr, &sm_p->u.setattr.sys_attr,
            PVFS_ATTR_COMMON_ALL);
        PINT_acache_update(sm_p->object_ref, &attr, NULL);
    }
    else
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
