/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>
#include <unistd.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "pvfs2-util.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

/* state function prototypes */
static int get_eattr_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int get_eattr_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int get_eattr_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_get_eattr_sm =
{
	ST_setup_msgpair,
	"pvfs2_client_get_eattr_sm"
};
static union PINT_state_array_values ST_setup_msgpair[] = {
(union PINT_state_array_values) "setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_get_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) get_eattr_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
(union PINT_state_array_values) "xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_get_eattr_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_get_eattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) get_eattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 58 "src/client/sysint/sys-get-eattr.sm"


PVFS_error PVFS_isys_geteattr_list(
        PVFS_object_ref ref,
        PVFS_credentials *credentials,
        int32_t nkey,
        PVFS_ds_keyval *key_array,
        PVFS_sysresp_geteattr *resp_p,
        PVFS_sys_op_id *op_id,
        void *user_ptr)
{
    int ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PINT_isys_geteattr entered\n");

    if ((ref.handle == PVFS_HANDLE_NULL) ||
       (ref.fs_id == PVFS_FS_ID_NULL) || (resp_p == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
	return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.geteattr.nkey = nkey;
    sm_p->u.geteattr.key_array = key_array;
    sm_p->u.geteattr.resp_p = resp_p;
    sm_p->error_code = 0;
    sm_p->object_ref = ref;

    return PINT_client_state_machine_post(
            sm_p, PVFS_SYS_GETEATTR, op_id, user_ptr);
}

PVFS_error PVFS_sys_geteattr_list(
        PVFS_object_ref ref,
        PVFS_credentials *credentials,
        int32_t nkey,
        PVFS_ds_keyval *key_array,
        PVFS_sysresp_geteattr *resp_p)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_geteattr entered\n");

    ret = PVFS_isys_geteattr_list(ref, credentials,
            nkey, key_array, resp_p, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_geteattr call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "geteattr", &error);
        if (ret)
        {
             PVFS_perror_gossip("PVFS_sys_wait call", ret);
             error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

PVFS_error PVFS_sys_geteattr(
        PVFS_object_ref ref,
        PVFS_credentials *credentials,
        PVFS_ds_keyval *key_p,
        PVFS_ds_keyval *val_p)
{
    PVFS_sysresp_geteattr resp_p;
    resp_p.val_array = val_p;
    return PVFS_sys_geteattr_list(ref, credentials, 1, key_p, &resp_p);
}

static int get_eattr_setup_msgpair(PINT_client_sm *sm_p,
                                           job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    int i;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
		"get_eattr state: get_eattr_setup_msgpair\n");

    /* this will be the array of value buffer sizes */
    sm_p->u.geteattr.size_array =
             (PVFS_size *)malloc(sm_p->u.geteattr.nkey *
                                 sizeof (PVFS_size));

    /* fill the array pulling out of the value array */
    /* we don't want to send the unused fields in this array */
    for (i = 0; i < sm_p->u.geteattr.nkey; i++)
        sm_p->u.geteattr.size_array[i] =
            sm_p->u.geteattr.resp_p->val_array[i].buffer_sz;

    PINT_SERVREQ_GETEATTR_FILL(
            sm_p->msgpair.req,
            (*sm_p->cred_p),
            sm_p->object_ref.fs_id,
            sm_p->object_ref.handle,
            sm_p->u.geteattr.nkey,
            sm_p->u.geteattr.key_array,
            sm_p->u.geteattr.size_array
            );

    sm_p->msgarray = &(sm_p->msgpair);
    sm_p->msgarray_count = 1;
    sm_p->msgpair.fs_id = sm_p->object_ref.fs_id;
    sm_p->msgpair.handle = sm_p->object_ref.handle;
    sm_p->msgpair.retry_flag = PVFS_MSGPAIR_RETRY;
    sm_p->msgpair.comp_fn = get_eattr_comp_fn;

    ret = PINT_cached_config_map_to_server(
            &sm_p->msgpair.svr_addr,
            sm_p->msgpair.handle,
            sm_p->msgpair.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = 0;
    }
    return 1;
}

static int get_eattr_cleanup(PINT_client_sm *sm_p,
                                    job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
		"get_eattr state: get_eattr_cleanup\n");
    /* free the array malloc'd above */
    free(sm_p->u.geteattr.size_array);
    sm_p->error_code  = js_p->error_code;
    if(sm_p->error_code != 0)
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }
    sm_p->op_complete = 1;

    return 0;
}

static int get_eattr_comp_fn(
    void *v_p,
    struct PVFS_server_resp *resp_p,
    int i)
{
    int j = 0;
    int ret = 0;
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
		"get_eattr completion fn: get_eattr_comp_fn\n");

    /* only posted one msgpair */
    assert(i==0);

    /* if this particular request was successful, then store the server
     * response and let the caller sort it out */

    /* recall that the returned val only has buffer and buffer_sz
     * encoded across the wire ... so the buffer_sz is actually the
     * read_sz ... the original buffer_sz is still in the original
     * val struct the user passed in
     */

    if (sm_p->msgarray[i].op_status == 0)
    {
        int k, mink;
        mink = sm_p->u.geteattr.nkey;
        if (resp_p->u.geteattr.nkey < mink)
        {
            mink = resp_p->u.geteattr.nkey;
            gossip_err("Successful call returned fewer values than requested\n");
        }
        if (!resp_p->u.geteattr.val)
        {
            gossip_err("Successful call returned NULL value list\n");
            return -1;
        }
        gossip_debug(GOSSIP_GETEATTR_DEBUG,"returned %d values\n",
                sm_p->u.geteattr.nkey);
        for (k = 0; k < sm_p->u.geteattr.nkey; k++)
        {
            gossip_debug(GOSSIP_GETEATTR_DEBUG,"resp_read_sz = %d\n",
                    resp_p->u.geteattr.val[k].read_sz);
            gossip_debug(GOSSIP_GETEATTR_DEBUG,"resp_buff_sz = %d\n",
                    resp_p->u.geteattr.val[k].buffer_sz);
            gossip_debug(GOSSIP_GETEATTR_DEBUG,"sm_buff_sz = %d\n",
                    sm_p->u.geteattr.resp_p->val_array[k].buffer_sz);
            gossip_debug(GOSSIP_GETEATTR_DEBUG,"resp_buff_ = %s\n",
                    (char *)resp_p->u.geteattr.val[k].buffer);
            /* out the actual read_sz in its place */
            sm_p->u.geteattr.resp_p->val_array[k].read_sz =
                    resp_p->u.geteattr.val[k].buffer_sz;
            /* check for too big a return message */
            if (sm_p->u.geteattr.resp_p->val_array[k].read_sz <=
                    sm_p->u.geteattr.resp_p->val_array[k].buffer_sz)
            {
                gossip_debug(GOSSIP_GETEATTR_DEBUG,"copying\n");
                memcpy(sm_p->u.geteattr.resp_p->val_array[k].buffer,
                        resp_p->u.geteattr.val[k].buffer,
                        sm_p->u.geteattr.resp_p->val_array[k].read_sz);
            }
            else /* oops, error! returned too much data */
            {
                gossip_debug(GOSSIP_GETEATTR_DEBUG,"clearing on error\n");
                memset(sm_p->u.geteattr.resp_p->val_array[k].buffer,0,
                        sm_p->u.geteattr.resp_p->val_array[k].buffer_sz);
                /* record an error, but keep going */
                ret = -PVFS_EMSGSIZE;
            }
        }
    }
    else
    {
        ret = sm_p->msgarray[i].op_status;
    }

    /* if this is the last response, check all of the status values
     * and return error code if any requests failed
     */
    if (i == (sm_p->msgarray_count -1))
    {
	for (j=0; j < sm_p->msgarray_count; j++)
	{
	    if (sm_p->msgarray[j].op_status != 0)
	    {
		return(sm_p->msgarray[j].op_status);
	    }
	}
    }
    return ret;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
