#
# Makefile stub for bmi_ib.
#
# Copyright (C) 2003-5 Pete Wyckoff <pw@osc.edu>
#
# See COPYING in top-level directory.
#
# $Id: module.mk.in,v 1.8 2006/02/22 16:30:54 pw Exp $
#

# only do any of this if configure decided to use IB
ifdef BUILD_IB

#
# Local definitions.
#
DIR := src/io/bmi/bmi_ib
cfiles := ib.c setup.c util.c mem.c
src := $(patsubst %,$(DIR)/%,$(cfiles))
cflags :=

#
# Export these to the top Makefile to tell it what to build.
#
LIBSRC    += $(src)
SERVERSRC += $(src)

#
# Add extra include paths and warnings just for these IB files.
# No need to expose the rest of the tree to the mess of IB include
# dirs and warnings used here.
#
cflags += -I
cflags += -fno-common
cflags += -Wall -W -Wpointer-arith
cflags += -Wcast-align -Wcast-qual -Wbad-function-cast
cflags += -Wmissing-prototypes -Wmissing-declarations
cflags += -Wnested-externs
cflags += -Wshadow -Wstrict-prototypes -Wredundant-decls
cflags += -Wundef -Wwrite-strings
# these are not otherwise defined and cause warnings
cflags += -DMAX_TRACE=0 -DMAX_ERROR=0 -DMAX_DEBUG=0

#
# One prototype in the mellanox includes specifies passing a u8 but that's
# not possible so this always throws a warning:
#   -Wconversion
#

#
# Tell the toplevel make about the extra cflags.
#
MODCFLAGS_$(DIR) := $(cflags)

endif  # BUILD_IB
