/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * Changes by Acxiom Corporation to add support for nonblocking statfs
 * Copyright  Acxiom Corporation, 2006.
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for statfs.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pvfs2-mgmt.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

/* state function prototypes */
static int sys_statfs_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);


static union PINT_state_array_values ST_run_nested[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_statfs_sm =
{
	ST_run_nested,
	"pvfs2_client_statfs_sm"
};
static union PINT_state_array_values ST_run_nested[] = {
(union PINT_state_array_values) "run_nested",
(union PINT_state_array_values) &pvfs2_client_statfs_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_mgmt_statfs_list_nested_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_statfs_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) sys_statfs_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

# 55 "src/client/sysint/sys-statfs.sm"


/** Initiate retrieval of file system statistics.
 */
PVFS_error PVFS_isys_statfs(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_sysresp_statfs *resp,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PINT_client_sm *sm_p = NULL;
    struct server_configuration_s *server_config = NULL;
    int ret = -1;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_isys_statfs entered\n");

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    /* count the number of servers */
    server_config = PINT_get_server_config_struct(fs_id);
    assert(server_config);
    ret = PINT_cached_config_count_servers(
        server_config, fs_id,  PVFS_MGMT_IO_SERVER|PVFS_MGMT_META_SERVER,
        &sm_p->u.statfs_list.count);
    PINT_put_server_config_struct(server_config);
    if (ret < 0)
    {
        free(sm_p);
	return ret;
    }

    /* allocate storage for addresses and statfs buffers */
    sm_p->u.statfs_list.addr_array = (PVFS_BMI_addr_t *)malloc(
        sm_p->u.statfs_list.count*sizeof(PVFS_BMI_addr_t));
    if (sm_p->u.statfs_list.addr_array == NULL)
    {
        free(sm_p);
        return -PVFS_ENOMEM;
    }

    sm_p->u.statfs_list.stat_array = (struct PVFS_mgmt_server_stat*)malloc(
        sm_p->u.statfs_list.count*sizeof(struct PVFS_mgmt_server_stat));
    if (!sm_p->u.statfs_list.stat_array)
    {
        free(sm_p->u.statfs_list.addr_array);
        free(sm_p);
	return(-PVFS_ENOMEM);
    }

    /* generate default list of servers */
    server_config = PINT_get_server_config_struct(fs_id);
    assert(server_config);
    ret = PINT_cached_config_get_server_array(
        server_config, fs_id, PVFS_MGMT_IO_SERVER|PVFS_MGMT_META_SERVER,
        sm_p->u.statfs_list.addr_array, &sm_p->u.statfs_list.count);
    PINT_put_server_config_struct(server_config);
    if (ret < 0)
    {
        free(sm_p->u.statfs_list.addr_array);
        free(sm_p->u.statfs_list.stat_array);
        free(sm_p);
	return ret;
    }

    PINT_init_msgarray_params(&sm_p->msgarray_params, fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.statfs_list.fs_id = fs_id;
    sm_p->u.statfs_list.details = NULL;
    sm_p->u.statfs_list.resp = resp;

    memset(sm_p->u.statfs_list.stat_array, 0,
           (sm_p->u.statfs_list.count * sizeof(struct PVFS_mgmt_server_stat)));

    sm_p->msgarray_count = sm_p->u.statfs_list.count;
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        (sm_p->msgarray_count * sizeof(PINT_sm_msgpair_state)));
    if (sm_p->msgarray == NULL)
    {
        PVFS_util_release_credentials(sm_p->cred_p);
        free(sm_p->u.statfs_list.addr_array);
        free(sm_p->u.statfs_list.stat_array);
        free(sm_p);
        return -PVFS_ENOMEM;
    }

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_STATFS, op_id, user_ptr);
}

/** Obtain file system statistics.
 */
PVFS_error PVFS_sys_statfs(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    PVFS_sysresp_statfs* resp)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_statfs entered\n");

    ret = PVFS_isys_statfs(
        fs_id, credentials, resp, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_statfs call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "statfs", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_sys_statfs completed\n");

    PINT_sys_release(op_id);
    return error;
}

static int sys_statfs_cleanup(PINT_client_sm *sm_p,
                                          job_status_s *js_p)
{
    int i;
    int num_io_servers = 0;
    PVFS_size min_bytes_available = 0;
    PVFS_size min_bytes_total = 0;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG, "statfs state: cleanup\n");

    sm_p->error_code = js_p->error_code;

    /* aggregate statistics down into one statfs structure */
    sm_p->u.statfs_list.resp->statfs_buf.fs_id = sm_p->u.statfs_list.fs_id;
    sm_p->u.statfs_list.resp->statfs_buf.bytes_available = 0;
    sm_p->u.statfs_list.resp->statfs_buf.bytes_total = 0;
    sm_p->u.statfs_list.resp->statfs_buf.handles_available_count = 0;
    sm_p->u.statfs_list.resp->statfs_buf.handles_total_count = 0;
    for(i=0; i<sm_p->u.statfs_list.count; i++)
    {
	if(sm_p->u.statfs_list.stat_array[i].server_type & PVFS_MGMT_IO_SERVER)
	{
	    num_io_servers++;
	    if(min_bytes_available == 0 || 
		min_bytes_available > sm_p->u.statfs_list.stat_array[i].bytes_available)
	    {
		min_bytes_available = sm_p->u.statfs_list.stat_array[i].bytes_available;
	    }
	    if(min_bytes_total == 0 || 
		min_bytes_total > sm_p->u.statfs_list.stat_array[i].bytes_total)
	    {
		min_bytes_total = sm_p->u.statfs_list.stat_array[i].bytes_total;
	    }
	}
	sm_p->u.statfs_list.resp->statfs_buf.handles_available_count 
	    += sm_p->u.statfs_list.stat_array[i].handles_available_count;
	sm_p->u.statfs_list.resp->statfs_buf.handles_total_count 
	    += sm_p->u.statfs_list.stat_array[i].handles_total_count;
    }
    sm_p->u.statfs_list.resp->statfs_buf.bytes_available = 
        min_bytes_available*num_io_servers;
    sm_p->u.statfs_list.resp->statfs_buf.bytes_total = 
        min_bytes_total*num_io_servers;
    sm_p->u.statfs_list.resp->server_count = sm_p->u.statfs_list.count;

    if(sm_p->u.statfs_list.stat_array)
    {
        free(sm_p->u.statfs_list.stat_array);
    }
    if(sm_p->u.statfs_list.addr_array)
    {
        free(sm_p->u.statfs_list.addr_array);
    }

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
