/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for removing an object and its
 *  associated directory entry.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "ncache.h"
#include "pvfs2-internal.h"

/*
  PVFS_{i}sys_remove takes the following steps:

  - rmdirent the entry from the parent directory
  - getattr on the object to be removed
  - if the object is a directory
    - check if the dir is empty
    - if so, continue
    - if not, crdirent the previously rmdirent'd
      entry and return -PVFS_ENOTEMPTY
  - if the object is a metafile
    - remove all associated data files
  - remove the actual object specified
*/

extern job_context_id pint_client_sm_context;

enum
{
    MSGPAIR_RETURN_SUCCESS = 1,
    RMDIRENT_RETRY,
    CRDIRENT_RETRY,
    RETURN_STORED_ERROR_CODE
};

static int remove_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_rmdirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_generic_timer(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_rmdirent_retry_or_fail(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_crdirent_retry_or_fail(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_crdirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_check_error_code(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int remove_rmdirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);
static int remove_crdirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

#define PRINT_REMOVE_WARNING()                                        \
do {                                                                  \
    gossip_err("WARNING: PVFS_sys_remove() encountered an error "     \
               "which may lead to\n  inconsistent state.\n");         \
    gossip_err("WARNING: PVFS2 fsck (if available) may be needed.\n");\
} while(0)

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_cleanup[];
static union PINT_state_array_values ST_do_remove[];
static union PINT_state_array_values ST_check_error_code[];
static union PINT_state_array_values ST_rmdirent_setup_msgpair[];
static union PINT_state_array_values ST_rmdirent_xfer_msgpair[];
static union PINT_state_array_values ST_rmdirent_retry_or_fail[];
static union PINT_state_array_values ST_rmdirent_timer[];
static union PINT_state_array_values ST_crdirent_timer[];
static union PINT_state_array_values ST_crdirent_retry_or_fail[];
static union PINT_state_array_values ST_crdirent_setup_msgpair[];
static union PINT_state_array_values ST_crdirent_xfer_msgpair[];
static union PINT_state_array_values ST_crdirent_failure[];

struct PINT_state_machine_s pvfs2_client_remove_sm =
{
	ST_init,
	"pvfs2_client_remove_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) "init",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_rmdirent_setup_msgpair
};

static union PINT_state_array_values ST_rmdirent_setup_msgpair[] = {
(union PINT_state_array_values) "rmdirent_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_rmdirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_rmdirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_rmdirent_retry_or_fail
};

static union PINT_state_array_values ST_rmdirent_xfer_msgpair[] = {
(union PINT_state_array_values) "rmdirent_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_do_remove,
(union PINT_state_array_values) MSGPAIR_RETURN_SUCCESS,
(union PINT_state_array_values) ST_do_remove,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_rmdirent_retry_or_fail
};

static union PINT_state_array_values ST_rmdirent_retry_or_fail[] = {
(union PINT_state_array_values) "rmdirent_retry_or_fail",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_rmdirent_retry_or_fail,
(union PINT_state_array_values) RMDIRENT_RETRY,
(union PINT_state_array_values) ST_rmdirent_timer,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_do_remove[] = {
(union PINT_state_array_values) "do_remove",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_check_error_code
};

static union PINT_state_array_values ST_check_error_code[] = {
(union PINT_state_array_values) "check_error_code",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_check_error_code,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) RETURN_STORED_ERROR_CODE,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_setup_msgpair
};

static union PINT_state_array_values ST_crdirent_timer[] = {
(union PINT_state_array_values) "crdirent_timer",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_generic_timer,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_setup_msgpair
};

static union PINT_state_array_values ST_rmdirent_timer[] = {
(union PINT_state_array_values) "rmdirent_timer",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_generic_timer,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_rmdirent_setup_msgpair
};

static union PINT_state_array_values ST_crdirent_setup_msgpair[] = {
(union PINT_state_array_values) "crdirent_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_crdirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_crdirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_retry_or_fail
};

static union PINT_state_array_values ST_crdirent_xfer_msgpair[] = {
(union PINT_state_array_values) "crdirent_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) MSGPAIR_RETURN_SUCCESS,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_retry_or_fail
};

static union PINT_state_array_values ST_crdirent_retry_or_fail[] = {
(union PINT_state_array_values) "crdirent_retry_or_fail",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_crdirent_retry_or_fail,
(union PINT_state_array_values) CRDIRENT_RETRY,
(union PINT_state_array_values) ST_crdirent_timer,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_remove_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 182 "src/client/sysint/sys-remove.sm"


/** Initiate removal of an object and its directory entry.
 */
PVFS_error PVFS_isys_remove(
    char *object_name,
    PVFS_object_ref parent_ref, 
    PVFS_credentials *credentials,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_remove entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) ||
        (object_name == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.remove.object_name = object_name;
    sm_p->parent_ref  = parent_ref;
    sm_p->u.remove.stored_error_code = 0;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Trying to remove entry %s under %llu,%d\n",
        object_name, llu(parent_ref.handle), parent_ref.fs_id);

    /* NOTE: This state machine previously multiplied the default job timeout
     * by five to allow for potentially long sync delays.  We instead now set
     * the default client BMI timeout higher for all operations: if a sync can 
     * go slow then so can any other arbitrary operation queued behind it. -PHC
     */
    
    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_REMOVE, op_id, user_ptr);
}

/** Remove an object and its directory entry.
 */
PVFS_error PVFS_sys_remove(
    char *object_name,
    PVFS_object_ref parent_ref, 
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_remove entered\n");

    ret = PVFS_isys_remove(object_name, parent_ref,
                           credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_remove call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "remove", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}


/****************************************************************/

static int remove_init(PINT_client_sm *sm_p,
		       job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: init\n");

    assert(js_p->error_code == 0);
    return 1;
}

static int remove_rmdirent_setup_msgpair(PINT_client_sm *sm_p,
					 job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    /* NOTE: we remove the dirent first because this gets the object
     * out of the system fastest.
     */
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: rmdirent_setup_msgpair\n");

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_RMDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->parent_ref.fs_id,
        sm_p->parent_ref.handle,
        sm_p->u.remove.object_name,
        0,
        PVFS_util_get_current_time(),
        PVFS_util_get_current_time());

    gossip_debug(GOSSIP_REMOVE_DEBUG, "- doing RMDIRENT on %s "
                 "under %llu,%d\n", sm_p->u.remove.object_name,
                 llu(sm_p->parent_ref.handle),
                 sm_p->parent_ref.fs_id);

    msg_p->fs_id = sm_p->parent_ref.fs_id;
    msg_p->handle = sm_p->parent_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = remove_rmdirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
	js_p->error_code = ret;
    }
    return 1;
}

static int remove_crdirent_setup_msgpair(PINT_client_sm *sm_p,
					 job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: crdirent_setup_msgpair\n");

    sm_p->u.remove.stored_error_code = js_p->error_code;

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_CRDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->u.remove.object_name,
        sm_p->object_ref.handle,
        sm_p->parent_ref.handle,
        sm_p->parent_ref.fs_id,
        0,
        PVFS_util_get_current_time(),
        PVFS_util_get_current_time());

    gossip_debug(GOSSIP_REMOVE_DEBUG, "- doing CRDIRENT of %s (%llu,%d) "
                 "under %llu,%d\n", sm_p->u.remove.object_name,
                 llu(sm_p->object_ref.handle),
                 sm_p->object_ref.fs_id,
                 llu(sm_p->parent_ref.handle),
                 sm_p->parent_ref.fs_id);

    msg_p->fs_id = sm_p->parent_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = remove_crdirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int remove_rmdirent_comp_fn(
    void *v_p,
    struct PVFS_server_resp *resp_p,
    int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;

    assert(resp_p->op == PVFS_SERV_RMDIRENT);

    if (resp_p->status == 0)
    {
        assert(resp_p->u.rmdirent.entry_handle != PVFS_HANDLE_NULL);
        assert(sm_p->parent_ref.fs_id != PVFS_FS_ID_NULL);

        /* pull handle out of response, also copy in fs_id from before */
        sm_p->object_ref.handle = resp_p->u.rmdirent.entry_handle;
        sm_p->object_ref.fs_id  = sm_p->parent_ref.fs_id;

        gossip_debug(
            GOSSIP_CLIENT_DEBUG,
            "  remove_rmdirent_comp_fn: metafile handle = %llu\n",
            llu(sm_p->object_ref.handle));
    }
    return resp_p->status;
}

static int remove_crdirent_comp_fn(
    void *v_p,
    struct PVFS_server_resp *resp_p,
    int index)
{
    assert(resp_p->op == PVFS_SERV_CRDIRENT);

    if (resp_p->status == 0)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG,
                     "  remove_crdirent_comp_fn: OK\n");
    }
    return resp_p->status;
}

static int remove_check_error_code(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    char buf[64] = {0};

    PVFS_strerror_r(js_p->error_code, buf, 64);
    gossip_debug(GOSSIP_REMOVE_DEBUG, "remove_check_error_code got %s "
                 "(%d)\n", buf, js_p->error_code);
    /*
      separate error codes which are ok to return to the caller at
      this point without trying to undo what we've done and retry the
      removal
    */
    switch(js_p->error_code)
    {
        case -PVFS_ENOTEMPTY:
            /* let the error pass through for the crdirent cleanup */
            break;
        case -PVFS_EINVAL:
        case -PVFS_ENOMEM:
            /* don't undo after these errors */
            sm_p->u.remove.stored_error_code = js_p->error_code;
            js_p->error_code = RETURN_STORED_ERROR_CODE;
            break;
    }
    return 1;
}

static int remove_cleanup(PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: cleanup\n");

    sm_p->error_code = (sm_p->u.remove.stored_error_code ?
                        sm_p->u.remove.stored_error_code :
                        js_p->error_code);

    /* NOTE: acache is invalidated by remove_helper now */

    PINT_ncache_remove(sm_p->u.remove.object_name,
                       0 /* PVFS2_LOOKUP_LINK_NO_FOLLOW */,
                       sm_p->parent_ref, NULL);

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    sm_p->op_complete = 1;
    return 0;
}

static int remove_generic_timer(PINT_client_sm *sm_p,
                                job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t tmp_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: generic_timer\n");

    ret = job_req_sched_post_timer(
	sm_p->msgarray_params.retry_delay, sm_p, 0, js_p, &tmp_id,
	pint_client_sm_context);

    return ret;
}

static int remove_crdirent_retry_or_fail(PINT_client_sm *sm_p,
                                         job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: crdirent_retry_or_fail\n");

    /* try again (up to a point) if we get a comm. failure. */
    if ((PVFS_ERROR_CLASS(-js_p->error_code) == PVFS_ERROR_BMI) &&
        (sm_p->u.remove.retry_count < sm_p->msgarray_params.retry_limit))
    {
	sm_p->u.remove.retry_count++;
	js_p->error_code = CRDIRENT_RETRY;
	return 1;
    }

    if ((js_p->error_code == -PVFS_EEXIST) &&
        (sm_p->u.remove.retry_count > 0))
    {
	/* assume everything worked out ok and we got the right
	 * directory entry back.  there was just a transient network
	 * problem along the way
	 */
	js_p->error_code = 0;
	return 1;
    }

    sm_p->u.remove.stored_error_code = js_p->error_code;

    PVFS_perror_gossip("Failed to replace directory entry!",
                       js_p->error_code);

    PRINT_REMOVE_WARNING();
    return 1;
}


static int remove_rmdirent_retry_or_fail(PINT_client_sm *sm_p,
                                         job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: rmdirent_retry_or_fail\n");

    /* try again (up to a point) if we get a comm. failure. */
    if ((PVFS_ERROR_CLASS(-js_p->error_code) == PVFS_ERROR_BMI) &&
	(sm_p->u.remove.retry_count < sm_p->msgarray_params.retry_limit))
    {
	sm_p->u.remove.retry_count++;
	js_p->error_code = RMDIRENT_RETRY;
	return 1;
    }

    if ((js_p->error_code == -PVFS_ENOENT) &&
        (sm_p->u.remove.retry_count > 0))
    {
	/* this is a tricky error case.  Server reports ENOENT, but
	 * this is not the first time we attempted the rmdirent.  It
	 * may be the case that it is reporting ENOENT because one of
	 * the earlier retries possibly completed.  We will treat this
	 * as success, but put out an error message.  This could
	 * strand objects, or remove non-empty directories, for
	 * example.
	 */
        PRINT_REMOVE_WARNING();
        js_p->error_code = 0;
        return 1;
    }

    /* other errors are preserved and passed along to the next state */
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
