/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for reading entries from a directory.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "ncache.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

static int readdir_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int readdir_msg_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int readdir_msg_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int readdir_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int readdir_msg_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_readdir_getattr[];
static union PINT_state_array_values ST_readdir_msg_setup_msgpair[];
static union PINT_state_array_values ST_readdir_msg_xfer_msgpair[];
static union PINT_state_array_values ST_readdir_msg_failure[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_readdir_sm =
{
	ST_init,
	"pvfs2_client_readdir_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) "init",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_readdir_getattr
};

static union PINT_state_array_values ST_readdir_getattr[] = {
(union PINT_state_array_values) "readdir_getattr",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_readdir_msg_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_readdir_msg_setup_msgpair[] = {
(union PINT_state_array_values) "readdir_msg_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_msg_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_readdir_msg_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_readdir_msg_failure
};

static union PINT_state_array_values ST_readdir_msg_xfer_msgpair[] = {
(union PINT_state_array_values) "readdir_msg_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_readdir_msg_failure
};

static union PINT_state_array_values ST_readdir_msg_failure[] = {
(union PINT_state_array_values) "readdir_msg_failure",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_msg_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_readdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 92 "src/client/sysint/sys-readdir.sm"


/** Initiate reading of entries from a directory.
 *
 *  \param token opaque value used to track position in directory
 *         when more than one read is required.
 *  \param pvfs_dirent_incount maximum number of entries to read, if
 *         available, starting from token.
 */
PVFS_error PVFS_isys_readdir(
    PVFS_object_ref ref,
    PVFS_ds_position token, 
    int32_t pvfs_dirent_incount,
    PVFS_credentials *credentials,
    PVFS_sysresp_readdir *resp,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_readdir entered\n");

    if ((ref.handle == PVFS_HANDLE_NULL) ||
        (ref.fs_id == PVFS_FS_ID_NULL) ||
        (resp == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    if (pvfs_dirent_incount > PVFS_REQ_LIMIT_DIRENT_COUNT)
    {
        gossip_lerr("PVFS_isys_readdir unable to handle request "
                    "for %d entries.\n", pvfs_dirent_incount);
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.readdir.pos_token = token;
    sm_p->u.readdir.dirent_limit = pvfs_dirent_incount;
    sm_p->u.readdir.readdir_resp = resp;
    sm_p->object_ref = ref;

    gossip_debug(GOSSIP_READDIR_DEBUG, "Doing readdir on handle "
                 "%llu on fs %d\n", llu(ref.handle), ref.fs_id);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_READDIR, op_id, user_ptr);
}

/** Read entries from a directory.
 *
 *  \param token opaque value used to track position in directory
 *         when more than one read is required.
 *  \param pvfs_dirent_incount maximum number of entries to read, if
 *         available, starting from token.
 */
PVFS_error PVFS_sys_readdir(
    PVFS_object_ref ref,
    PVFS_ds_position token, 
    int32_t pvfs_dirent_incount,
    PVFS_credentials *credentials,
    PVFS_sysresp_readdir *resp)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_readdir entered\n");

    ret = PVFS_isys_readdir(ref, token, pvfs_dirent_incount,
                            credentials, resp, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_readdir call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "readdir", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

/****************************************************************/

static int readdir_init(PINT_client_sm *sm_p,
                        job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "readdir state: init\n");

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_DIR_ALL,
        PVFS_TYPE_DIRECTORY,
        0);
    
    assert(js_p->error_code == 0);

    return 1;
}

static int readdir_msg_setup_msgpair(PINT_client_sm *sm_p,
                                     job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "readdir state: "
                 "readdir_msg_setup_msgpair\n");

    if (js_p->error_code)
    {
        return 1;
    }
    js_p->error_code = 0;

    gossip_debug(GOSSIP_READDIR_DEBUG," readdir: posting readdir req\n");

    gossip_debug(
        GOSSIP_READDIR_DEBUG, "%llu|%d | token is %d | limit is %d\n",
        llu(sm_p->object_ref.handle),
        sm_p->object_ref.fs_id,
        sm_p->u.readdir.pos_token,
        sm_p->u.readdir.dirent_limit);

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_READDIR_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->object_ref.handle,
        sm_p->u.readdir.pos_token,
        sm_p->u.readdir.dirent_limit);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
    msg_p->comp_fn = readdir_msg_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, sm_p->object_ref.handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int readdir_msg_comp_fn(void *v_p,
                               struct PVFS_server_resp *resp_p,
                               int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG, "readdir_msg_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_READDIR);

    if (resp_p->status != 0)
    {
	return resp_p->status;
    }

    /* convert servresp_readdir response to a sysresp_readdir obj */
    assert(sm_p->u.readdir.readdir_resp);

    sm_p->u.readdir.readdir_resp->token = resp_p->u.readdir.token;
    sm_p->u.readdir.readdir_resp->directory_version =
        resp_p->u.readdir.directory_version;
    sm_p->u.readdir.readdir_resp->pvfs_dirent_outcount =
        resp_p->u.readdir.dirent_count;
    if (sm_p->u.readdir.readdir_resp->pvfs_dirent_outcount > 0)
    {
        int dirent_array_len =
            (sizeof(PVFS_dirent) *
             sm_p->u.readdir.readdir_resp->pvfs_dirent_outcount);
#if 0
        int i = 0;
        PVFS_object_ref tmp_ref;
#endif
        /* this dirent_array MUST be freed by caller */
        sm_p->u.readdir.readdir_resp->dirent_array =
            malloc(dirent_array_len);
        assert(sm_p->u.readdir.readdir_resp->dirent_array);

        memcpy(sm_p->u.readdir.readdir_resp->dirent_array,
               resp_p->u.readdir.dirent_array, dirent_array_len);
#if 0
        /* insert all handles into the ncache while we have them */
        tmp_ref.fs_id = sm_p->object_ref.fs_id;
        for(i = 0;
            i < sm_p->u.readdir.readdir_resp->pvfs_dirent_outcount; i++)
        {
            tmp_ref.handle = resp_p->u.readdir.dirent_array[i].handle;
            PINT_ncache_insert(
                resp_p->u.readdir.dirent_array[i].d_name,
                0 /* PVFS2_LOOKUP_LINK_NO_FOLLOW */, tmp_ref,
                sm_p->object_ref);
        }
#endif
    }

    gossip_debug(GOSSIP_READDIR_DEBUG, "*** Got %d directory entries "
                 "[version %lld]\n",
                 sm_p->u.readdir.readdir_resp->pvfs_dirent_outcount,
                 lld(sm_p->u.readdir.readdir_resp->directory_version));

    return 0;
}

static int readdir_msg_failure(PINT_client_sm *sm_p,
                               job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "readdir state: readdir_msg_failure\n");
    return 1;
}

static int readdir_cleanup(PINT_client_sm *sm_p,
                           job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "readdir state: cleanup\n");

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    sm_p->error_code = js_p->error_code;
    if(sm_p->error_code != 0)
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }
    gossip_debug(GOSSIP_READDIR_DEBUG, " final return code is %d\n",
                 sm_p->error_code);

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
