/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * Changes by Acxiom Corporation to add setgid support
 * Copyright  Acxiom Corporation, 2005.
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for creating a new directory.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "ncache.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

enum
{
    MKDIR_RETRY = 180
};

static int mkdir_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_msg_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_msg_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_crdirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_crdirent_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_delete_handle_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mkdir_parent_getattr_inspect(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int mkdir_msg_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int mkdir_crdirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int mkdir_delete_handle_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_parent_getattr[];
static union PINT_state_array_values ST_parent_getattr_inspect[];
static union PINT_state_array_values ST_mkdir_msg_setup_msgpair[];
static union PINT_state_array_values ST_mkdir_msg_xfer_msgpair[];
static union PINT_state_array_values ST_mkdir_msg_failure[];
static union PINT_state_array_values ST_mkdir_crdirent_setup_msgpair[];
static union PINT_state_array_values ST_mkdir_crdirent_xfer_msgpair[];
static union PINT_state_array_values ST_mkdir_crdirent_failure[];
static union PINT_state_array_values ST_delete_handle_setup_msgpair[];
static union PINT_state_array_values ST_delete_handle_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mkdir_sm =
{
	ST_init,
	"pvfs2_client_mkdir_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) "init",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_parent_getattr
};

static union PINT_state_array_values ST_parent_getattr[] = {
(union PINT_state_array_values) "parent_getattr",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_parent_getattr_inspect,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_parent_getattr_inspect[] = {
(union PINT_state_array_values) "parent_getattr_inspect",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_parent_getattr_inspect,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_mkdir_msg_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_mkdir_msg_setup_msgpair[] = {
(union PINT_state_array_values) "mkdir_msg_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_msg_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_mkdir_msg_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_mkdir_msg_failure
};

static union PINT_state_array_values ST_mkdir_msg_xfer_msgpair[] = {
(union PINT_state_array_values) "mkdir_msg_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_mkdir_crdirent_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_mkdir_msg_failure
};

static union PINT_state_array_values ST_mkdir_msg_failure[] = {
(union PINT_state_array_values) "mkdir_msg_failure",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_msg_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_mkdir_crdirent_setup_msgpair[] = {
(union PINT_state_array_values) "mkdir_crdirent_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_crdirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_mkdir_crdirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_mkdir_crdirent_failure
};

static union PINT_state_array_values ST_mkdir_crdirent_xfer_msgpair[] = {
(union PINT_state_array_values) "mkdir_crdirent_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_mkdir_crdirent_failure
};

static union PINT_state_array_values ST_mkdir_crdirent_failure[] = {
(union PINT_state_array_values) "mkdir_crdirent_failure",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_crdirent_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handle_setup_msgpair
};

static union PINT_state_array_values ST_delete_handle_setup_msgpair[] = {
(union PINT_state_array_values) "delete_handle_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_delete_handle_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_delete_handle_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_delete_handle_xfer_msgpair[] = {
(union PINT_state_array_values) "delete_handle_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_mkdir_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_cleanup,
(union PINT_state_array_values) MKDIR_RETRY,
(union PINT_state_array_values) ST_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 159 "src/client/sysint/sys-mkdir.sm"


/** Initiate creation of a new directory.
 */
PVFS_error PVFS_isys_mkdir(
    char *object_name,
    PVFS_object_ref parent_ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sysresp_mkdir *resp,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_mkdir entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) ||
        (object_name == NULL) || (resp == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    if ((attr.mask & PVFS_ATTR_SYS_ALL_SETABLE) !=
        PVFS_ATTR_SYS_ALL_SETABLE)
    {
        gossip_lerr("PVFS_isys_mkdir() failure: invalid attributes "
                    "specified\n");
        return ret;
    }

    if ((strlen(object_name) + 1) > PVFS_REQ_LIMIT_SEGMENT_BYTES)
    {
        return -PVFS_ENAMETOOLONG;
    }

    sm_p = (PINT_client_sm *) malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.mkdir.object_name = object_name;
    PVFS_util_copy_sys_attr(&sm_p->u.mkdir.sys_attr, &attr);
    sm_p->u.mkdir.mkdir_resp = resp;
    sm_p->u.mkdir.stored_error_code = 0;
    sm_p->object_ref = parent_ref;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "Creating directory named %s "
                 "under parent handle %llu on fs %d\n", object_name,
                 llu(parent_ref.handle), parent_ref.fs_id);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_MKDIR, op_id, user_ptr);
}

/** Create a new directory.
 */
PVFS_error PVFS_sys_mkdir(
    char *object_name,
    PVFS_object_ref parent_ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sysresp_mkdir *resp)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_mkdir entered\n");

    ret = PVFS_isys_mkdir(object_name, parent_ref, attr,
                          credentials, resp, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_mkdir call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "mkdir", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

/****************************************************************/

static int mkdir_init(PINT_client_sm *sm_p,
                      job_status_s *js_p)
{
    job_id_t tmp_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: init\n");

    assert((js_p->error_code == 0) ||
           (js_p->error_code == MKDIR_RETRY));

    if (js_p->error_code == MKDIR_RETRY)
    {
        js_p->error_code = 0;

        return job_req_sched_post_timer(
            sm_p->msgarray_params.retry_delay, sm_p, 0, js_p, &tmp_id,
            pint_client_sm_context);
    }

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_COMMON_ALL, 
        PVFS_TYPE_DIRECTORY,
        0);

    return 1;
}

static int mkdir_msg_comp_fn(void *v_p,
                             struct PVFS_server_resp *resp_p,
                             int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    PVFS_object_attr attr;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir_msg_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_MKDIR);

    if (resp_p->status != 0)
    {
	return resp_p->status;
    }

    /* otherwise, just stash the newly created meta handle */
    sm_p->u.mkdir.metafile_handle = resp_p->u.mkdir.handle;

    /* also insert entry into attr cache */
    PINT_CONVERT_ATTR(&attr, &sm_p->u.mkdir.sys_attr, PVFS_ATTR_COMMON_ALL);
    PINT_acache_update(sm_p->object_ref, &attr, NULL);

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "*** Got newly created dir handle %llu\n",
        llu(sm_p->u.mkdir.metafile_handle));

    return 0;
}

static int mkdir_crdirent_comp_fn(void *v_p,
                                  struct PVFS_server_resp *resp_p,
                                  int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir_crdirent_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_CRDIRENT);
    return resp_p->status;
}

static int mkdir_delete_handle_comp_fn(void *v_p,
                                       struct PVFS_server_resp *resp_p,
                                       int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir_delete_handle_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_REMOVE);
    return resp_p->status;
}

static int mkdir_msg_setup_msgpair(PINT_client_sm *sm_p,
                                   job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_handle_extent_array meta_handle_extent_array;
    PINT_sm_msgpair_state *msg_p = NULL;
    struct server_configuration_s *server_config = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "mkdir state: mkdir_msg_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," mkdir: posting mkdir req\n");

    PINT_init_msgpair(sm_p, msg_p);

    server_config = PINT_get_server_config_struct(
        sm_p->object_ref.fs_id);

    ret = PINT_cached_config_get_next_meta(
        server_config, sm_p->object_ref.fs_id,
        &msg_p->svr_addr, &meta_handle_extent_array);

    PINT_put_server_config_struct(server_config);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
        return 1;
    }

    PINT_SERVREQ_MKDIR_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        meta_handle_extent_array,
        sm_p->u.mkdir.sys_attr,
        PVFS_ATTR_SYS_ALL_NOSIZE);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = meta_handle_extent_array.extent_array[0].first;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mkdir_msg_comp_fn;

    return 1;
}

static int mkdir_msg_failure(PINT_client_sm *sm_p,
                             job_status_s *js_p)
{
    sm_p->u.mkdir.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: mkdir_msg_failure\n");
    return 1;
}

static int mkdir_crdirent_setup_msgpair(PINT_client_sm *sm_p,
                                        job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "mkdir state: crdirent_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," mkdir: posting crdirent req\n");

    gossip_debug(GOSSIP_CLIENT_DEBUG, "hooking dirent %s (%llu) under "
                 "parent handle %llu\n", sm_p->u.mkdir.object_name,
                 llu(sm_p->u.mkdir.metafile_handle),
                 llu(sm_p->object_ref.handle));

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_CRDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->u.mkdir.object_name,
        sm_p->u.mkdir.metafile_handle,
        sm_p->object_ref.handle,
        sm_p->object_ref.fs_id,
        sm_p->u.mkdir.sys_attr.atime,
        sm_p->u.mkdir.sys_attr.mtime,
        sm_p->u.mkdir.sys_attr.ctime);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mkdir_crdirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, sm_p->object_ref.handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int mkdir_crdirent_failure(PINT_client_sm *sm_p,
				   job_status_s *js_p)
{
    sm_p->u.mkdir.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: crdirent_failure\n");

    PVFS_perror_gossip("mkdir crdirent failed", js_p->error_code);
    return 1;
}

static int mkdir_delete_handle_setup_msgpair(PINT_client_sm *sm_p,
                                             job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_BMI_addr_t metafile_server_addr;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: "
                 "delete_handle_setup_msgpair_array\n");

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    ret = PINT_cached_config_map_to_server(
        &metafile_server_addr, sm_p->u.mkdir.metafile_handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
        return 1;
    }

    PINT_SERVREQ_REMOVE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->u.mkdir.metafile_handle);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->u.mkdir.metafile_handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mkdir_delete_handle_comp_fn;
    msg_p->svr_addr = metafile_server_addr;

    gossip_debug(GOSSIP_CLIENT_DEBUG, " Preparing to remove "
                 "directory handle %llu\n", llu(msg_p->handle));
    return 1;
}

static int mkdir_cleanup(PINT_client_sm *sm_p,
                         job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: cleanup\n");

    PVFS_util_release_sys_attr(&sm_p->u.mkdir.sys_attr);

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    sm_p->error_code = (sm_p->u.mkdir.stored_error_code ?
                        sm_p->u.mkdir.stored_error_code :
                        js_p->error_code);

    if (sm_p->error_code == 0)
    {
        PVFS_object_ref directory_ref;

        directory_ref.handle = sm_p->u.mkdir.metafile_handle;
        directory_ref.fs_id = sm_p->object_ref.fs_id;

        sm_p->u.mkdir.mkdir_resp->ref.handle = directory_ref.handle;
        sm_p->u.mkdir.mkdir_resp->ref.fs_id = directory_ref.fs_id;

        /* insert newly created directory handle into the ncache */
        PINT_ncache_insert(sm_p->u.mkdir.object_name,
                           0 /* PVFS2_LOOKUP_LINK_NO_FOLLOW */,
                           directory_ref, sm_p->object_ref);
    }
    else if ((PVFS_ERROR_CLASS(-sm_p->error_code) == PVFS_ERROR_BMI) &&
             (sm_p->u.mkdir.retry_count < sm_p->msgarray_params.retry_limit))
    {
        sm_p->u.mkdir.stored_error_code = 0;
        sm_p->u.mkdir.retry_count++;

        gossip_debug(GOSSIP_CLIENT_DEBUG, "Retrying mkdir operation "
                     "(attempt number %d)\n", sm_p->u.mkdir.retry_count);

        js_p->error_code = MKDIR_RETRY;
        return 1;
    }
    else
    {
        PINT_acache_invalidate(sm_p->object_ref);
        PVFS_perror_gossip("mkdir failed with error", sm_p->error_code);
    }

    sm_p->op_complete = 1;
    return 0;
}

/** looks at the attributes of the parent directory and decides if it impacts
 *  the mkdir in any way
 */
static int mkdir_parent_getattr_inspect(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    PVFS_object_attr *attr = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "mkdir state: parent_getattr_inspect\n");

    attr = &sm_p->getattr.attr;
    assert(attr);

    gossip_debug(GOSSIP_CLIENT_DEBUG, "parent owner: %d, group: %d, perms: %d\n",
        (int)attr->owner, (int)attr->group, (int)attr->perms);

    /* do we have a setgid bit? */
    if(attr->perms & PVFS_G_SGID)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG, "parent has setgid bit set.\n");
        gossip_debug(GOSSIP_CLIENT_DEBUG, " - modifying requested attr for new file.\n");
        sm_p->u.mkdir.sys_attr.group = attr->group;
        sm_p->u.mkdir.sys_attr.perms |= PVFS_G_SGID;
        /* note that permission checking is left to server even in this case */
    }

    return(1);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
