/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for flushing data to disk on servers.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

static int flush_datafile_flush_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int flush_datafile_setup_msgpairarray(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int flush_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static union PINT_state_array_values ST_flush_getattr[];
static union PINT_state_array_values ST_flush_datafile_setup_msgpairarray[];
static union PINT_state_array_values ST_flush_datafile_xfer_msgpairarray[];
static union PINT_state_array_values ST_flush_datafile_flush_failure[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_flush_sm =
{
	ST_flush_getattr,
	"pvfs2_client_flush_sm"
};
static union PINT_state_array_values ST_flush_getattr[] = {
(union PINT_state_array_values) "flush_getattr",
(union PINT_state_array_values) &pvfs2_client_flush_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_flush_datafile_setup_msgpairarray,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_flush_datafile_setup_msgpairarray[] = {
(union PINT_state_array_values) "flush_datafile_setup_msgpairarray",
(union PINT_state_array_values) &pvfs2_client_flush_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_datafile_setup_msgpairarray,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_flush_datafile_xfer_msgpairarray,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_flush_datafile_xfer_msgpairarray[] = {
(union PINT_state_array_values) "flush_datafile_xfer_msgpairarray",
(union PINT_state_array_values) &pvfs2_client_flush_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_flush_datafile_flush_failure
};

static union PINT_state_array_values ST_flush_datafile_flush_failure[] = {
(union PINT_state_array_values) "flush_datafile_flush_failure",
(union PINT_state_array_values) &pvfs2_client_flush_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_datafile_flush_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_flush_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 79 "src/client/sysint/sys-flush.sm"


/** Initiate flushing of file data to storage on servers.
 */
PVFS_error PVFS_isys_flush(
    PVFS_object_ref ref,
    PVFS_credentials *credentials,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_flush entered\n");

    if ((ref.fs_id == PVFS_FS_ID_NULL) ||
        (ref.handle == PVFS_HANDLE_NULL))
    {
        gossip_err("Invalid handle/fs_id specified\n");
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (!sm_p)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->object_ref = ref;

    /* NOTE: This state machine previously multiplied the default job timeout
     * by five to allow for potentially long sync delays.  We instead now set
     * the default client BMI timeout higher for all operations: if a sync can 
     * go slow then so can any other arbitrary operation queued behind it. -PHC
     */

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        ref,
        PVFS_ATTR_META_ALL|PVFS_ATTR_COMMON_TYPE, 
        PVFS_TYPE_METAFILE,
        0);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_FLUSH, op_id, user_ptr);
}

/** Flush file data to storage on servers.
 */
PVFS_error PVFS_sys_flush(
    PVFS_object_ref ref,
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_flush entered\n");

    ret = PVFS_isys_flush(ref, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_flush call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "flush", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

static int flush_datafile_setup_msgpairarray(PINT_client_sm *sm_p,
                                             job_status_s *js_p)
{
    int ret = -PVFS_EINVAL, i = 0;
    PVFS_object_attr *attr = NULL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "(%p) flush state: "
                 "datafile_setup_msgpairarray\n", sm_p);

    js_p->error_code = 0;

    attr = &sm_p->getattr.attr;
    assert(attr);
    assert(attr->mask & PVFS_ATTR_META_DFILES);
    assert(attr->u.meta.dfile_count > 0);

    /* datafile count + 1 metafile */
    sm_p->msgarray_count = (attr->u.meta.dfile_count + 1);

    /* allocate memory for datafile message pairs and the metafile */
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        (sm_p->msgarray_count * sizeof(PINT_sm_msgpair_state)));
    if (!sm_p->msgarray)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    for(i = 0; i < sm_p->msgarray_count; i++)
    {
        msg_p = &sm_p->msgarray[i];

        if (i < attr->u.meta.dfile_count)
        {
            gossip_debug(GOSSIP_CLIENT_DEBUG,
                         "  datafile_flush: flushing handle %llu\n",
                         llu(attr->u.meta.dfile_array[i]));

            PINT_SERVREQ_FLUSH_FILL(msg_p->req,
                                    *sm_p->cred_p,
                                    sm_p->object_ref.fs_id,
                                    attr->u.meta.dfile_array[i]);

            msg_p->fs_id = sm_p->object_ref.fs_id;
            msg_p->handle = attr->u.meta.dfile_array[i];
            msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
            msg_p->comp_fn = NULL;
        }
        else
        {
            assert(i == (sm_p->msgarray_count - 1));

            gossip_debug(GOSSIP_CLIENT_DEBUG,
                         "  metafile_flush: flushing handle %llu\n",
                         llu(sm_p->object_ref.handle));

            PINT_SERVREQ_FLUSH_FILL(msg_p->req,
                                    *sm_p->cred_p,
                                    sm_p->object_ref.fs_id,
                                    sm_p->object_ref.handle);

            msg_p->fs_id = sm_p->object_ref.fs_id;
            msg_p->handle = sm_p->object_ref.handle;
            msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
            msg_p->comp_fn = NULL;
        }
    }

    ret = PINT_serv_msgpairarray_resolve_addrs(
        sm_p->msgarray_count, sm_p->msgarray);
    if (ret)
    {
        gossip_err("Error: failed to resolve server addresses.\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int flush_datafile_flush_failure(PINT_client_sm *sm_p,
                                        job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "(%p) flush state: datafile_flush_failure\n",
                 sm_p);
    return 1;
}

static int flush_cleanup(PINT_client_sm *sm_p,
                         job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "(%p) flush state: flush_cleanup\n", sm_p);

    sm_p->error_code = js_p->error_code;

    if(sm_p->error_code != 0)
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    if (sm_p->msgarray)
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
